/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RegistryServerConfiguration
implements Serializable {
    private String id;
    private String username;
    private String password;
    private Map<String, Object> configuration;

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    private RegistryServerConfiguration() {
    }

    public RegistryServerConfiguration(String id, String username, String decryptedPassword, Map<String, Object> configurationAsMap) {
        this.id = id;
        this.username = username;
        this.password = decryptedPassword;
        this.configuration = configurationAsMap;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static RegistryServerConfiguration getServer(List<RegistryServerConfiguration> settings, String serverId) {
        if (settings != null && !StringUtils.isBlank((CharSequence)serverId)) {
            for (RegistryServerConfiguration registryServerConfiguration : settings) {
                if (!registryServerConfiguration.getId().equalsIgnoreCase(serverId)) continue;
                return registryServerConfiguration;
            }
        }
        return null;
    }

    public static List<RegistryServerConfiguration> fetchListFromMap(Map<String, AbstractMap.SimpleEntry<AbstractMap.SimpleEntry<String, String>, Map<String, Object>>> registryServerConfigurationMap) {
        ArrayList<RegistryServerConfiguration> registryServerConfigurationList = new ArrayList<RegistryServerConfiguration>();
        for (Map.Entry<String, AbstractMap.SimpleEntry<AbstractMap.SimpleEntry<String, String>, Map<String, Object>>> entry : registryServerConfigurationMap.entrySet()) {
            registryServerConfigurationList.add(new RegistryServerConfiguration(entry.getKey(), entry.getValue().getKey().getKey(), entry.getValue().getKey().getValue(), entry.getValue().getValue()));
        }
        return registryServerConfigurationList;
    }

    public static class Builder {
        private RegistryServerConfiguration registryServerConfiguration;

        public Builder() {
            this.registryServerConfiguration = new RegistryServerConfiguration();
        }

        public Builder(RegistryServerConfiguration registryServerConfiguration) {
            if (registryServerConfiguration != null) {
                this.registryServerConfiguration = registryServerConfiguration;
            }
        }

        public Builder id(String id) {
            this.registryServerConfiguration.id = id;
            return this;
        }

        public Builder username(String username) {
            this.registryServerConfiguration.username = username;
            return this;
        }

        public Builder password(String password) {
            this.registryServerConfiguration.password = password;
            return this;
        }

        public Builder configuration(Map<String, Object> configuration) {
            this.registryServerConfiguration.configuration = configuration;
            return this;
        }

        public RegistryServerConfiguration build() {
            return this.registryServerConfiguration;
        }
    }
}

