/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class JKubeProjectPlugin
implements Serializable {
    private String groupId;
    private String artifactId;
    private String version;
    private Map<String, Object> configuration;
    private List<String> executions;

    private JKubeProjectPlugin() {
    }

    public JKubeProjectPlugin(String groupId, String artifactId, String version, Map<String, Object> configuration, List<String> executions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.configuration = configuration;
        this.executions = executions;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static JKubeProjectPlugin fromString(String pluginAsStr, Map<String, Object> pluginConfiguration) {
        String[] parts = pluginAsStr.split(",");
        if (parts.length == 3) {
            return new JKubeProjectPlugin(parts[0], parts[1], parts[2], pluginConfiguration, null);
        }
        if (parts.length == 4) {
            return new JKubeProjectPlugin(parts[0], parts[1], parts[2], pluginConfiguration, Arrays.asList(parts[3].split("\\|")));
        }
        return null;
    }

    public static List<JKubeProjectPlugin> listFromStringPlugins(List<AbstractMap.SimpleEntry<String, Map<String, Object>>> jkubePluginsAsStr) {
        ArrayList<JKubeProjectPlugin> plugins = new ArrayList<JKubeProjectPlugin>();
        for (AbstractMap.SimpleEntry<String, Map<String, Object>> commaSeparatedPlugins : jkubePluginsAsStr) {
            JKubeProjectPlugin jkubeProjectPlugin = JKubeProjectPlugin.fromString(commaSeparatedPlugins.getKey(), commaSeparatedPlugins.getValue());
            if (jkubeProjectPlugin == null) continue;
            plugins.add(jkubeProjectPlugin);
        }
        return plugins;
    }

    public List<String> getExecutions() {
        return this.executions;
    }

    public static class Builder {
        private JKubeProjectPlugin projectPlugin;

        public Builder() {
            this.projectPlugin = new JKubeProjectPlugin();
        }

        public Builder(JKubeProjectPlugin plugin) {
            if (plugin != null) {
                this.projectPlugin = plugin;
            }
        }

        public Builder groupId(String groupId) {
            this.projectPlugin.groupId = groupId;
            return this;
        }

        public Builder artifactId(String artifactId) {
            this.projectPlugin.artifactId = artifactId;
            return this;
        }

        public Builder version(String version) {
            this.projectPlugin.version = version;
            return this;
        }

        public Builder executions(List<String> executions) {
            this.projectPlugin.executions = executions;
            return this;
        }

        public Builder configuration(Map<String, Object> configuration) {
            this.projectPlugin.configuration = configuration;
            return this;
        }

        public JKubeProjectPlugin build() {
            return this.projectPlugin;
        }
    }
}

