/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JKubeProjectDependency
implements Serializable {
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String scope;
    private File file;

    public JKubeProjectDependency(String groupId, String artifactId, String version, String type, String scope, File file) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.scope = scope;
        this.file = file;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public static JKubeProjectDependency fromString(String jkubeDependencyAsString) {
        String[] parts = jkubeDependencyAsString.split(",");
        if (parts.length == 5) {
            return new JKubeProjectDependency(parts[0], parts[1], parts[2], parts[3], parts[4], null);
        }
        if (parts.length == 6) {
            return new JKubeProjectDependency(parts[0], parts[1], parts[2], parts[3], parts[4], new File(parts[5]));
        }
        return null;
    }

    public static List<JKubeProjectDependency> listFromStringDependencies(List<String> jkubeDependenciesAsStr) {
        ArrayList<JKubeProjectDependency> dependencies = new ArrayList<JKubeProjectDependency>();
        for (String commaSeparatedDependencies : jkubeDependenciesAsStr) {
            JKubeProjectDependency jkubeProjectDependency = JKubeProjectDependency.fromString(commaSeparatedDependencies);
            if (jkubeProjectDependency == null) continue;
            dependencies.add(jkubeProjectDependency);
        }
        return dependencies;
    }
}

