/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.eclipse.jkube.kit.common.JKubeProjectDependency;
import org.eclipse.jkube.kit.common.JKubeProjectPlugin;

public class JKubeProject
implements Serializable {
    private String name;
    private String groupId;
    private String artifactId;
    private String version;
    private String outputDirectory;
    private File baseDirectory;
    private String buildDirectory;
    private Properties properties;
    private List<String> compileClassPathElements;
    private List<JKubeProjectDependency> dependencies;
    private List<JKubeProjectDependency> dependenciesWithTransitive;
    private List<JKubeProjectPlugin> plugins;
    private String site;
    private String description;
    private String organizationName;
    private String documentationUrl;
    private String buildFinalName;
    private File artifact;
    private String localRepositoryBaseDirectory;
    private String packaging;
    private String issueManagementSystem;
    private String issueManagementUrl;
    private String scmUrl;
    private String scmTag;

    public String getName() {
        return this.name;
    }

    public List<String> getCompileClassPathElements() {
        return this.compileClassPathElements;
    }

    public void setCompileClassPathElements(List<String> compileClassPathElements) {
        this.compileClassPathElements = compileClassPathElements;
    }

    public List<JKubeProjectDependency> getDependencies() {
        return this.dependencies;
    }

    public List<JKubeProjectDependency> getDependenciesWithTransitive() {
        return this.dependenciesWithTransitive;
    }

    public void setDependencies(List<JKubeProjectDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public List<JKubeProjectPlugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<JKubeProjectPlugin> plugins) {
        this.plugins = plugins;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getSite() {
        return this.site;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public String getLocalRepositoryBaseDirectory() {
        return this.localRepositoryBaseDirectory;
    }

    public File getArtifact() {
        return this.artifact;
    }

    public String getBuildFinalName() {
        return this.buildFinalName;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    public String getScmTag() {
        return this.scmTag;
    }

    public String getIssueManagementSystem() {
        return this.issueManagementSystem;
    }

    public void setIssueManagementSystem(String issueManagementSystem) {
        this.issueManagementSystem = issueManagementSystem;
    }

    public String getIssueManagementUrl() {
        return this.issueManagementUrl;
    }

    public void setIssueManagementUrl(String issueManagementUrl) {
        this.issueManagementUrl = issueManagementUrl;
    }

    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    public void setScmTag(String scmTag) {
        this.scmTag = scmTag;
    }

    public static class Builder {
        private JKubeProject jkubeProject = new JKubeProject();

        public Builder() {
        }

        public Builder(JKubeProject project) {
            this.jkubeProject.plugins = project.getPlugins();
            this.jkubeProject.groupId = project.getGroupId();
            this.jkubeProject.artifactId = project.getArtifactId();
            this.jkubeProject.version = project.getVersion();
            this.jkubeProject.properties = project.getProperties();
            this.jkubeProject.compileClassPathElements = project.getCompileClassPathElements();
            this.jkubeProject.plugins = project.getPlugins();
            this.jkubeProject.dependencies = project.getDependencies();
        }

        public Builder name(String name) {
            this.jkubeProject.name = name;
            return this;
        }

        public Builder groupId(String groupId) {
            this.jkubeProject.groupId = groupId;
            return this;
        }

        public Builder artifactId(String artifactId) {
            this.jkubeProject.artifactId = artifactId;
            return this;
        }

        public Builder version(String version) {
            this.jkubeProject.version = version;
            return this;
        }

        public Builder properties(Properties properties) {
            this.jkubeProject.properties = properties;
            return this;
        }

        public Builder plugins(List<JKubeProjectPlugin> plugins) {
            this.jkubeProject.plugins = plugins;
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            this.jkubeProject.dependencies = JKubeProjectDependency.listFromStringDependencies(dependencies);
            return this;
        }

        public Builder dependenciesWithTransitive(List<String> dependencies) {
            this.jkubeProject.dependenciesWithTransitive = JKubeProjectDependency.listFromStringDependencies(dependencies);
            return this;
        }

        public Builder compileClassPathElements(List<String> compileClassPathElements) {
            this.jkubeProject.compileClassPathElements = compileClassPathElements;
            return this;
        }

        public Builder outputDirectory(String outputDirectory) {
            this.jkubeProject.outputDirectory = outputDirectory;
            return this;
        }

        public Builder buildDirectory(String buildDirectory) {
            this.jkubeProject.buildDirectory = buildDirectory;
            return this;
        }

        public Builder site(String websiteUrl) {
            this.jkubeProject.site = websiteUrl;
            return this;
        }

        public Builder description(String description) {
            this.jkubeProject.description = description;
            return this;
        }

        public Builder organization(String organization) {
            this.jkubeProject.organizationName = organization;
            return this;
        }

        public Builder baseDirectory(File baseDirectory) {
            this.jkubeProject.baseDirectory = baseDirectory;
            return this;
        }

        public Builder documentationUrl(String documentationUrl) {
            this.jkubeProject.documentationUrl = documentationUrl;
            return this;
        }

        public Builder artifact(File artifact) {
            this.jkubeProject.artifact = artifact;
            return this;
        }

        public Builder buildFinalName(String buildFinalName) {
            this.jkubeProject.buildFinalName = buildFinalName;
            return this;
        }

        public Builder localRepositoryBaseDirectory(String localRepositoryBaseDirectory) {
            this.jkubeProject.localRepositoryBaseDirectory = localRepositoryBaseDirectory;
            return this;
        }

        public Builder packaging(String packaging) {
            this.jkubeProject.packaging = packaging;
            return this;
        }

        public Builder issueManagementUrl(String issueManagementUrl) {
            this.jkubeProject.issueManagementUrl = issueManagementUrl;
            return this;
        }

        public Builder issueManagementSystem(String issueManagementSystem) {
            this.jkubeProject.issueManagementSystem = issueManagementSystem;
            return this;
        }

        public Builder scmUrl(String scmUrl) {
            this.jkubeProject.scmUrl = scmUrl;
            return this;
        }

        public Builder scmTag(String scmTag) {
            this.jkubeProject.scmTag = scmTag;
            return this;
        }

        public JKubeProject build() {
            return this.jkubeProject;
        }
    }
}

