/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;

public abstract class ExternalCommand {
    protected final KitLogger log;
    private final ExecutorService executor = Executors.newFixedThreadPool(2);
    private int statusCode;

    public ExternalCommand(KitLogger log) {
        this.log = log;
    }

    public void execute() throws IOException {
        this.execute(null);
    }

    public void execute(String processInput) throws IOException {
        Process process = this.startProcess();
        this.start();
        try {
            this.inputStreamPump(process.getOutputStream(), processInput);
            Future<IOException> stderrFuture = this.startStreamPump(process.getErrorStream());
            this.outputStreamPump(process.getInputStream());
            this.stopStreamPump(stderrFuture);
            this.checkProcessExit(process);
        }
        catch (IOException e) {
            process.destroy();
            throw e;
        }
        finally {
            this.end();
        }
        if (this.statusCode != 0) {
            throw new IOException(String.format("Process '%s' exited with status %d", this.getCommandAsString(), this.statusCode));
        }
    }

    protected void start() {
    }

    protected void end() {
    }

    protected int getStatusCode() {
        return this.statusCode;
    }

    private void checkProcessExit(Process process) {
        try {
            this.statusCode = process.waitFor();
            this.executor.shutdown();
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (IllegalThreadStateException e) {
            process.destroy();
            this.statusCode = -1;
        }
        catch (InterruptedException e) {
            process.destroy();
            this.statusCode = -1;
            Thread.currentThread().interrupt();
        }
    }

    private void inputStreamPump(OutputStream outputStream, String processInput) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));){
            if (processInput != null) {
                writer.write(processInput);
                writer.flush();
            }
        }
        catch (IOException e) {
            this.log.info("Failed to close process output stream: %s", e.getMessage());
        }
    }

    private Process startProcess() throws IOException {
        try {
            return Runtime.getRuntime().exec(this.getArgs());
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to start '%s' : %s", this.getCommandAsString(), e.getMessage()), e);
        }
    }

    protected String getCommandAsString() {
        return StringUtils.join((Object[])this.getArgs(), (String)" ");
    }

    protected abstract String[] getArgs();

    private void outputStreamPump(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.processLine(line);
            }
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to read process '%s' output: %s", this.getCommandAsString(), e.getMessage()), e);
        }
    }

    protected void processLine(String line) {
        this.log.verbose(line, new Object[0]);
    }

    private Future<IOException> startStreamPump(final InputStream errorStream) {
        return this.executor.submit(new Callable<IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public IOException call() {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));){
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            IOException iOException = null;
                            return iOException;
                        }
                        KitLogger kitLogger = ExternalCommand.this.log;
                        synchronized (kitLogger) {
                            ExternalCommand.this.log.warn(line, new Object[0]);
                        }
                    }
                }
                catch (IOException e) {
                    return e;
                }
            }
        });
    }

    private void stopStreamPump(Future<IOException> future) throws IOException {
        try {
            IOException e = future.get(2L, TimeUnit.SECONDS);
            if (e != null) {
                throw new IOException(String.format("Failed to read process '%s' error stream", this.getCommandAsString()), e);
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IOException(String.format("Failed to stop process '%s' error stream", this.getCommandAsString()), e);
        }
    }
}

