/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.sample;

import org.eclipse.gemoc.timeline.view.AbstractTimelineProvider;

public class SampleTimelineProvider
extends AbstractTimelineProvider {
    private int currentBranch;
    private int currentChoice;
    private int currentPossibleStep;
    private final SampleBranch[] branches = new SampleBranch[2];

    public SampleTimelineProvider() {
        int i = 0;
        while (i < this.branches.length) {
            this.branches[i] = new SampleBranch(i, i * 2, 100);
            ++i;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean loop = true;
                while (loop) {
                    loop = false;
                    int i = 0;
                    while (i < SampleTimelineProvider.this.branches.length) {
                        SampleBranch branch = SampleTimelineProvider.this.branches[i];
                        if (branch.canCreateChoice()) {
                            branch.createChoice();
                            loop = true;
                        }
                        ++i;
                    }
                }
            }
        }).start();
    }

    @Override
    public int getNumberOfBranches() {
        return this.branches.length;
    }

    @Override
    public int getStart(int branch) {
        return this.branches[branch].start;
    }

    @Override
    public String getTextAt(int branch) {
        return "branch " + branch;
    }

    @Override
    public int getEnd(int branch) {
        return this.getStart(branch) + this.branches[branch].size;
    }

    @Override
    public int getNumberOfPossibleStepsAt(int branch, int index) {
        return this.branches[branch].possibleSteps[index - this.getStart(branch)];
    }

    @Override
    public String getTextAt(int branch, int index) {
        return String.valueOf(index);
    }

    @Override
    public Object getAt(int branch, int index, int possibleStep) {
        return "something";
    }

    @Override
    public Object getAt(int branch, int index) {
        return "something";
    }

    @Override
    public int getSelectedPossibleStep(int branch, int index) {
        return this.branches[branch].selected[index - this.getStart(branch)];
    }

    @Override
    public String getTextAt(int branch, int index, int possibleStep) {
        return "possible step " + possibleStep;
    }

    @Override
    public int[][] getFollowings(int branch, int index, int possibleStep) {
        int[][] res;
        if (index - this.getStart(branch) < this.branches[branch].size - 1 && possibleStep == this.branches[branch].selected[index - this.getStart(branch)]) {
            int[][] tmp = new int[][]{{branch, this.branches[branch].selected[index + 1 - this.getStart(branch)]}};
            res = tmp;
        } else {
            int[][] tmp;
            res = tmp = new int[0][];
        }
        return res;
    }

    @Override
    public int[][] getPrecedings(int branch, int index, int possibleStep) {
        int[][] res;
        if (index - this.getStart(branch) > 0 && possibleStep == this.branches[branch].selected[index - this.getStart(branch)]) {
            int[][] tmp = new int[][]{{branch, this.branches[branch].selected[index - 1 - this.getStart(branch)]}};
            res = tmp;
        } else {
            int[][] tmp;
            res = tmp = new int[0][];
        }
        return res;
    }

    @Override
    public int getCurrentBranch() {
        return this.currentBranch;
    }

    @Override
    public int getCurrentChoice() {
        return this.currentChoice;
    }

    @Override
    public int getCurrentPossibleStep() {
        return this.currentPossibleStep;
    }

    private class SampleBranch {
        private static final int DELAY_MS = 300;
        private final int[] possibleSteps;
        private final int[] selected;
        private final int branch;
        private final int start;
        private int size;

        public SampleBranch(int branch, int start, int size) {
            this.start = start;
            this.possibleSteps = new int[size];
            this.selected = new int[size];
            this.branch = branch;
            int i = 0;
            while (i < this.possibleSteps.length) {
                this.possibleSteps[i] = -1;
                this.selected[i] = -1;
                ++i;
            }
        }

        public boolean canCreateChoice() {
            return this.size < this.possibleSteps.length;
        }

        public void createChoice() {
            try {
                int nbPossibleSteps;
                ++this.size;
                SampleTimelineProvider.this.notifyEndChanged(this.branch, this.size);
                int index = this.size - 1;
                Thread.sleep(300L);
                this.possibleSteps[index] = nbPossibleSteps = 1 + (int)(Math.random() * 5.0);
                SampleTimelineProvider.this.notifyNumberOfPossibleStepsAtChanged(this.branch, index, nbPossibleSteps);
                Thread.sleep(300L);
                this.selected[index] = (int)(Math.random() * (double)nbPossibleSteps);
                SampleTimelineProvider.this.notifyIsSelectedChanged(this.branch, index, this.selected[index], true);
                Thread.sleep(150L);
                if (index - 1 >= 0) {
                    int[][] tmp = new int[][]{{this.branch, this.selected[index]}};
                    SampleTimelineProvider.this.notifyFollowingsChanged(this.branch, index - 1, this.selected[index - 1], tmp);
                    Thread.sleep(150L);
                }
                SampleTimelineProvider.this.currentBranch = this.branch;
                SampleTimelineProvider.this.currentChoice = index;
                SampleTimelineProvider.this.currentPossibleStep = this.selected[index];
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

