/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.emf;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;

public class EObjectUtil {
    public static <T extends EObject> T eContainerOfType(EObject obj, Class<? extends T> type) {
        EObject result = null;
        EObject parent = obj.eContainer();
        if (obj.eContainer() != null) {
            result = type.isInstance(parent) ? (EObject)type.cast(parent) : (EObject)EObjectUtil.eContainerOfType(parent, type);
        }
        return (T)result;
    }

    public static String getResourceBasedName(EObject obj, boolean useFullResourcePath) {
        Resource res = obj.eResource();
        if (res == null) {
            if (obj.eIsProxy() && obj instanceof BasicEObjectImpl) {
                return ((BasicEObjectImpl)obj).eProxyURI().toString();
            }
            return null;
        }
        if (useFullResourcePath) {
            return String.valueOf(res.getURI().toPlatformString(true)) + res.getURIFragment(obj);
        }
        return String.valueOf(EObjectUtil.getUniqueResourceString(res)) + res.getURIFragment(obj);
    }

    public static String getUniqueResourceString(Resource res) {
        String shortName = res.getURI().lastSegment();
        if (res.getResourceSet().getResources().stream().filter(r -> r != res).anyMatch(r -> shortName.equals(r.getURI().lastSegment()))) {
            return res.getURI().toPlatformString(true);
        }
        return shortName;
    }
}

