/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages;

import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.NewGemocDebugRepresentationWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AddDebugRepresentationPage
extends WizardPage {
    private final NewGemocDebugRepresentationWizard newGemocDebugRepresentationWizard;
    private Combo debugLayerCombo;
    private String layerName;

    public AddDebugRepresentationPage(NewGemocDebugRepresentationWizard newGemocDebugRepresentationWizard) {
        super("Create Viewpoint definition project");
        this.newGemocDebugRepresentationWizard = newGemocDebugRepresentationWizard;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.debugLayerCombo = this.createDebugLayerComposite(composite);
        this.setControl((Control)composite);
    }

    private Combo createDebugLayerComposite(Composite composite) {
        Composite projectNameComposite = new Composite(composite, 0);
        projectNameComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectNameComposite.setLayout((Layout)layout);
        Label label = new Label(projectNameComposite, 0);
        label.setText("Debug layer:");
        final Combo combo = new Combo(projectNameComposite, 4);
        combo.setLayoutData((Object)new GridData(768));
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddDebugRepresentationPage.this.layerName = combo.getText();
                AddDebugRepresentationPage.this.setPageComplete(AddDebugRepresentationPage.this.layerName != null && AddDebugRepresentationPage.this.layerName.length() > 0);
            }
        });
        combo.setText("Debug");
        return combo;
    }

    public void setDiagram(DiagramDescription diagram) {
        this.debugLayerCombo.removeAll();
        if (diagram.getDefaultLayer() != null) {
            this.debugLayerCombo.add(diagram.getDefaultLayer().getName());
        }
        for (Layer layer : diagram.getAdditionalLayers()) {
            this.debugLayerCombo.add(layer.getName());
        }
        this.debugLayerCombo.setText("Debug");
    }

    public String getLayerName() {
        return this.layerName;
    }
}

