/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.extensions.sirius.command;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.Activator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.MappingBasedDecoration;
import org.eclipse.sirius.diagram.description.tool.ToolSection;
import org.eclipse.sirius.viewpoint.description.Customization;
import org.eclipse.sirius.viewpoint.description.DecorationDescriptionsSet;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.EReferenceCustomization;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.JavaExtension;
import org.eclipse.sirius.viewpoint.description.Position;
import org.eclipse.sirius.viewpoint.description.UserColor;
import org.eclipse.sirius.viewpoint.description.UserColorsPalette;
import org.eclipse.sirius.viewpoint.description.UserFixedColor;
import org.eclipse.sirius.viewpoint.description.VSMElementCustomization;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.PopupMenu;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.BundleException;

public class AddDebugLayerHandler
extends AbstractHandler {
    private static final String DEBUG_SERVICE_TEMPLATE_PATH = "org/eclipse/gemoc/xdsmlframework/extensions/sirius/command/debug_services_template.txt";
    private static final String PACKAGE_TAG = "PACKAGE";
    private static final String CLASS_NAME_TAG = "CLASS_NAME";
    private static final String LANGUAGE_NAME_TAG = "LANGUAGE_NAME";
    private static final String LAYER_NAME_TAG = "LAYER_NAME";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        try {
            if (selection != null & selection instanceof IStructuredSelection) {
                String layerName = "Debug";
                DiagramDescription diagramDescription = (DiagramDescription)((IStructuredSelection)selection).getFirstElement();
                IEditorInput input = HandlerUtil.getActiveEditorInputChecked((ExecutionEvent)event);
                IFile descriptionFile = (IFile)input.getAdapter(IFile.class);
                IProject project = descriptionFile.getProject();
                String projectName = project.getName();
                IFolder serviceFolder = project.getFolder((IPath)new Path("src/" + projectName.replaceAll("\\.", "/").toLowerCase() + "/services"));
                String languageName = diagramDescription.getName();
                String qualifiedServiceClassName = AddDebugLayerHandler.getOrCreateServiceClass(serviceFolder, projectName, languageName, "Debug", (IProgressMonitor)monitor);
                EditingDomain editingDomain = ((IEditingDomainProvider)diagramDescription.eResource().getResourceSet()).getEditingDomain();
                editingDomain.getCommandStack().execute((Command)new ChangeCommand((Notifier)diagramDescription.eResource(), (IProgressMonitor)monitor, diagramDescription, languageName, qualifiedServiceClassName){
                    private final /* synthetic */ IProgressMonitor val$monitor;
                    private final /* synthetic */ DiagramDescription val$diagramDescription;
                    private final /* synthetic */ String val$languageName;
                    private final /* synthetic */ String val$qualifiedServiceClassName;
                    {
                        this.val$monitor = iProgressMonitor;
                        this.val$diagramDescription = diagramDescription;
                        this.val$languageName = string;
                        this.val$qualifiedServiceClassName = string2;
                        super($anonymous0);
                    }

                    protected void doExecute() {
                        AddDebugLayerHandler.emfModifications(this.val$monitor, "Debug", this.val$diagramDescription, this.val$languageName, this.val$qualifiedServiceClassName);
                    }
                });
                AddDebugLayerHandler.updateManifest(project);
            }
        }
        catch (IOException e) {
            throw new ExecutionException("Error while creating the debug layer", (Throwable)e);
        }
        catch (CoreException e) {
            throw new ExecutionException("Error while creating the debug layer", (Throwable)e);
        }
        return null;
    }

    public static void updateManifest(IProject project) {
        ManifestChanger changer = new ManifestChanger(project);
        try {
            changer.addPluginDependency("org.eclipse.gemoc.executionframework.extensions.sirius");
            changer.addPluginDependency("org.eclipse.gemoc.execution.sequential.javaengine.ui");
            changer.commit();
        }
        catch (IOException | CoreException | BundleException e) {
            Activator.getMessagingSystem().error(e.getMessage(), "org.eclipse.gemoc.xdsmlframework.extensions.sirius", e);
        }
    }

    public static void emfModifications(IProgressMonitor monitor, String layerName, DiagramDescription description, String languageName, String qualifiedServiceClassName) {
        AddDebugLayerHandler.getOrCreateImport(description, qualifiedServiceClassName, monitor);
        UserColorsPalette palette = AddDebugLayerHandler.getOrCreateColotPalette(description, languageName, monitor);
        UserColor instructionColor = AddDebugLayerHandler.getOrCtreateInstructionColor(palette, monitor);
        AddDebugLayerHandler.getOrCreateDebugLayer(description, instructionColor, layerName, monitor);
    }

    public static void emfModifications(IProgressMonitor monitor, String layerName, DiagramExtensionDescription descriptionExtension, String languageName, String qualifiedServiceClassName) {
        AddDebugLayerHandler.getOrCreateImport(descriptionExtension, qualifiedServiceClassName, monitor);
        UserColorsPalette palette = AddDebugLayerHandler.getOrCreateColotPalette(descriptionExtension, languageName, monitor);
        UserColor instructionColor = AddDebugLayerHandler.getOrCtreateInstructionColor(palette, monitor);
        AddDebugLayerHandler.getOrCreateDebugLayer(descriptionExtension, instructionColor, layerName, monitor);
    }

    public static void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.getParent().exists()) {
            AddDebugLayerHandler.createFolder((IFolder)folder.getParent(), monitor);
        }
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
    }

    public static Layer getOrCreateDebugLayer(DiagramDescription description, UserColor instructionColor, String layerName, IProgressMonitor monitor) {
        Layer existingLayer = null;
        for (Layer layer : description.getAdditionalLayers()) {
            if (!"Debug".equals(layer.getName())) continue;
            existingLayer = layer;
            break;
        }
        Layer res = existingLayer != null ? existingLayer : AddDebugLayerHandler.createLayer(description, instructionColor, layerName, monitor);
        return res;
    }

    public static Layer getOrCreateDebugLayer(DiagramExtensionDescription descriptionExtension, UserColor instructionColor, String layerName, IProgressMonitor monitor) {
        Layer existingLayer = null;
        for (Layer layer : descriptionExtension.getLayers()) {
            if (!"Debug".equals(layer.getName())) continue;
            existingLayer = layer;
            break;
        }
        Layer res = existingLayer != null ? existingLayer : AddDebugLayerHandler.createLayer(descriptionExtension, instructionColor, layerName, monitor);
        return res;
    }

    public static Layer createLayer(DiagramDescription description, UserColor instructionColor, String layerName, IProgressMonitor monitor) {
        AdditionalLayer res = org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getDescriptionFactory().createAdditionalLayer();
        res.setName("Debug");
        res.setActiveByDefault(true);
        ToolSection toolSection = org.eclipse.sirius.diagram.description.tool.ToolPackage.eINSTANCE.getToolFactory().createToolSection();
        toolSection.setName("Debug");
        res.getToolSections().add((Object)toolSection);
        PopupMenu popupMenu = ToolPackage.eINSTANCE.getToolFactory().createPopupMenu();
        popupMenu.setName("Gemoc");
        toolSection.getOwnedTools().add((Object)popupMenu);
        OperationAction debugAction = ToolPackage.eINSTANCE.getToolFactory().createOperationAction();
        debugAction.setName("Debug");
        debugAction.setIcon("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/debug_exc.gif");
        popupMenu.getMenuItemDescription().add((Object)debugAction);
        ExternalJavaAction debugJavaAction = ToolPackage.eINSTANCE.getToolFactory().createExternalJavaAction();
        debugJavaAction.setName("Debug");
        debugJavaAction.setId("org.eclipse.gemoc.execution.sequential.javaengine.ui.debug.sirius.action.gemocDebugAs");
        debugJavaAction.setIcon("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/debug_exc.gif");
        InitialOperation initialOperation = ToolPackage.eINSTANCE.getToolFactory().createInitialOperation();
        initialOperation.setFirstModelOperations((ModelOperation)debugJavaAction);
        debugAction.setInitialOperation(initialOperation);
        OperationAction toggleBreakpointAction = ToolPackage.eINSTANCE.getToolFactory().createOperationAction();
        toggleBreakpointAction.setName("Toggle breakpoint");
        toggleBreakpointAction.setIcon("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/debug_exc.gif");
        popupMenu.getMenuItemDescription().add((Object)toggleBreakpointAction);
        ExternalJavaAction toggleBreakpointJavaAction = ToolPackage.eINSTANCE.getToolFactory().createExternalJavaAction();
        toggleBreakpointJavaAction.setName("Toggle Gemoc breakpoint");
        toggleBreakpointJavaAction.setId("org.eclipse.gemoc.execution.sequential.javaengine.ui.debug.sirius.action.GemocSequentialToggleBreakpointAction");
        toggleBreakpointJavaAction.setIcon("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/breakpoint.gif");
        initialOperation = ToolPackage.eINSTANCE.getToolFactory().createInitialOperation();
        initialOperation.setFirstModelOperations((ModelOperation)toggleBreakpointJavaAction);
        toggleBreakpointAction.setInitialOperation(initialOperation);
        OperationAction toggleConditionalBreakpointAction = ToolPackage.eINSTANCE.getToolFactory().createOperationAction();
        toggleConditionalBreakpointAction.setName("Toggle conditional breakpoint");
        toggleConditionalBreakpointAction.setIcon("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/debug_exc.gif");
        popupMenu.getMenuItemDescription().add((Object)toggleConditionalBreakpointAction);
        ExternalJavaAction toggleConditionalBreakpointJavaAction = ToolPackage.eINSTANCE.getToolFactory().createExternalJavaAction();
        toggleConditionalBreakpointJavaAction.setName("Toggle Gemoc conditional breakpoint");
        toggleConditionalBreakpointJavaAction.setId("org.eclipse.gemoc.execution.sequential.javaengine.ui.debug.sirius.action.GemocSequentialToggleConditionalBreakpointAction");
        toggleConditionalBreakpointJavaAction.setIcon("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/breakpoint.gif");
        initialOperation = ToolPackage.eINSTANCE.getToolFactory().createInitialOperation();
        initialOperation.setFirstModelOperations((ModelOperation)toggleConditionalBreakpointJavaAction);
        toggleConditionalBreakpointAction.setInitialOperation(initialOperation);
        DecorationDescriptionsSet decorationSet = DescriptionPackage.eINSTANCE.getDescriptionFactory().createDecorationDescriptionsSet();
        res.setDecorationDescriptionsSet(decorationSet);
        List<DiagramElementMapping> mappings = AddDebugLayerHandler.getAllMapping(description);
        MappingBasedDecoration enabledBreakpoint = org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getDescriptionFactory().createMappingBasedDecoration();
        enabledBreakpoint.setName("Enabled breakpoint");
        enabledBreakpoint.setPosition(Position.WEST_LITERAL);
        enabledBreakpoint.setImageExpression("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/breakpoint_enabled.gif");
        enabledBreakpoint.setPreconditionExpression("service:self.hasEnabledBreakpoint");
        enabledBreakpoint.getMappings().addAll(mappings);
        decorationSet.getDecorationDescriptions().add((Object)enabledBreakpoint);
        MappingBasedDecoration disabledBreakpoint = org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getDescriptionFactory().createMappingBasedDecoration();
        disabledBreakpoint.setName("Disabled breakpoint");
        disabledBreakpoint.setPosition(Position.WEST_LITERAL);
        disabledBreakpoint.setImageExpression("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/breakpoint_disabled.gif");
        disabledBreakpoint.setPreconditionExpression("service:self.hasDisabledBreakpoint");
        disabledBreakpoint.getMappings().addAll(mappings);
        decorationSet.getDecorationDescriptions().add((Object)disabledBreakpoint);
        Customization customization = DescriptionPackage.eINSTANCE.getDescriptionFactory().createCustomization();
        res.setCustomization(customization);
        VSMElementCustomization elementCustomization = DescriptionPackage.eINSTANCE.getDescriptionFactory().createVSMElementCustomization();
        elementCustomization.setPredicateExpression("service:self.isCurrentInstruction");
        customization.getVsmElementCustomizations().add((Object)elementCustomization);
        EReferenceCustomization borderColorCustomization = DescriptionPackage.eINSTANCE.getDescriptionFactory().createEReferenceCustomization();
        borderColorCustomization.setApplyOnAll(true);
        borderColorCustomization.setReferenceName("borderColor");
        borderColorCustomization.setValue((EObject)instructionColor);
        elementCustomization.getFeatureCustomizations().add((Object)borderColorCustomization);
        EReferenceCustomization strokeColorCustomization = DescriptionPackage.eINSTANCE.getDescriptionFactory().createEReferenceCustomization();
        strokeColorCustomization.setApplyOnAll(true);
        strokeColorCustomization.setReferenceName("strokeColor");
        strokeColorCustomization.setValue((EObject)instructionColor);
        elementCustomization.getFeatureCustomizations().add((Object)strokeColorCustomization);
        EReferenceCustomization labelColorCustomization = DescriptionPackage.eINSTANCE.getDescriptionFactory().createEReferenceCustomization();
        labelColorCustomization.setApplyOnAll(true);
        labelColorCustomization.setReferenceName("labelColor");
        labelColorCustomization.setValue((EObject)instructionColor);
        elementCustomization.getFeatureCustomizations().add((Object)labelColorCustomization);
        description.getAdditionalLayers().add((Object)res);
        return res;
    }

    public static Layer createLayer(DiagramExtensionDescription descriptionExtension, UserColor instructionColor, String layerName, IProgressMonitor monitor) {
        AdditionalLayer res = org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getDescriptionFactory().createAdditionalLayer();
        res.setName("Debug");
        res.setActiveByDefault(true);
        ToolSection toolSection = org.eclipse.sirius.diagram.description.tool.ToolPackage.eINSTANCE.getToolFactory().createToolSection();
        toolSection.setName("Debug");
        res.getToolSections().add((Object)toolSection);
        PopupMenu popupMenu = ToolPackage.eINSTANCE.getToolFactory().createPopupMenu();
        popupMenu.setName("Gemoc");
        toolSection.getOwnedTools().add((Object)popupMenu);
        OperationAction debugAction = ToolPackage.eINSTANCE.getToolFactory().createOperationAction();
        debugAction.setName("Debug");
        debugAction.setIcon("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/debug_exc.gif");
        popupMenu.getMenuItemDescription().add((Object)debugAction);
        ExternalJavaAction debugJavaAction = ToolPackage.eINSTANCE.getToolFactory().createExternalJavaAction();
        debugJavaAction.setName("Debug");
        debugJavaAction.setId("org.eclipse.gemoc.execution.sequential.javaengine.ui.debug.sirius.action.gemocDebugAs");
        debugJavaAction.setIcon("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/debug_exc.gif");
        InitialOperation initialOperation = ToolPackage.eINSTANCE.getToolFactory().createInitialOperation();
        initialOperation.setFirstModelOperations((ModelOperation)debugJavaAction);
        debugAction.setInitialOperation(initialOperation);
        OperationAction toogleBreakpointAction = ToolPackage.eINSTANCE.getToolFactory().createOperationAction();
        toogleBreakpointAction.setName("Toggle breakpoint");
        toogleBreakpointAction.setIcon("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/debug_exc.gif");
        popupMenu.getMenuItemDescription().add((Object)toogleBreakpointAction);
        ExternalJavaAction toogleBreakpointJavaAction = ToolPackage.eINSTANCE.getToolFactory().createExternalJavaAction();
        toogleBreakpointJavaAction.setName("Toggle Gemoc breakpoint");
        toogleBreakpointJavaAction.setId("org.eclipse.gemoc.execution.sequential.javaengine.ui.debug.sirius.action.GemocSequentialToggleBreakpointAction");
        toogleBreakpointJavaAction.setIcon("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/breakpoint.gif");
        initialOperation = ToolPackage.eINSTANCE.getToolFactory().createInitialOperation();
        initialOperation.setFirstModelOperations((ModelOperation)toogleBreakpointJavaAction);
        toogleBreakpointAction.setInitialOperation(initialOperation);
        DecorationDescriptionsSet decorationSet = DescriptionPackage.eINSTANCE.getDescriptionFactory().createDecorationDescriptionsSet();
        res.setDecorationDescriptionsSet(decorationSet);
        OperationAction toggleConditionalBreakpointAction = ToolPackage.eINSTANCE.getToolFactory().createOperationAction();
        toggleConditionalBreakpointAction.setName("Toggle conditional breakpoint");
        toggleConditionalBreakpointAction.setIcon("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/debug_exc.gif");
        popupMenu.getMenuItemDescription().add((Object)toggleConditionalBreakpointAction);
        ExternalJavaAction toggleConditionalBreakpointJavaAction = ToolPackage.eINSTANCE.getToolFactory().createExternalJavaAction();
        toggleConditionalBreakpointJavaAction.setName("Toggle Gemoc conditional breakpoint");
        toggleConditionalBreakpointJavaAction.setId("org.eclipse.gemoc.execution.sequential.javaengine.ui.debug.sirius.action.GemocSequentialToggleConditionalBreakpointAction");
        toggleConditionalBreakpointJavaAction.setIcon("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/breakpoint.gif");
        initialOperation = ToolPackage.eINSTANCE.getToolFactory().createInitialOperation();
        initialOperation.setFirstModelOperations((ModelOperation)toggleConditionalBreakpointJavaAction);
        toggleConditionalBreakpointAction.setInitialOperation(initialOperation);
        List<DiagramElementMapping> mappings = AddDebugLayerHandler.getAllMapping(descriptionExtension);
        MappingBasedDecoration enabledBreakpoint = org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getDescriptionFactory().createMappingBasedDecoration();
        enabledBreakpoint.setName("Enabled breakpoint");
        enabledBreakpoint.setPosition(Position.WEST_LITERAL);
        enabledBreakpoint.setImageExpression("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/breakpoint_enabled.gif");
        enabledBreakpoint.setPreconditionExpression("service:self.hasEnabledBreakpoint");
        enabledBreakpoint.getMappings().addAll(mappings);
        decorationSet.getDecorationDescriptions().add((Object)enabledBreakpoint);
        MappingBasedDecoration disabledBreakpoint = org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getDescriptionFactory().createMappingBasedDecoration();
        disabledBreakpoint.setName("Disabled breakpoint");
        disabledBreakpoint.setPosition(Position.WEST_LITERAL);
        disabledBreakpoint.setImageExpression("/org.eclipse.gemoc.executionframework.extensions.sirius/icons/breakpoint_disabled.gif");
        disabledBreakpoint.setPreconditionExpression("service:self.hasDisabledBreakpoint");
        disabledBreakpoint.getMappings().addAll(mappings);
        decorationSet.getDecorationDescriptions().add((Object)disabledBreakpoint);
        Customization customization = DescriptionPackage.eINSTANCE.getDescriptionFactory().createCustomization();
        res.setCustomization(customization);
        VSMElementCustomization elementCustomization = DescriptionPackage.eINSTANCE.getDescriptionFactory().createVSMElementCustomization();
        elementCustomization.setPredicateExpression("service:self.isCurrentInstruction");
        customization.getVsmElementCustomizations().add((Object)elementCustomization);
        EReferenceCustomization borderColorCustomization = DescriptionPackage.eINSTANCE.getDescriptionFactory().createEReferenceCustomization();
        borderColorCustomization.setApplyOnAll(true);
        borderColorCustomization.setReferenceName("borderColor");
        borderColorCustomization.setValue((EObject)instructionColor);
        elementCustomization.getFeatureCustomizations().add((Object)borderColorCustomization);
        EReferenceCustomization strokeColorCustomization = DescriptionPackage.eINSTANCE.getDescriptionFactory().createEReferenceCustomization();
        strokeColorCustomization.setApplyOnAll(true);
        strokeColorCustomization.setReferenceName("strokeColor");
        strokeColorCustomization.setValue((EObject)instructionColor);
        elementCustomization.getFeatureCustomizations().add((Object)strokeColorCustomization);
        EReferenceCustomization labelColorCustomization = DescriptionPackage.eINSTANCE.getDescriptionFactory().createEReferenceCustomization();
        labelColorCustomization.setApplyOnAll(true);
        labelColorCustomization.setReferenceName("labelColor");
        labelColorCustomization.setValue((EObject)instructionColor);
        elementCustomization.getFeatureCustomizations().add((Object)labelColorCustomization);
        descriptionExtension.getLayers().add((Object)res);
        return res;
    }

    public static List<DiagramElementMapping> getAllMapping(DiagramDescription description) {
        ArrayList<DiagramElementMapping> res = new ArrayList<DiagramElementMapping>();
        TreeIterator it = description.eAllContents();
        while (it.hasNext()) {
            EObject eObj = (EObject)it.next();
            if (!(eObj instanceof DiagramElementMapping)) continue;
            res.add((DiagramElementMapping)eObj);
        }
        return res;
    }

    public static List<DiagramElementMapping> getAllMapping(DiagramExtensionDescription descriptionExtension) {
        ArrayList<DiagramElementMapping> res = new ArrayList<DiagramElementMapping>();
        TreeIterator it = descriptionExtension.eAllContents();
        while (it.hasNext()) {
            EObject eObj = (EObject)it.next();
            if (!(eObj instanceof DiagramElementMapping)) continue;
            res.add((DiagramElementMapping)eObj);
        }
        return res;
    }

    public static UserColor getOrCtreateInstructionColor(UserColorsPalette palette, IProgressMonitor monitor) {
        UserColor res;
        UserColor existingColor = null;
        for (UserColor color : palette.getEntries()) {
            if (!"current instruction".equals(color.getName())) continue;
            existingColor = color;
            break;
        }
        if (existingColor != null) {
            res = existingColor;
        } else {
            UserFixedColor fixedColor = DescriptionPackage.eINSTANCE.getDescriptionFactory().createUserFixedColor();
            fixedColor.setName("current instruction");
            fixedColor.setRed(255);
            fixedColor.setGreen(255);
            fixedColor.setBlue(0);
            palette.getEntries().add((Object)fixedColor);
            res = fixedColor;
        }
        return res;
    }

    public static UserColorsPalette getOrCreateColotPalette(DiagramDescription description, String languageName, IProgressMonitor monitor) {
        UserColorsPalette res;
        String paletteName = String.valueOf(languageName) + " Palette";
        Group group = (Group)description.eContainer().eContainer();
        UserColorsPalette existingPalette = null;
        for (UserColorsPalette palette : group.getUserColorsPalettes()) {
            if (!paletteName.equals(palette.getName())) continue;
            existingPalette = palette;
            break;
        }
        if (existingPalette != null) {
            res = existingPalette;
        } else {
            res = DescriptionPackage.eINSTANCE.getDescriptionFactory().createUserColorsPalette();
            res.setName(paletteName);
            group.getUserColorsPalettes().add((Object)res);
        }
        return res;
    }

    public static UserColorsPalette getOrCreateColotPalette(DiagramExtensionDescription descriptionExtension, String languageName, IProgressMonitor monitor) {
        UserColorsPalette res;
        String paletteName = String.valueOf(languageName) + " Palette";
        Group group = (Group)descriptionExtension.eContainer().eContainer();
        UserColorsPalette existingPalette = null;
        for (UserColorsPalette palette : group.getUserColorsPalettes()) {
            if (!paletteName.equals(palette.getName())) continue;
            existingPalette = palette;
            break;
        }
        if (existingPalette != null) {
            res = existingPalette;
        } else {
            res = DescriptionPackage.eINSTANCE.getDescriptionFactory().createUserColorsPalette();
            res.setName(paletteName);
            group.getUserColorsPalettes().add((Object)res);
        }
        return res;
    }

    public static JavaExtension getOrCreateImport(DiagramDescription description, String qualifiedClassName, IProgressMonitor monitor) {
        JavaExtension res;
        Viewpoint viewPoint = (Viewpoint)description.eContainer();
        JavaExtension existingExtension = null;
        for (JavaExtension javaExt : viewPoint.getOwnedJavaExtensions()) {
            if (!qualifiedClassName.equals(javaExt.getQualifiedClassName())) continue;
            existingExtension = javaExt;
            break;
        }
        if (existingExtension != null) {
            res = existingExtension;
        } else {
            res = DescriptionPackage.eINSTANCE.getDescriptionFactory().createJavaExtension();
            res.setQualifiedClassName(qualifiedClassName);
            viewPoint.getOwnedJavaExtensions().add((Object)res);
        }
        return res;
    }

    public static JavaExtension getOrCreateImport(DiagramExtensionDescription descriptionExtension, String qualifiedClassName, IProgressMonitor monitor) {
        JavaExtension res;
        Viewpoint viewPoint = (Viewpoint)descriptionExtension.eContainer();
        JavaExtension existingExtension = null;
        for (JavaExtension javaExt : viewPoint.getOwnedJavaExtensions()) {
            if (!qualifiedClassName.equals(javaExt.getQualifiedClassName())) continue;
            existingExtension = javaExt;
            break;
        }
        if (existingExtension != null) {
            res = existingExtension;
        } else {
            res = DescriptionPackage.eINSTANCE.getDescriptionFactory().createJavaExtension();
            res.setQualifiedClassName(qualifiedClassName);
            viewPoint.getOwnedJavaExtensions().add((Object)res);
        }
        return res;
    }

    public static String getOrCreateServiceClass(IFolder serviceFolder, String projectName, String languageName, String layerName, IProgressMonitor monitor) throws IOException, CoreException {
        String className = String.valueOf(AddDebugLayerHandler.toCamelCase(languageName.replaceAll("\\W", ""))) + "DebugServices";
        IFile classFile = serviceFolder.getFile((IPath)new Path(String.valueOf(className) + ".java"));
        String packageName = String.valueOf(projectName) + ".services";
        String res = String.valueOf(packageName) + "." + className;
        if (!classFile.exists()) {
            if (!serviceFolder.exists()) {
                AddDebugLayerHandler.createFolder(serviceFolder, monitor);
            }
            AddDebugLayerHandler.createServiceClass(classFile, packageName, className, languageName, layerName, monitor);
        } else {
            AddDebugLayerHandler.addStringCoupleIfNeeded(classFile, languageName, layerName, monitor);
        }
        return res;
    }

    public static void addStringCoupleIfNeeded(IFile classFile, String languageName, String layerName, IProgressMonitor monitor) throws IOException, CoreException {
        int index;
        String statement;
        String content = AddDebugLayerHandler.getContent(classFile.getContents(), "UTF8");
        if (!content.contains(statement = "res.add(new StringCouple(\"" + languageName + "\", \"" + layerName + "\"));") && (index = content.lastIndexOf("res.add(new StringCouple(")) >= 0) {
            index += "res.add(new StringCouple(".length();
            while (content.charAt(index) != ';') {
                ++index;
            }
            String newContent = String.valueOf(content.substring(0, index)) + "\n\t\t" + statement + "\n" + content.substring(index, content.length());
            AddDebugLayerHandler.setContent(classFile.getFullPath().toFile(), "UTF8", newContent);
            classFile.refreshLocal(1, monitor);
        }
    }

    public static void createServiceClass(IFile classFile, String packageName, String className, String languageName, String layerName, IProgressMonitor monitor) throws IOException, CoreException {
        String content = AddDebugLayerHandler.getContent(AddDebugLayerHandler.class.getClassLoader().getResourceAsStream(DEBUG_SERVICE_TEMPLATE_PATH), "UTF8");
        content = content.replaceFirst(PACKAGE_TAG, packageName);
        content = content.replaceFirst(CLASS_NAME_TAG, className);
        content = content.replaceFirst(LANGUAGE_NAME_TAG, languageName);
        content = content.replaceFirst(LAYER_NAME_TAG, layerName);
        classFile.create((InputStream)new ByteArrayInputStream(content.getBytes(Charset.forName("UTF8"))), true, monitor);
    }

    public static String toCamelCase(String s) {
        String[] parts = s.split("_");
        String camelCaseString = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() > 0) {
                camelCaseString = String.valueOf(camelCaseString) + part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase();
            }
            ++n2;
        }
        return camelCaseString;
    }

    public static String getContent(InputStream inputStream, String charsetName) throws IOException {
        int len = 1024;
        StringBuilder res = new StringBuilder(len);
        if (len != 0) {
            InputStreamReader input = new InputStreamReader((InputStream)new BufferedInputStream(inputStream), charsetName);
            char[] buffer = new char[len];
            int length = input.read(buffer);
            while (length != -1) {
                res.append(buffer, 0, length);
                length = input.read(buffer);
            }
            input.close();
        }
        return res.toString();
    }

    public static void setContent(File file, String charsetName, String content) throws IOException {
        if (!file.exists()) {
            throw new IOException(String.valueOf(file.getAbsolutePath()) + " doesn't exists.");
        }
        if (file.isDirectory()) {
            throw new IOException(String.valueOf(file.getAbsolutePath()) + " is a directory.");
        }
        if (!file.canWrite()) {
            throw new IOException(String.valueOf(file.getAbsolutePath()) + " is not writable.");
        }
        FileOutputStream fos = null;
        OutputStreamWriter output = null;
        try {
            fos = new FileOutputStream(file);
            output = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fos), charsetName);
            output.write(content.toString());
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }
}

