/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.ui.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class FilteredFileContentProvider
extends WorkbenchContentProvider {
    private final String[] extensions;

    public FilteredFileContentProvider(String[] extensions) {
        this.extensions = extensions;
    }

    public Object[] getChildren(Object element) {
        List<Object> children = Arrays.asList(super.getChildren(element));
        ArrayList<Object> filteredChildren = new ArrayList<Object>(children);
        for (Object child : children) {
            if (!(child instanceof IFile) || this.isAccepted((IFile)child)) continue;
            filteredChildren.remove(child);
        }
        return filteredChildren.toArray();
    }

    private boolean isAccepted(IFile child) {
        boolean res = false;
        String[] stringArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (extension.equalsIgnoreCase(child.getFileExtension())) {
                res = true;
                break;
            }
            ++n2;
        }
        return res;
    }
}

