/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.helper.delete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.delete.IDeleteHook;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.internal.helper.delete.DeleteHookDescriptorRegistry;
import org.eclipse.sirius.business.internal.helper.delete.IDeleteHookDescriptor;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.tool.DeleteElementDescription;
import org.eclipse.sirius.diagram.description.tool.DeleteHook;
import org.eclipse.sirius.diagram.description.tool.DeleteHookParameter;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class DeleteHookHelper {
    private Collection<DSemanticDecorator> selection;
    private List<IDeleteHook> hooks;
    private Collection<DeleteHook> deleteHooks;

    public DeleteHookHelper(Collection<DSemanticDecorator> selection) {
        this.selection = selection;
    }

    public boolean checkDeleteHook() {
        if (this.shouldCallDeleteHook()) {
            return this.callDeleteHooks();
        }
        return true;
    }

    private boolean shouldCallDeleteHook() {
        this.computeUniqueHooks();
        if (!this.deleteHooks.isEmpty()) {
            this.hooks = new ArrayList<IDeleteHook>();
            for (DeleteHook deleteHook : this.deleteHooks) {
                IDeleteHookDescriptor descriptorFromId = DeleteHookDescriptorRegistry.getDescriptorFromId((String)deleteHook.getId());
                if (descriptorFromId == null || descriptorFromId.getIDeleteHook() == null) continue;
                IDeleteHook iDeleteHook = descriptorFromId.getIDeleteHook();
                this.hooks.add(iDeleteHook);
            }
            return !this.hooks.isEmpty();
        }
        return false;
    }

    private boolean callDeleteHooks() {
        for (DeleteHook deleteHook : this.deleteHooks) {
            for (IDeleteHook hook : this.hooks) {
                IStatus status = hook.beforeDeleteCommandExecution(this.selection, this.getParameters(deleteHook));
                if (status.getSeverity() != 8) continue;
                return false;
            }
        }
        return true;
    }

    private Map<String, Object> getParameters(DeleteHook deleteHook) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)this.selection.iterator().next().getTarget());
        RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
        for (DeleteHookParameter parameter : deleteHook.getParameters()) {
            Object value = null;
            if (this.selection.size() == 1) {
                value = safeInterpreter.evaluate((EObject)this.selection.iterator().next(), (EObject)parameter, (EStructuralFeature)ToolPackage.eINSTANCE.getExternalJavaActionParameter_Value());
            } else {
                value = new ArrayList(this.selection.size());
                for (DSemanticDecorator semanticDecorator : this.selection) {
                    Object val = safeInterpreter.evaluate((EObject)semanticDecorator, (EObject)parameter, (EStructuralFeature)ToolPackage.eINSTANCE.getExternalJavaActionParameter_Value());
                    if (val == null) continue;
                    ((List)value).add(val);
                }
            }
            parameters.put(parameter.getName(), value);
        }
        return parameters;
    }

    private void computeUniqueHooks() {
        this.deleteHooks = new LinkedHashSet<DeleteHook>();
        for (DSemanticDecorator selectedElement : this.selection) {
            DeleteElementDescription tool;
            if (!(selectedElement instanceof DDiagramElement) || (tool = this.getTool((DDiagramElement)selectedElement)) == null || tool.getHook() == null || tool.getHook().getId() == null) continue;
            this.deleteHooks.add(tool.getHook());
        }
        HashSet<String> ids = new HashSet<String>();
        Iterator<DeleteHook> it = this.deleteHooks.iterator();
        while (it.hasNext()) {
            DeleteHook deleteHook = it.next();
            if (ids.contains(deleteHook.getId())) {
                it.remove();
                continue;
            }
            ids.add(deleteHook.getId());
        }
    }

    private DeleteElementDescription getTool(DDiagramElement diagramElement) {
        DiagramElementMapping mapping = null;
        mapping = diagramElement.getDiagramElementMapping();
        if (mapping != null) {
            return mapping.getDeletionDescription();
        }
        return null;
    }
}

