/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.model.business.internal.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.DAnnotationEntry;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class DAnalysisQuery {
    private DAnalysis analysis;

    public DAnalysisQuery(DAnalysis analysis) {
        this.analysis = analysis;
    }

    public DAnalysis getDAnalysis() {
        return this.analysis;
    }

    public Option<DAnnotationEntry> getAnnotation(String source, String detail) {
        for (DAnnotationEntry annotation : this.analysis.getEAnnotations()) {
            if (!source.equals(annotation.getSource()) || !annotation.getDetails().contains((Object)detail)) continue;
            return Options.newSome((Object)annotation);
        }
        return Options.newNone();
    }

    public Option<DAnnotationEntry> getAnnotation(String source) {
        for (DAnnotationEntry annotation : this.analysis.getEAnnotations()) {
            if (!source.equals(annotation.getSource())) continue;
            return Options.newSome((Object)annotation);
        }
        return Options.newNone();
    }

    public Collection<DAnalysis> getAllReferencedAnalyses() {
        LinkedHashSet<DAnalysis> referenced = new LinkedHashSet<DAnalysis>();
        for (DAnalysis referencedAnalysis : this.analysis.getReferencedAnalysis()) {
            if (referencedAnalysis == null) continue;
            referenced.add(referencedAnalysis);
            referenced.addAll(new DAnalysisQuery(referencedAnalysis).getAllReferencedAnalyses());
        }
        return referenced;
    }

    public Collection<Viewpoint> getSelectedViewpoints() {
        ArrayList<Viewpoint> selectedViewpoints = new ArrayList<Viewpoint>();
        EList<DView> selectedDViews = this.analysis.getSelectedViews();
        for (DView dView : selectedDViews) {
            Viewpoint viewpoint = dView.getViewpoint();
            if (viewpoint == null) continue;
            selectedViewpoints.add(viewpoint);
        }
        return selectedViewpoints;
    }

    public DView getFirstOrphanDView() {
        DView firstOrphanDView = null;
        for (DView ownedDView : this.analysis.getOwnedViews()) {
            if (ownedDView.getViewpoint() != null) continue;
            firstOrphanDView = ownedDView;
            break;
        }
        return firstOrphanDView;
    }
}

