/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.extensions.ILinkHelperExtPtConstants;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperDescriptor;
import org.eclipse.ui.internal.navigator.extensions.RegistryReader;
import org.eclipse.ui.navigator.INavigatorContentService;

public class LinkHelperManager {
    private static final LinkHelperManager instance = new LinkHelperManager();
    private static final LinkHelperDescriptor[] NO_DESCRIPTORS = new LinkHelperDescriptor[0];
    private List<LinkHelperDescriptor> descriptors;

    public static LinkHelperManager getInstance() {
        return instance;
    }

    private LinkHelperManager() {
        new LinkHelperRegistry().readRegistry();
    }

    public LinkHelperDescriptor[] getLinkHelpersFor(Object anObject, INavigatorContentService aContentService) {
        ArrayList<LinkHelperDescriptor> helpersList = new ArrayList<LinkHelperDescriptor>();
        LinkHelperDescriptor descriptor2 = null;
        for (LinkHelperDescriptor descriptor2 : this.getDescriptors()) {
            if (!aContentService.isVisible(descriptor2.getId()) || !descriptor2.isEnabledFor(anObject)) continue;
            helpersList.add(descriptor2);
        }
        if (helpersList.isEmpty()) {
            return NO_DESCRIPTORS;
        }
        return helpersList.toArray(new LinkHelperDescriptor[helpersList.size()]);
    }

    public LinkHelperDescriptor[] getLinkHelpersFor(IEditorInput anInput, INavigatorContentService aContentService) {
        ArrayList<LinkHelperDescriptor> helpersList = new ArrayList<LinkHelperDescriptor>();
        LinkHelperDescriptor descriptor2 = null;
        for (LinkHelperDescriptor descriptor2 : this.getDescriptors()) {
            if (!aContentService.isVisible(descriptor2.getId()) || !descriptor2.isEnabledFor(anInput)) continue;
            helpersList.add(descriptor2);
        }
        if (helpersList.isEmpty()) {
            return NO_DESCRIPTORS;
        }
        return helpersList.toArray(new LinkHelperDescriptor[helpersList.size()]);
    }

    protected List<LinkHelperDescriptor> getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new ArrayList<LinkHelperDescriptor>();
        }
        return this.descriptors;
    }

    private class LinkHelperRegistry
    extends RegistryReader
    implements ILinkHelperExtPtConstants {
        private LinkHelperRegistry() {
            super(NavigatorPlugin.PLUGIN_ID, "linkHelper");
        }

        @Override
        public boolean readElement(final IConfigurationElement element) {
            if ("linkHelper".equals(element.getName())) {
                final boolean[] retValue = new boolean[1];
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(element){

                    @Override
                    public void run() throws Exception {
                        LinkHelperManager.this.getDescriptors().add(new LinkHelperDescriptor(element));
                        retValue[0] = true;
                    }
                });
                return retValue[0];
            }
            return false;
        }
    }
}

