/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.AttributeAlreadyDefinedInBaseClass;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.AttributeAlreadyDefinedInCurrentClass;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.AttributeNotFound;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.CodeLocation;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Context;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.DiagnosticsFactory;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.DynamicClassAlreadyDefined;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Message;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.MethodAlreadyDefinedInBaseClass;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.MethodAlreadyDefinedInCurrentClass;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.MethodParameterAlreadyDefined;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.OverriddenMethodNotFound;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.ProhibitedAssignmentToMethodParameter;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.ProhibitedAssignmentToSelf;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.ReservedKeywordResult;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.ReservedKeywordSelf;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.VariableAlreadyDefined;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.VariableNotFound;
import org.eclipse.emf.ecoretools.ale.core.validation.BaseValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidationMessageFactory;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.ValidationMessageFactory;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureInsert;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureRemove;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.VariableInsert;
import org.eclipse.emf.ecoretools.ale.implementation.VariableRemove;
import org.eclipse.emf.ecoretools.ale.implementation.While;

public class NameValidator
implements IValidator {
    BaseValidator base;
    private IValidationMessageFactory messages;

    @Override
    public void setBase(BaseValidator base) {
        this.base = base;
        this.messages = new ValidationMessageFactory(base);
    }

    @Override
    public List<Message> validateModelUnit(ModelUnit unit) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        HashMap declarations = new HashMap(5);
        unit.getClassDefinitions().stream().forEach(cls -> {
            if (declarations.containsKey(cls.getName())) {
                CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                location.setLine(this.base.getLines(cls).get(0));
                location.setStartPosition(this.base.getStartOffset(cls));
                location.setEndPosition(this.base.getStartOffset(cls) + ("class" + cls.getName()).length());
                Context context = DiagnosticsFactory.eINSTANCE.createContext();
                DynamicClassAlreadyDefined alreadyDeclared = DiagnosticsFactory.eINSTANCE.createDynamicClassAlreadyDefined();
                alreadyDeclared.setContext(context);
                alreadyDeclared.setLocation(location);
                alreadyDeclared.setSource((EObject)cls);
                alreadyDeclared.setCurrentDeclaration((RuntimeClass)cls);
                alreadyDeclared.setPreviousDeclaration((RuntimeClass)declarations.get(cls.getName()));
                msgs.add(alreadyDeclared);
            } else {
                declarations.put(cls.getName(), cls);
            }
        });
        return msgs;
    }

    @Override
    public List<Message> validateExtendedClass(ExtendedClass xtdClass) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        msgs.addAll(this.validateBehavioredClass(xtdClass));
        if (xtdClass.getBaseClass() != null) {
            List declarations = xtdClass.getBaseClass().getEAllStructuralFeatures().stream().map(s -> s.getName()).collect(Collectors.toList());
            xtdClass.getAttributes().stream().forEach(att -> {
                String name = att.getFeatureRef().getName();
                if (declarations.contains(name)) {
                    CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                    location.setLine(this.base.getLines(att).get(0));
                    location.setStartPosition(this.base.getStartOffset(att));
                    location.setEndPosition(this.base.getEndOffset(att));
                    Context context = DiagnosticsFactory.eINSTANCE.createContext();
                    AttributeAlreadyDefinedInBaseClass alreadyDeclared = DiagnosticsFactory.eINSTANCE.createAttributeAlreadyDefinedInBaseClass();
                    alreadyDeclared.setContext(context);
                    alreadyDeclared.setLocation(location);
                    alreadyDeclared.setSource((EObject)att);
                    alreadyDeclared.setAttributeName(name);
                    alreadyDeclared.setOpenClass(xtdClass);
                    alreadyDeclared.setBaseClass(xtdClass.getBaseClass());
                    msgs.add(alreadyDeclared);
                }
            });
            EList allEOperations = xtdClass.getBaseClass().getEAllOperations();
            for (Method mtd : xtdClass.getMethods()) {
                EOperation opRef;
                if (mtd.isOverriding() || (opRef = mtd.getOperationRef()) == null || opRef.getEContainingClass() == xtdClass.getBaseClass() || !allEOperations.stream().anyMatch(op -> this.areTheSame(opRef, (EOperation)op))) continue;
                CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                location.setLine(this.base.getLines(mtd).get(0));
                location.setStartPosition(this.base.getStartOffset(mtd));
                location.setEndPosition(this.base.getStartOffset(mtd.getBody()));
                Context context = DiagnosticsFactory.eINSTANCE.createContext();
                MethodAlreadyDefinedInBaseClass alreadyDeclared = DiagnosticsFactory.eINSTANCE.createMethodAlreadyDefinedInBaseClass();
                alreadyDeclared.setContext(context);
                alreadyDeclared.setLocation(location);
                alreadyDeclared.setNewDefinition(mtd);
                alreadyDeclared.setSource(mtd);
                msgs.add(alreadyDeclared);
            }
        }
        return msgs;
    }

    @Override
    public List<Message> validateRuntimeClass(RuntimeClass classDef) {
        return this.validateBehavioredClass(classDef);
    }

    private List<Message> validateBehavioredClass(BehavioredClass clazz) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        HashMap declarations = new HashMap(5);
        clazz.getAttributes().stream().forEach(att -> {
            String name = att.getFeatureRef().getName();
            if (declarations.containsKey(name)) {
                CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                location.setLine(this.base.getLines(att).get(0));
                location.setStartPosition(this.base.getStartOffset(att));
                location.setEndPosition(this.base.getEndOffset(att));
                Context context = DiagnosticsFactory.eINSTANCE.createContext();
                AttributeAlreadyDefinedInCurrentClass alreadyDeclared = DiagnosticsFactory.eINSTANCE.createAttributeAlreadyDefinedInCurrentClass();
                alreadyDeclared.setContext(context);
                alreadyDeclared.setLocation(location);
                alreadyDeclared.setSource((EObject)att);
                alreadyDeclared.setAttributeName(name);
                alreadyDeclared.setOwner(clazz);
                alreadyDeclared.setPreviousDeclaration((Attribute)declarations.get(name));
                msgs.add(alreadyDeclared);
            } else if (name.equals("self")) {
                CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                location.setLine(this.base.getLines(att).get(0));
                location.setStartPosition(this.base.getStartOffset(att));
                location.setEndPosition(this.base.getEndOffset(att));
                Context context = DiagnosticsFactory.eINSTANCE.createContext();
                ReservedKeywordSelf reservedKeyword = DiagnosticsFactory.eINSTANCE.createReservedKeywordSelf();
                reservedKeyword.setContext(context);
                reservedKeyword.setLocation(location);
                reservedKeyword.setSource((EObject)att);
                msgs.add(reservedKeyword);
            } else if (name.equals("result")) {
                CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                location.setLine(this.base.getLines(att).get(0));
                location.setStartPosition(this.base.getStartOffset(att));
                location.setEndPosition(this.base.getEndOffset(att));
                Context context = DiagnosticsFactory.eINSTANCE.createContext();
                ReservedKeywordResult reservedKeyword = DiagnosticsFactory.eINSTANCE.createReservedKeywordResult();
                reservedKeyword.setContext(context);
                reservedKeyword.setLocation(location);
                reservedKeyword.setSource((EObject)att);
                msgs.add(reservedKeyword);
            } else {
                declarations.put(name, att);
            }
        });
        ArrayList<Method> previousOp = new ArrayList<Method>(5);
        for (Method mtd : clazz.getMethods()) {
            Optional<Method> previousDeclaration = previousOp.stream().filter(prevOp -> this.areTheSame(mtd, (Method)prevOp)).findFirst();
            if (previousDeclaration.isPresent()) {
                CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                location.setLine(this.base.getLines(mtd).get(0));
                location.setStartPosition(this.base.getStartOffset(mtd));
                location.setEndPosition(this.base.getStartOffset(mtd.getBody()));
                Context context = DiagnosticsFactory.eINSTANCE.createContext();
                MethodAlreadyDefinedInCurrentClass alreadyDeclared = DiagnosticsFactory.eINSTANCE.createMethodAlreadyDefinedInCurrentClass();
                alreadyDeclared.setContext(context);
                alreadyDeclared.setLocation(location);
                alreadyDeclared.setSource(mtd);
                alreadyDeclared.setOwner(clazz);
                alreadyDeclared.setCurrentDeclaration(mtd);
                alreadyDeclared.setPreviousDeclaration(previousDeclaration.get());
                msgs.add(alreadyDeclared);
            }
            previousOp.add(mtd);
        }
        return msgs;
    }

    @Override
    public List<Message> validateMethod(Method mtd) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        ArrayList<String> declarations = new ArrayList<String>();
        if (mtd.getOperationRef() != null) {
            for (EParameter param : mtd.getOperationRef().getEParameters()) {
                Message reservedKeyword;
                Context context;
                CodeLocation location;
                String name = param.getName();
                if (declarations.contains(name)) {
                    location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                    location.setLine(this.base.getLines(mtd).get(0));
                    location.setStartPosition(this.base.getStartOffset(param));
                    location.setEndPosition(this.base.getEndOffset(param) + 1);
                    if (location.getStartPosition() == 0) {
                        location.setStartPosition(this.base.getStartOffset(mtd));
                        location.setEndPosition(this.base.getStartOffset(mtd.getBody()));
                    }
                    context = DiagnosticsFactory.eINSTANCE.createContext();
                    MethodParameterAlreadyDefined alreadyDefined = DiagnosticsFactory.eINSTANCE.createMethodParameterAlreadyDefined();
                    alreadyDefined.setContext(context);
                    alreadyDefined.setLocation(location);
                    alreadyDefined.setSource((EObject)param);
                    alreadyDefined.setParameterName(name);
                    msgs.add(alreadyDefined);
                    continue;
                }
                if (param.getName().equals("result")) {
                    location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                    location.setLine(this.base.getLines(mtd).get(0));
                    location.setStartPosition(this.base.getStartOffset(param));
                    location.setEndPosition(this.base.getEndOffset(param) + 1);
                    if (location.getStartPosition() == 0) {
                        location.setStartPosition(this.base.getStartOffset(mtd));
                        location.setEndPosition(this.base.getStartOffset(mtd.getBody()));
                    }
                    context = DiagnosticsFactory.eINSTANCE.createContext();
                    reservedKeyword = DiagnosticsFactory.eINSTANCE.createReservedKeywordResult();
                    reservedKeyword.setContext(context);
                    reservedKeyword.setLocation(location);
                    reservedKeyword.setSource((EObject)param);
                    msgs.add(reservedKeyword);
                    continue;
                }
                if (param.getName().equals("self")) {
                    location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                    location.setLine(this.base.getLines(mtd).get(0));
                    location.setStartPosition(this.base.getStartOffset(param));
                    location.setEndPosition(this.base.getEndOffset(param) + 1);
                    if (location.getStartPosition() == 0) {
                        location.setStartPosition(this.base.getStartOffset(mtd));
                        location.setEndPosition(this.base.getStartOffset(mtd.getBody()));
                    }
                    context = DiagnosticsFactory.eINSTANCE.createContext();
                    reservedKeyword = DiagnosticsFactory.eINSTANCE.createReservedKeywordSelf();
                    reservedKeyword.setContext(context);
                    reservedKeyword.setLocation(location);
                    reservedKeyword.setSource((EObject)param);
                    msgs.add(reservedKeyword);
                    continue;
                }
                declarations.add(name);
            }
        } else {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setLine(this.base.getLines(mtd).get(0));
            location.setStartPosition(this.base.getStartOffset(mtd));
            location.setEndPosition(this.base.getStartOffset(mtd.getBody()));
            Context context = DiagnosticsFactory.eINSTANCE.createContext();
            OverriddenMethodNotFound methodNotFound = DiagnosticsFactory.eINSTANCE.createOverriddenMethodNotFound();
            methodNotFound.setContext(context);
            methodNotFound.setLocation(location);
            methodNotFound.setSource(mtd);
            methodNotFound.setOverridingMethod(mtd);
            methodNotFound.setOverridingMethodOwner((BehavioredClass)mtd.eContainer());
            msgs.add(methodNotFound);
        }
        return msgs;
    }

    @Override
    public List<Message> validateFeatureAssignment(FeatureAssignment featAssign) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        boolean isExistingFeature = false;
        Set<IType> targetTypes = this.base.getPossibleTypes(featAssign.getTarget());
        for (IType type : targetTypes) {
            if (!(type.getType() instanceof EClass)) continue;
            EClass realType = (EClass)type.getType();
            EStructuralFeature feature = realType.getEStructuralFeature(featAssign.getTargetFeature());
            if (feature != null) {
                isExistingFeature = true;
                continue;
            }
            List<ExtendedClass> extensions = this.base.findExtensions(realType);
            Optional<Attribute> foundDynamicAttribute = extensions.stream().flatMap(xtdCls -> xtdCls.getAttributes().stream()).filter(field -> field.getFeatureRef().getName().equals(featAssign.getTargetFeature())).findFirst();
            if (!foundDynamicAttribute.isPresent()) continue;
            isExistingFeature = true;
        }
        if (!isExistingFeature) {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setLine(this.base.getLines(featAssign.getTarget()).get(0));
            location.setStartPosition(this.base.getStartOffset(featAssign.getTarget()));
            location.setEndPosition(this.base.getStartOffset(featAssign.getTarget()) + ("self." + featAssign.getTargetFeature()).length());
            Context context = DiagnosticsFactory.eINSTANCE.createContext();
            AttributeNotFound attributeNotFound = DiagnosticsFactory.eINSTANCE.createAttributeNotFound();
            attributeNotFound.setContext(context);
            attributeNotFound.setLocation(location);
            attributeNotFound.setSource(featAssign);
            attributeNotFound.setName(featAssign.getTargetFeature());
            attributeNotFound.setOwner(null);
            msgs.add(attributeNotFound);
        }
        return msgs;
    }

    @Override
    public List<Message> validateFeatureInsert(FeatureInsert featInsert) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        boolean isExistingFeature = false;
        Set<IType> targetTypes = this.base.getPossibleTypes(featInsert.getTarget());
        for (IType type : targetTypes) {
            if (!(type.getType() instanceof EClass)) continue;
            EClass realType = (EClass)type.getType();
            EStructuralFeature feature = realType.getEStructuralFeature(featInsert.getTargetFeature());
            if (feature != null) {
                isExistingFeature = true;
                continue;
            }
            List<ExtendedClass> extensions = this.base.findExtensions(realType);
            Optional<Attribute> foundDynamicAttribute = extensions.stream().flatMap(xtdCls -> xtdCls.getAttributes().stream()).filter(field -> field.getFeatureRef().getName().equals(featInsert.getTargetFeature())).findFirst();
            if (!foundDynamicAttribute.isPresent()) continue;
            isExistingFeature = true;
        }
        if (!isExistingFeature) {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setLine(this.base.getLines(featInsert.getTarget()).get(0));
            location.setStartPosition(this.base.getStartOffset(featInsert.getTarget()));
            location.setEndPosition(this.base.getStartOffset(featInsert.getTarget()) + ("self." + featInsert.getTargetFeature()).length());
            Context context = DiagnosticsFactory.eINSTANCE.createContext();
            AttributeNotFound attributeNotFound = DiagnosticsFactory.eINSTANCE.createAttributeNotFound();
            attributeNotFound.setContext(context);
            attributeNotFound.setLocation(location);
            attributeNotFound.setSource(featInsert);
            attributeNotFound.setName(featInsert.getTargetFeature());
            attributeNotFound.setOwner(null);
            msgs.add(attributeNotFound);
        }
        return msgs;
    }

    @Override
    public List<Message> validateFeatureRemove(FeatureRemove featRemove) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        boolean isExistingFeature = false;
        Set<IType> targetTypes = this.base.getPossibleTypes(featRemove.getTarget());
        for (IType type : targetTypes) {
            if (!(type.getType() instanceof EClass)) continue;
            EClass realType = (EClass)type.getType();
            EStructuralFeature feature = realType.getEStructuralFeature(featRemove.getTargetFeature());
            if (feature != null) {
                isExistingFeature = true;
                continue;
            }
            List<ExtendedClass> extensions = this.base.findExtensions(realType);
            Optional<Attribute> foundDynamicAttribute = extensions.stream().flatMap(xtdCls -> xtdCls.getAttributes().stream()).filter(field -> field.getFeatureRef().getName().equals(featRemove.getTargetFeature())).findFirst();
            if (!foundDynamicAttribute.isPresent()) continue;
            isExistingFeature = true;
        }
        if (!isExistingFeature) {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setLine(this.base.getLines(featRemove.getTarget()).get(0));
            location.setStartPosition(this.base.getStartOffset(featRemove.getTarget()));
            location.setEndPosition(this.base.getStartOffset(featRemove.getTarget()) + ("self." + featRemove.getTargetFeature()).length());
            Context context = DiagnosticsFactory.eINSTANCE.createContext();
            AttributeNotFound attributeNotFound = DiagnosticsFactory.eINSTANCE.createAttributeNotFound();
            attributeNotFound.setContext(context);
            attributeNotFound.setLocation(location);
            attributeNotFound.setSource(featRemove);
            attributeNotFound.setName(featRemove.getTargetFeature());
            attributeNotFound.setOwner(null);
            msgs.add(attributeNotFound);
        }
        return msgs;
    }

    @Override
    public List<Message> validateVariableAssignment(VariableAssignment varAssign) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        Set<IType> declaringTypes = this.base.getCurrentScope().get(varAssign.getName());
        if (declaringTypes == null && !varAssign.getName().equals("result")) {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setLine(this.base.getLines(varAssign).get(0));
            location.setStartPosition(this.base.getStartOffset(varAssign));
            location.setEndPosition(this.base.getStartOffset(varAssign) + varAssign.getName().length());
            Context context = DiagnosticsFactory.eINSTANCE.createContext();
            VariableNotFound variableNotFound = DiagnosticsFactory.eINSTANCE.createVariableNotFound();
            variableNotFound.setContext(context);
            variableNotFound.setLocation(location);
            variableNotFound.setSource(varAssign);
            variableNotFound.setName(varAssign.getName());
            msgs.add(variableNotFound);
        } else if (varAssign.getName().equals("self")) {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setLine(this.base.getLines(varAssign).get(0));
            location.setStartPosition(this.base.getStartOffset(varAssign));
            location.setEndPosition(this.base.getStartOffset(varAssign) + varAssign.getName().length());
            Context context = DiagnosticsFactory.eINSTANCE.createContext();
            ProhibitedAssignmentToSelf assignmentToSelf = DiagnosticsFactory.eINSTANCE.createProhibitedAssignmentToSelf();
            assignmentToSelf.setContext(context);
            assignmentToSelf.setLocation(location);
            assignmentToSelf.setSource(varAssign);
            msgs.add(assignmentToSelf);
        } else {
            Method method = this.base.getContainingOperation(varAssign);
            EOperation enclosingOperation = method.getOperationRef();
            if (enclosingOperation != null) {
                boolean isVoidOperation;
                boolean isProhibitedAssignmentToMethodParameter = enclosingOperation.getEParameters().stream().anyMatch(param -> param.getName().equals(varAssign.getName()));
                if (isProhibitedAssignmentToMethodParameter) {
                    CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                    location.setLine(this.base.getLines(varAssign).get(0));
                    location.setStartPosition(this.base.getStartOffset(varAssign));
                    location.setEndPosition(this.base.getStartOffset(varAssign) + varAssign.getName().length());
                    Context context = DiagnosticsFactory.eINSTANCE.createContext();
                    ProhibitedAssignmentToMethodParameter assignmentToParam = DiagnosticsFactory.eINSTANCE.createProhibitedAssignmentToMethodParameter();
                    assignmentToParam.setContext(context);
                    assignmentToParam.setLocation(location);
                    assignmentToParam.setSource(varAssign);
                    assignmentToParam.setParameterName(varAssign.getName());
                    msgs.add(assignmentToParam);
                }
                boolean assigningToResult = "result".equals(varAssign.getName());
                boolean bl = isVoidOperation = enclosingOperation.getEType() == null && enclosingOperation.getEGenericType() == null || enclosingOperation.getEType() == ImplementationPackage.eINSTANCE.getVoidEClassifier();
                if (assigningToResult && isVoidOperation) {
                    Message invalidAssignment = this.messages.assignmentToResultInVoidOperation(varAssign);
                    msgs.add(invalidAssignment);
                    return msgs;
                }
            }
        }
        return msgs;
    }

    @Override
    public List<Message> validateVariableDeclaration(VariableDeclaration varDecl) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        if (varDecl.getName().equals("result")) {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setLine(this.base.getLines(varDecl).get(0));
            location.setStartPosition(this.base.getStartOffset(varDecl));
            location.setEndPosition(this.base.getEndOffset(varDecl));
            Context context = DiagnosticsFactory.eINSTANCE.createContext();
            ReservedKeywordResult reservedKeyword = DiagnosticsFactory.eINSTANCE.createReservedKeywordResult();
            reservedKeyword.setContext(context);
            reservedKeyword.setLocation(location);
            reservedKeyword.setSource(varDecl);
            msgs.add(reservedKeyword);
        } else if (varDecl.getName().equals("self")) {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setLine(this.base.getLines(varDecl).get(0));
            location.setStartPosition(this.base.getStartOffset(varDecl));
            location.setEndPosition(this.base.getEndOffset(varDecl));
            Context context = DiagnosticsFactory.eINSTANCE.createContext();
            ReservedKeywordSelf reservedKeyword = DiagnosticsFactory.eINSTANCE.createReservedKeywordSelf();
            reservedKeyword.setContext(context);
            reservedKeyword.setLocation(location);
            reservedKeyword.setSource(varDecl);
            msgs.add(reservedKeyword);
        } else {
            Set<IType> declaringTypes = this.base.getCurrentScope().get(varDecl.getName());
            if (declaringTypes != null) {
                CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                location.setLine(this.base.getLines(varDecl).get(0));
                location.setStartPosition(this.base.getStartOffset(varDecl));
                location.setEndPosition(this.base.getEndOffset(varDecl));
                Context context = DiagnosticsFactory.eINSTANCE.createContext();
                VariableAlreadyDefined alreadyBound = DiagnosticsFactory.eINSTANCE.createVariableAlreadyDefined();
                alreadyBound.setContext(context);
                alreadyBound.setLocation(location);
                alreadyBound.setSource(varDecl);
                alreadyBound.setName(varDecl.getName());
                msgs.add(alreadyBound);
            }
        }
        return msgs;
    }

    @Override
    public List<Message> validateVariableInsert(VariableInsert varInsert) {
        Method method;
        EOperation enclosingOperation;
        ArrayList<Message> msgs = new ArrayList<Message>();
        boolean assigningToResult = "result".equals(varInsert.getName());
        Set<IType> declaringTypes = this.base.getCurrentScope().get(varInsert.getName());
        if (declaringTypes == null && !assigningToResult) {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setLine(this.base.getLines(varInsert).get(0));
            location.setStartPosition(this.base.getStartOffset(varInsert));
            location.setEndPosition(this.base.getStartOffset(varInsert) + varInsert.getName().length());
            Context context = DiagnosticsFactory.eINSTANCE.createContext();
            VariableNotFound variableNotFound = DiagnosticsFactory.eINSTANCE.createVariableNotFound();
            variableNotFound.setContext(context);
            variableNotFound.setLocation(location);
            variableNotFound.setSource(varInsert);
            variableNotFound.setName(varInsert.getName());
            msgs.add(variableNotFound);
        } else if (assigningToResult && (enclosingOperation = (method = this.base.getContainingOperation(varInsert)).getOperationRef()) != null) {
            boolean isVoidOperation;
            boolean bl = isVoidOperation = enclosingOperation.getEType() == null && enclosingOperation.getEGenericType() == null || enclosingOperation.getEType() == ImplementationPackage.eINSTANCE.getVoidEClassifier();
            if (isVoidOperation) {
                Message invalidAssignment = this.messages.assignmentToResultInVoidOperation(varInsert);
                msgs.add(invalidAssignment);
                return msgs;
            }
        }
        return msgs;
    }

    @Override
    public List<Message> validateVariableRemove(VariableRemove varRemove) {
        Method method;
        EOperation enclosingOperation;
        ArrayList<Message> msgs = new ArrayList<Message>();
        boolean assigningToResult = "result".equals(varRemove.getName());
        Set<IType> declaringTypes = this.base.getCurrentScope().get(varRemove.getName());
        if (declaringTypes == null && !assigningToResult) {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setLine(this.base.getLines(varRemove).get(0));
            location.setStartPosition(this.base.getStartOffset(varRemove));
            location.setEndPosition(this.base.getStartOffset(varRemove) + varRemove.getName().length());
            Context context = DiagnosticsFactory.eINSTANCE.createContext();
            VariableNotFound variableNotFound = DiagnosticsFactory.eINSTANCE.createVariableNotFound();
            variableNotFound.setContext(context);
            variableNotFound.setLocation(location);
            variableNotFound.setSource(varRemove);
            variableNotFound.setName(varRemove.getName());
            msgs.add(variableNotFound);
        } else if (assigningToResult && (enclosingOperation = (method = this.base.getContainingOperation(varRemove)).getOperationRef()) != null) {
            boolean isVoidOperation;
            boolean bl = isVoidOperation = enclosingOperation.getEType() == null && enclosingOperation.getEGenericType() == null || enclosingOperation.getEType() == ImplementationPackage.eINSTANCE.getVoidEClassifier();
            if (isVoidOperation) {
                Message invalidAssignment = this.messages.assignmentToResultInVoidOperation(varRemove);
                msgs.add(invalidAssignment);
                return msgs;
            }
        }
        return msgs;
    }

    @Override
    public List<Message> validateForEach(ForEach loop) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        if (loop.getVariable().equals("result")) {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setLine(this.base.getLines(loop).get(0));
            location.setStartPosition(this.base.getStartOffset(loop));
            location.setEndPosition(this.base.getEndOffset(loop));
            Context context = DiagnosticsFactory.eINSTANCE.createContext();
            ReservedKeywordResult reservedKeyword = DiagnosticsFactory.eINSTANCE.createReservedKeywordResult();
            reservedKeyword.setContext(context);
            reservedKeyword.setLocation(location);
            reservedKeyword.setSource(loop);
            msgs.add(reservedKeyword);
        } else if (loop.getVariable().equals("self")) {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setLine(this.base.getLines(loop).get(0));
            location.setStartPosition(this.base.getStartOffset(loop));
            location.setEndPosition(this.base.getEndOffset(loop));
            Context context = DiagnosticsFactory.eINSTANCE.createContext();
            ReservedKeywordSelf reservedKeyword = DiagnosticsFactory.eINSTANCE.createReservedKeywordSelf();
            reservedKeyword.setContext(context);
            reservedKeyword.setLocation(location);
            reservedKeyword.setSource(loop);
            msgs.add(reservedKeyword);
        } else {
            Set<IType> declaringTypes = this.base.getCurrentScope().get(loop.getVariable());
            if (declaringTypes != null) {
                CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
                location.setLine(this.base.getLines(loop).get(0));
                location.setStartPosition(this.base.getStartOffset(loop));
                location.setEndPosition(this.base.getEndOffset(loop));
                Context context = DiagnosticsFactory.eINSTANCE.createContext();
                VariableAlreadyDefined alreadyBound = DiagnosticsFactory.eINSTANCE.createVariableAlreadyDefined();
                alreadyBound.setContext(context);
                alreadyBound.setLocation(location);
                alreadyBound.setSource(loop);
                alreadyBound.setName(loop.getVariable());
                msgs.add(alreadyBound);
            }
        }
        return msgs;
    }

    @Override
    public List<Message> validateIf(If ifStmt) {
        return Collections.emptyList();
    }

    @Override
    public List<Message> validateWhile(While loop) {
        return Collections.emptyList();
    }

    private boolean areTheSame(Method op1, Method op2) {
        EOperation eOp1 = op1.getOperationRef();
        EOperation eOp2 = op2.getOperationRef();
        return this.areTheSame(eOp1, eOp2);
    }

    private boolean areTheSame(EOperation eOp1, EOperation eOp2) {
        boolean isMatchingArgsSize;
        if (eOp1 == null || eOp2 == null) {
            return false;
        }
        boolean isMatchingName = eOp1.getName().equals(eOp2.getName());
        boolean bl = isMatchingArgsSize = eOp1.getEParameters().size() == eOp2.getEParameters().size();
        if (!isMatchingName || !isMatchingArgsSize) {
            return false;
        }
        boolean areParamTypeMatching = true;
        int i = 0;
        while (i < eOp1.getEParameters().size()) {
            EParameter param1 = (EParameter)eOp1.getEParameters().get(i);
            EParameter param2 = (EParameter)eOp2.getEParameters().get(i);
            areParamTypeMatching = areParamTypeMatching && param1.getEType().equals(param2.getEType());
            ++i;
        }
        return isMatchingName && isMatchingArgsSize && areParamTypeMatching;
    }
}

