/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opsemanticsview.OperationalSemanticsView;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.gemoc.trace.commons.EMFUtil;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@SuppressWarnings("all")
public class TraceMMGenerator {
  private final OperationalSemanticsView mmext;

  private final ResourceSet rs;

  private final String languageName;

  private final boolean gemoc;

  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private final EPackage tracemmresult;

  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private final TraceMMGenerationTraceability traceability;

  private final TraceMMExplorer traceMMExplorer;

  private boolean done = false;

  public TraceMMGenerator(final OperationalSemanticsView mmext, final boolean gemoc) {
    try {
      this.mmext = mmext;
      this.gemoc = gemoc;
      String _replaceAll = mmext.getExecutionMetamodel().getName().replaceAll(" ", "");
      String _plus = (_replaceAll + "Trace");
      this.languageName = _plus;
      ResourceSetImpl _resourceSetImpl = new ResourceSetImpl();
      this.rs = _resourceSetImpl;
      Map<String, Object> _extensionToFactoryMap = this.rs.getResourceFactoryRegistry().getExtensionToFactoryMap();
      EcoreResourceFactoryImpl _ecoreResourceFactoryImpl = new EcoreResourceFactoryImpl();
      _extensionToFactoryMap.put("ecore", _ecoreResourceFactoryImpl);
      final Resource base = EMFUtil.loadModelURI(
        URI.createPlatformPluginURI("org.eclipse.gemoc.trace.metamodel.generator/model/base.ecore", true), this.rs);
      EObject _get = base.getContents().get(0);
      this.tracemmresult = ((EPackage) _get);
      base.getContents().remove(this.tracemmresult);
      this.tracemmresult.setName(this.languageName);
      this.tracemmresult.setNsURI(this.languageName);
      this.tracemmresult.setNsPrefix(this.languageName);
      TraceMMExplorer _traceMMExplorer = new TraceMMExplorer(this.tracemmresult);
      this.traceMMExplorer = _traceMMExplorer;
      this.traceMMExplorer.stepsPackage.setNsURI((this.languageName + "_Steps"));
      this.traceMMExplorer.statesPackage.setNsURI((this.languageName + "_States"));
      TraceMMGenerationTraceability _traceMMGenerationTraceability = new TraceMMGenerationTraceability(this.traceMMExplorer, mmext);
      this.traceability = _traceMMGenerationTraceability;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }

  private TraceMMGeneratorSteps stepsGen;

  public void computeAllMaterial() throws IOException {
    if ((!this.done)) {
      final TraceMMGeneratorStates statesGen = new TraceMMGeneratorStates(this.mmext, this.traceability, this.traceMMExplorer, this.languageName, 
        this.tracemmresult, this.gemoc);
      statesGen.process();
      TraceMMGeneratorSteps _traceMMGeneratorSteps = new TraceMMGeneratorSteps(this.mmext, this.tracemmresult, this.traceability, this.traceMMExplorer, this.gemoc);
      this.stepsGen = _traceMMGeneratorSteps;
      this.stepsGen.process();
      final Diagnostic results = Diagnostician.INSTANCE.validate(this.mmext);
      final Function1<Diagnostic, Boolean> _function = (Diagnostic r) -> {
        int _severity = r.getSeverity();
        return Boolean.valueOf((_severity == Diagnostic.ERROR));
      };
      final Diagnostic error = IterableExtensions.<Diagnostic>findFirst(results.getChildren(), _function);
      boolean _notEquals = (!Objects.equal(error, null));
      if (_notEquals) {
        throw new IllegalStateException(
          ("The generated trace metamodel is invalid for at least one reason: " + error));
      }
      this.done = true;
    } else {
      InputOutput.<String>println("ERROR: already computed.");
    }
  }

  public void sortResult() {
    this.sortEPackage(this.tracemmresult);
  }

  private void sortEPackage(final EPackage ePack) {
    EList<EPackage> _eSubpackages = ePack.getESubpackages();
    for (final EPackage subPackage : _eSubpackages) {
      this.sortEPackage(subPackage);
    }
    final Function1<EClassifier, String> _function = (EClassifier it) -> {
      return it.getName();
    };
    final List<EClassifier> sortedSteps = IterableExtensions.<EClassifier, String>sortBy(ePack.getEClassifiers(), _function);
    ePack.getEClassifiers().clear();
    ePack.getEClassifiers().addAll(sortedSteps);
    Iterable<EClass> _filter = Iterables.<EClass>filter(ePack.getEClassifiers(), EClass.class);
    for (final EClass eClass : _filter) {
      {
        this.sortEClassFeatures(eClass);
        this.sortEClassInheritance(eClass);
      }
    }
  }

  private void sortEClassFeatures(final EClass eClass) {
    final Function1<EStructuralFeature, String> _function = (EStructuralFeature it) -> {
      return it.getName();
    };
    final List<EStructuralFeature> sortedClassFeatures = IterableExtensions.<EStructuralFeature, String>sortBy(eClass.getEStructuralFeatures(), _function);
    eClass.getEStructuralFeatures().clear();
    eClass.getEStructuralFeatures().addAll(sortedClassFeatures);
  }

  private void sortEClassInheritance(final EClass eClass) {
    boolean _isEmpty = eClass.getEGenericSuperTypes().isEmpty();
    if (_isEmpty) {
      final Function1<EClass, String> _function = (EClass it) -> {
        return it.getName();
      };
      final List<EClass> sortedClassInheritance = IterableExtensions.<EClass, String>sortBy(eClass.getESuperTypes(), _function);
      eClass.getESuperTypes().clear();
      eClass.getESuperTypes().addAll(sortedClassInheritance);
    }
  }

  public void addGetCallerEOperations(final Set<EPackage> traceMetamodel, final Set<GenPackage> packages) {
    this.stepsGen.addGetCallerEOperations(traceMetamodel, packages);
  }

  @Pure
  public EPackage getTracemmresult() {
    return this.tracemmresult;
  }

  @Pure
  public TraceMMGenerationTraceability getTraceability() {
    return this.traceability;
  }
}
