/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.internal.accessor;

import java.util.Optional;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;

public class ModelAccessorAdapter
implements Adapter {
    private ModelAccessor modelAccessor;

    protected ModelAccessorAdapter(ModelAccessor modelAccesor) {
        this.modelAccessor = modelAccesor;
    }

    public static void addAdapter(ResourceSet resourceSet, ModelAccessor modelAccessor) {
        ModelAccessorAdapter modelAccessorAdapter = new ModelAccessorAdapter(modelAccessor);
        resourceSet.eAdapters().add((Object)modelAccessorAdapter);
    }

    public static Optional<ModelAccessorAdapter> getAdapter(ResourceSet resourceSet) {
        for (Adapter adapter : resourceSet.eAdapters()) {
            if (!(adapter instanceof ModelAccessorAdapter)) continue;
            return Optional.of((ModelAccessorAdapter)adapter);
        }
        return Optional.empty();
    }

    public static Optional<ModelAccessor> removeAdapter(ResourceSet resourceSet) {
        Optional<ModelAccessorAdapter> optionalAdapter = ModelAccessorAdapter.getAdapter(resourceSet);
        if (optionalAdapter.isPresent()) {
            resourceSet.eAdapters().remove((Object)optionalAdapter.get());
            return Optional.ofNullable(optionalAdapter.get().getModelAccessor());
        }
        return Optional.empty();
    }

    public static void disposeModelAccessor(ResourceSet resourceSet) {
        Optional<ModelAccessor> optionalRemovedAdapter = ModelAccessorAdapter.removeAdapter(resourceSet);
        if (optionalRemovedAdapter.isPresent()) {
            optionalRemovedAdapter.get().dispose();
        }
    }

    public ModelAccessor getModelAccessor() {
        return this.modelAccessor;
    }

    public void notifyChanged(Notification notification) {
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier target) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }
}

