/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.CCSLModel;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.Block;
import fr.inria.aoste.timesquare.ccslkernel.runtime.IRuntimeContainer;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.solver.ISolverConcrete;
import fr.inria.aoste.timesquare.ccslkernel.solver.ImplicitClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.CCSLModel.SolverBlockTransition;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.SolverExpression;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.SolverRelation;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.SolverRelationWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SolverBlock
implements IRuntimeContainer {
    private Set<SolverClock> concreteClocks = new HashSet<SolverClock>();
    private Set<SolverClock> denseClocks = new HashSet<SolverClock>();
    private Set<ImplicitClock> implicitClocks = new HashSet<ImplicitClock>();
    private Set<ISolverConcrete> concretes = new HashSet<ISolverConcrete>();
    private List<SolverBlock> subBlocks = new ArrayList<SolverBlock>();
    private Set<SolverBlockTransition> blockTransitions;
    private SolverBlock parent;
    private Block modelBlock;
    private boolean isActive = false;

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public Set<SolverBlockTransition> getSolverBlockTransitions() {
        return this.blockTransitions;
    }

    public Block getModelBlock() {
        return this.modelBlock;
    }

    public void setModelBlock(Block modelBlock) {
        this.modelBlock = modelBlock;
    }

    public Set<SolverClock> getConcreteClocks() {
        return this.concreteClocks;
    }

    public Set<ImplicitClock> getImplicitClocks() {
        return this.implicitClocks;
    }

    public Set<SolverClock> getDenseClocks() {
        return this.denseClocks;
    }

    public Set<ISolverConcrete> getConcretes() {
        return this.concretes;
    }

    public List<SolverBlock> getSubBlocks() {
        return this.subBlocks;
    }

    public List<SolverBlock> getActiveSubBlocks() {
        ArrayList<SolverBlock> res = new ArrayList<SolverBlock>();
        for (SolverBlock sb : this.getSubBlocks()) {
            if (!sb.isActive) continue;
            res.add(sb);
        }
        return res;
    }

    public boolean isActiveBlock() {
        return this.isActive;
    }

    public void start(AbstractSemanticHelper semanticHelper) throws SimulationException {
        this.isActive = true;
        for (SolverClock clock : this.getConcreteClocks()) {
            clock.start(semanticHelper);
        }
        for (ISolverConcrete concrete : this.concretes) {
            if (concrete instanceof SolverRelation || concrete instanceof SolverRelationWrapper) {
                concrete.start(semanticHelper);
            }
            if (!(concrete instanceof SolverExpression)) continue;
            ((SolverExpression)concrete).getImplicitClock().start(semanticHelper);
        }
    }

    public void terminate(AbstractUpdateHelper updateHelper) throws SimulationException {
        this.isActive = false;
        for (SolverClock clock : this.getConcreteClocks()) {
            clock.terminate(updateHelper);
        }
        for (ISolverConcrete concrete : this.concretes) {
            if (concrete instanceof SolverRelation || concrete instanceof SolverRelationWrapper) {
                concrete.terminate(updateHelper);
            }
            if (!(concrete instanceof SolverExpression)) continue;
            ((SolverExpression)concrete).getImplicitClock().terminate(updateHelper);
        }
    }

    public IRuntimeContainer getParent() {
        return this.parent;
    }

    public void setParent(IRuntimeContainer parent) {
        this.parent = (SolverBlock)parent;
        if (parent != null) {
            parent.addContent((IRuntimeContainer)this);
        }
    }

    public List<IRuntimeContainer> getContents() {
        return Collections.emptyList();
    }

    public void addContent(IRuntimeContainer element) {
        if (element instanceof ImplicitClock) {
            this.implicitClocks.add((ImplicitClock)element);
        } else if (element instanceof SolverClock) {
            if (((SolverClock)element).isDense()) {
                this.denseClocks.add((SolverClock)element);
            } else {
                this.concreteClocks.add((SolverClock)element);
            }
        } else if (element instanceof SolverBlock) {
            this.subBlocks.add((SolverBlock)element);
        } else if (element instanceof ISolverConcrete) {
            this.concretes.add((ISolverConcrete)element);
        }
    }
}

