/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.expressions;

import fr.inria.aoste.timesquare.ccslkernel.runtime.AbstractConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;

public class RuntimeStrictSampling
extends AbstractRuntimeExpression {
    private SamplingState localState;
    private RuntimeClock sampledClock;
    private RuntimeClock samplingClock;

    public RuntimeStrictSampling(RuntimeClock iClock, RuntimeClock sampledClock, RuntimeClock samplingClock) {
        super(iClock);
        this.sampledClock = sampledClock;
        this.samplingClock = samplingClock;
        this.localState = SamplingState.NORMAL;
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallStart()) {
            return;
        }
        super.start(helper);
        this.localState = SamplingState.NORMAL;
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallSemantic()) {
            return;
        }
        super.semantic(helper);
        if (this.sampledClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.sampledClock)).semantic(helper);
        }
        if (this.samplingClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.samplingClock)).semantic(helper);
        }
        if (this.isDead()) {
            helper.inhibitClock(this.getExpressionClock());
        } else if (this.localState == SamplingState.NORMAL || this.state == AbstractConstraint.State.DEAD) {
            helper.inhibitClock(this.getExpressionClock());
        } else if (this.localState == SamplingState.WAITSAMPLING) {
            helper.semanticBDDAnd(helper.createEqual(this.getExpressionClock(), this.getSamplingClock()));
        }
        helper.registerClockUse(new RuntimeClock[]{this.getExpressionClock(), this.getSampledClock(), this.getSamplingClock()});
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (!this.canCallUpdate()) {
            return;
        }
        super.update(helper);
        if (this.sampledClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.sampledClock)).update(helper);
        }
        if (this.samplingClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.samplingClock)).update(helper);
        }
        switch (this.localState) {
            case NORMAL: {
                if (!helper.clockHasFired(this.sampledClock)) break;
                this.localState = SamplingState.WAITSAMPLING;
                break;
            }
            case WAITSAMPLING: {
                if (!helper.clockHasFired(this.samplingClock)) break;
                this.terminate(helper);
                break;
            }
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        super.deathSemantic(helper);
        if (this.sampledClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.sampledClock)).deathSemantic(helper);
        }
        if (this.samplingClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.samplingClock)).deathSemantic(helper);
        }
        switch (this.localState) {
            case NORMAL: {
                helper.registerDeathImplication(this.getSampledClock(), this.getExpressionClock());
                break;
            }
            case WAITSAMPLING: {
                helper.registerDeathImplication(this.getSamplingClock(), this.getExpressionClock());
            }
        }
    }

    public RuntimeClock getSampledClock() {
        return this.sampledClock;
    }

    public RuntimeClock getSamplingClock() {
        return this.samplingClock;
    }

    @Override
    public SerializedConstraintState dumpState() {
        SerializedConstraintState currentState = super.dumpState();
        currentState.dump(this.localState.ordinal());
        return currentState;
    }

    @Override
    public void restoreState(SerializedConstraintState newState) {
        super.restoreState(newState);
        this.localState = SamplingState.values()[(Integer)newState.restore(2)];
    }

    private static enum SamplingState {
        NORMAL,
        WAITSAMPLING;

    }
}

