/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.smoketest.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.xtext.junit4.IInjectorProvider;
import org.eclipse.xtext.junit4.IRegistryConfigurator;
import org.eclipse.xtext.junit4.smoketest.ScenarioProcessor;
import org.eclipse.xtext.junit4.smoketest.internal.AbstractScenarioRunner;
import org.eclipse.xtext.junit4.smoketest.internal.TestDataCarrier;
import org.eclipse.xtext.junit4.smoketest.internal.WrappingInjectorProvider;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;

public abstract class AbstractParallelScenarioRunner
extends AbstractScenarioRunner {
    private final Map<FrameworkMethod, String> testData = new ConcurrentHashMap<FrameworkMethod, String>();
    private RunnerScheduler scheduler;
    private List<FrameworkMethod> children;

    public AbstractParallelScenarioRunner(Class<?> klass, Class<? extends ScenarioProcessor> processorClass) throws InitializationError {
        super(klass, processorClass);
        this.setScheduler(new ParallelRunnerScheduler());
    }

    public void setScheduler(RunnerScheduler scheduler) {
        super.setScheduler(scheduler);
        this.scheduler = scheduler;
    }

    protected Statement childrenInvoker(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() throws Throwable {
                WrappingInjectorProvider wrapped = AbstractParallelScenarioRunner.this.getOrCreateInjectorProvider();
                wrapped.setupRegistry();
                try {
                    AbstractParallelScenarioRunner.this.prepareChildren(notifier);
                }
                finally {
                    wrapped.restoreRegistry();
                }
                IInjectorProvider delegate = wrapped.getDelegate();
                if (delegate instanceof IRegistryConfigurator) {
                    IRegistryConfigurator registryConfigurator = (IRegistryConfigurator)((Object)delegate);
                    registryConfigurator.setupRegistry();
                    try {
                        AbstractParallelScenarioRunner.this.runChildren(notifier);
                    }
                    finally {
                        registryConfigurator.restoreRegistry();
                    }
                } else {
                    AbstractParallelScenarioRunner.this.runChildren(notifier);
                }
            }
        };
    }

    @Override
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (this.isIgnored(method)) {
            notifier.fireTestIgnored(description);
        } else if (this.testData.containsKey(method)) {
            this.runLeaf(this.methodBlock(method), description, notifier);
        }
    }

    protected List<FrameworkMethod> getChildren() {
        if (this.children == null) {
            this.children = Lists.newArrayList((Iterable)super.getChildren());
            return this.children;
        }
        return this.children;
    }

    private void prepareChildren(RunNotifier notifier) throws Throwable {
        for (FrameworkMethod each : this.getChildren()) {
            this.prepareChild(each, notifier);
        }
    }

    protected void prepareChild(FrameworkMethod method, RunNotifier notifier) throws Throwable {
        if (!super.isIgnored(method)) {
            this.prepareMethodBlock(method, notifier).evaluate();
        }
    }

    private void runChildren(final RunNotifier notifier) {
        for (final FrameworkMethod each : this.getChildren()) {
            this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    AbstractParallelScenarioRunner.this.runChild(each, notifier);
                }
            });
        }
        this.scheduler.finished();
    }

    protected Statement prepareMethodBlock(final FrameworkMethod method, final RunNotifier notifier) {
        final Statement methodBlock = this.superMethodBlock(method);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    methodBlock.evaluate();
                    Description description = AbstractParallelScenarioRunner.this.describeChild(method);
                    try {
                        notifier.fireTestStarted(description);
                        notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)new AssumptionViolatedException("Method " + method.getName() + " did parse any input")));
                    }
                    finally {
                        notifier.fireTestFinished(description);
                    }
                }
                catch (TestDataCarrier testData) {
                    AbstractParallelScenarioRunner.this.testData.put(method, testData.getData());
                }
            }
        };
    }

    @Override
    protected Statement methodBlock(final FrameworkMethod method) {
        return new Statement(){

            public void evaluate() throws Throwable {
                String testData = (String)AbstractParallelScenarioRunner.this.testData.remove(method);
                if (testData != null) {
                    AbstractParallelScenarioRunner.this.process(testData);
                }
            }
        };
    }

    @Override
    protected void process(String data) throws Exception {
        IInjectorProvider delegate = this.getOrCreateInjectorProvider().getDelegate();
        ScenarioProcessor processor = (ScenarioProcessor)delegate.getInjector().getInstance(this.getProcessorClass());
        String preProcessed = processor.preProcess(data);
        if (preProcessed == null) {
            throw new AssumptionViolatedException("Input is filtered by the pre processing step: " + data);
        }
        this.doProcess(preProcessed, processor);
    }

    private static class ParallelRunnerScheduler
    implements RunnerScheduler {
        private final List<Future<?>> futures;
        private ExecutorService executor = Executors.newFixedThreadPool(Integer.getInteger("org.eclipse.xtext.junit4.parallel.threads", 4));

        public ParallelRunnerScheduler() {
            this.futures = Collections.synchronizedList(new ArrayList());
        }

        public void finished() {
            this.executor.shutdown();
            for (Future<?> future : this.futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    if (e.getCause() instanceof Error) {
                        throw (Error)e.getCause();
                    }
                    throw new RuntimeException(e.getCause());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.executor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void schedule(Runnable childStatement) {
            this.futures.add(this.executor.submit(childStatement));
        }
    }
}

