/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.ds.internal.annotations.BuildPathMarkerResolution;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationCompilationParticipant;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationVersion;
import org.eclipse.pde.ds.internal.annotations.Messages;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class BuildPathMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static final String[] ANNOTATIONS_LIB_BUNDLES = new String[]{"org.eclipse.pde.ds.lib", "org.eclipse.pde.ds1_2.lib"};
    private static final String[] ANNOTATIONS_JAR_URLS = new String[]{"platform:/plugin/org.eclipse.pde.ds.lib/annotations.jar", "platform:/plugin/org.eclipse.pde.ds1_2.lib/annotations.jar"};
    private static final String[] ANNOTATIONS_PACKAGE_VERSION_RANGES = new String[]{"[1.3.0,2.0.0)", "[1.2.0,2.0.0)"};

    public boolean hasResolutions(IMarker marker) {
        try {
            return "org.eclipse.pde.ds.annotations.buildpath_problem".equals(marker.getType());
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        DSAnnotationVersion specVersion;
        IPreferencesService prefs = Platform.getPreferencesService();
        IScopeContext[] scope = new IScopeContext[]{new ProjectScope(marker.getResource().getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        try {
            specVersion = DSAnnotationVersion.valueOf(prefs.getString("org.eclipse.pde.ds.annotations", "dsVersion", DSAnnotationVersion.V1_3.name(), scope));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            specVersion = DSAnnotationVersion.V1_3;
        }
        int entryIndex = Math.min(DSAnnotationVersion.V1_3.ordinal() - specVersion.ordinal(), ANNOTATIONS_LIB_BUNDLES.length);
        final String libBundle = ANNOTATIONS_LIB_BUNDLES[entryIndex];
        final String jarUrl = ANNOTATIONS_JAR_URLS[entryIndex];
        final String packageVersionRange = ANNOTATIONS_PACKAGE_VERSION_RANGES[entryIndex];
        IMarkerResolution[] resolutions = new IMarkerResolution[]{new BuildPathMarkerResolution(Messages.BuildPathMarkerResolutionGenerator_additionalBundleResolution_label, NLS.bind((String)Messages.BuildPathMarkerResolutionGenerator_additionalBundleResolution_description, (Object)libBundle), PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PLUGIN_OBJ)){

            @Override
            protected ModelModification createModification(IMarker marker) {
                IProject project = (IProject)marker.getResource();
                return new ModelModification(PDEProject.getBuildProperties((IProject)project)){

                    protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                        if (model instanceof IBuildModel) {
                            BuildPathMarkerResolutionGenerator.this.addAdditionalBundle((IBuildModel)model, libBundle);
                        }
                    }
                };
            }
        }, new BuildPathMarkerResolution(Messages.BuildPathMarkerResolutionGenerator_extraLibraryResolution_label, NLS.bind((String)Messages.BuildPathMarkerResolutionGenerator_extraLibraryResolution_description, (Object)libBundle), JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_src_obj.gif")){

            @Override
            protected ModelModification createModification(IMarker marker) {
                IProject project = (IProject)marker.getResource();
                return new ModelModification(PDEProject.getBuildProperties((IProject)project)){

                    protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                        if (model instanceof IBuildModel) {
                            BuildPathMarkerResolutionGenerator.this.addExtraLibrary((IBuildModel)model, jarUrl);
                        }
                    }
                };
            }
        }, new BuildPathMarkerResolution(Messages.BuildPathMarkerResolutionGenerator_packageImportResolution_label, NLS.bind((String)Messages.BuildPathMarkerResolutionGenerator_packageImportResolution_description, (Object)DSAnnotationCompilationParticipant.ANNOTATIONS_PACKAGE), PDEPluginImages.get((String)PDEPluginImages.OBJ_DESC_PACKAGE)){

            @Override
            protected ModelModification createModification(IMarker marker) {
                IProject project = (IProject)marker.getResource();
                return new ModelModification(project){

                    protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                        if (model instanceof IBundlePluginModelBase) {
                            BuildPathMarkerResolutionGenerator.this.addPackageImport((IBundlePluginModelBase)model, packageVersionRange);
                        }
                    }
                };
            }
        }};
        return resolutions;
    }

    private void addAdditionalBundle(IBuildModel model, String libBundle) throws CoreException {
        IBuild build = model.getBuild();
        IBuildEntry entry = build.getEntry("additional.bundles");
        if (entry == null) {
            entry = model.getFactory().createEntry("additional.bundles");
            build.add(entry);
        }
        if (!entry.contains(libBundle)) {
            entry.addToken(libBundle);
        }
    }

    private void addExtraLibrary(IBuildModel model, String jarUrl) throws CoreException {
        IBuild build = model.getBuild();
        IBuildEntry entry = build.getEntry("jars.extra.classpath");
        if (entry == null) {
            entry = model.getFactory().createEntry("jars.extra.classpath");
            build.add(entry);
        }
        if (!entry.contains(jarUrl)) {
            entry.addToken(jarUrl);
        }
    }

    private void addPackageImport(IBundlePluginModelBase model, String packageVersionRange) throws CoreException {
        ImportPackageObject pkg;
        IBundleModel bundleModel = model.getBundleModel();
        IBundle bundle = bundleModel.getBundle();
        ImportPackageHeader header = (ImportPackageHeader)bundle.getManifestHeader("Import-Package");
        boolean changed = false;
        if (header == null) {
            header = (ImportPackageHeader)bundleModel.getFactory().createHeader("Import-Package", "");
            changed = true;
        }
        if ((pkg = header.getPackage(DSAnnotationCompilationParticipant.ANNOTATIONS_PACKAGE)) == null) {
            pkg = header.addPackage(DSAnnotationCompilationParticipant.ANNOTATIONS_PACKAGE);
            pkg.setVersion(packageVersionRange);
            pkg.setOptional(true);
            changed = true;
        } else if (pkg.getVersion() != null && !new VersionRange(pkg.getVersion()).includes(new Version(1, 2, 0))) {
            pkg.setVersion(packageVersionRange);
            changed = true;
        }
        if (changed) {
            header.update();
            bundle.setHeader("Import-Package", header.getValue());
        }
    }
}

