/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.registration;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecoretools.registration.EMFRegistryHelper;
import org.eclipse.emf.ecoretools.registration.exceptions.NotValidEPackageURIException;

public class EcoreRegisteringHelper {
    public static void registerPackages(IFile ecoreFile) throws NotValidEPackageURIException {
        String strURI = "platform:/resource" + ecoreFile.getFullPath().toString();
        URI mmURI = URI.createURI((String)strURI);
        EcoreRegisteringHelper.registerPackages(mmURI);
    }

    public static void registerPackages(URI ecoreFileUri) throws NotValidEPackageURIException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource res = rs.getResource(ecoreFileUri, true);
        for (EObject eobj : res.getContents()) {
            if (!(eobj instanceof EPackage)) continue;
            EcoreRegisteringHelper.registerPackages((EPackage)eobj);
        }
    }

    public static void registerPackages(EPackage pack) throws NotValidEPackageURIException {
        String pack_NsURI = pack.getNsURI();
        if (pack_NsURI != null && !pack_NsURI.equals("")) {
            if (!EPackage.Registry.INSTANCE.containsKey((Object)pack_NsURI)) {
                EPackage.Registry.INSTANCE.put((Object)pack_NsURI, (Object)pack);
            }
            for (EPackage subPack : pack.getESubpackages()) {
                EcoreRegisteringHelper.registerPackages(subPack);
            }
        } else {
            throw new NotValidEPackageURIException(pack);
        }
    }

    public static void unregisterPackages(IFile ecoreFile) throws NotValidEPackageURIException {
        String strURI = "platform:/resource" + ecoreFile.getFullPath().toString();
        URI mmURI = URI.createURI((String)strURI);
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource res = rs.getResource(mmURI, true);
        for (EObject eobj : res.getContents()) {
            if (!(eobj instanceof EPackage)) continue;
            EcoreRegisteringHelper.unregisterPackages((EPackage)eobj);
        }
        ArrayList packages = new ArrayList();
        packages.addAll(EPackage.Registry.INSTANCE.values());
        for (Object pack : packages) {
            EPackage p;
            if (!(pack instanceof EPackage) || (p = (EPackage)pack).eResource() == null || !p.eResource().getURI().equals(res.getURI())) continue;
            try {
                EcoreRegisteringHelper.unregisterPackages(p);
            }
            catch (NotValidEPackageURIException notValidEPackageURIException) {
                // empty catch block
            }
        }
    }

    public static void unregisterPackages(EPackage pack) throws NotValidEPackageURIException {
        String pack_NsURI = pack.getNsURI();
        if (pack_NsURI != null && !pack_NsURI.equals("")) {
            if (EMFRegistryHelper.isDynamicallyRegistered(pack_NsURI)) {
                for (EPackage subpack : pack.getESubpackages()) {
                    EcoreRegisteringHelper.unregisterPackages(subpack);
                }
                EPackage.Registry.INSTANCE.remove((Object)pack_NsURI);
            }
        } else {
            throw new NotValidEPackageURIException(pack);
        }
    }
}

