/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.gemoc_studio.branding.discovery.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.amalgam.discovery.InstallableComponent;
import org.eclipse.amalgam.discovery.ui.common.internal.DiscoveryUiUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gemoc.gemoc_studio.branding.Activator;
import org.eclipse.gemoc.gemoc_studio.branding.discovery.wizards.Messages;
import org.eclipse.gemoc.gemoc_studio.branding.discovery.wizards.PrepareInstallProfileJob;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class Installer {
    public static boolean install(Collection<InstallableComponent> descriptors, IRunnableContext context) {
        PrepareInstallProfileJob job = new PrepareInstallProfileJob(descriptors);
        try {
            context.run(true, true, (IRunnableWithProgress)job);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.gemoc.gemoc_studio.branding", NLS.bind((String)Messages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            Activator.getDefault().getLog().log((IStatus)status);
            Installer.displayStatus(DiscoveryUiUtil.getShell(), Messages.ConnectorDiscoveryWizard_cannotInstall, (IStatus)status, true);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static void displayStatus(Shell shell, String title, IStatus status, boolean showLinkToErrorLog) {
        String message = Installer.getFullMessage(status);
        if (showLinkToErrorLog) {
            message = String.valueOf(message) + "  \n see error log";
        }
        switch (status.getSeverity()) {
            case 1: 
            case 8: {
                DiscoveryUiUtil.createDialog((Shell)shell, (String)title, (String)message, (int)2).open();
                break;
            }
            case 2: {
                DiscoveryUiUtil.createDialog((Shell)shell, (String)title, (String)message, (int)4).open();
                break;
            }
            default: {
                DiscoveryUiUtil.createDialog((Shell)shell, (String)title, (String)message, (int)1).open();
            }
        }
    }

    public static String getFullMessage(IStatus status) {
        if (status.isMultiStatus()) {
            StringBuilder sb = new StringBuilder();
            sb.append(status.getMessage());
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus subStatus = iStatusArray[n2];
                sb.append("\n");
                sb.append(Installer.getFullMessage(subStatus));
                ++n2;
            }
            return sb.toString();
        }
        return status.getMessage();
    }
}

