/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.modelunfolding;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Element;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.Block;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.ClassicalExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.AbstractEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.BindableEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Binding;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConcreteEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConditionalExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConditionalRelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExprCase;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Expression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionLibrary;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExternalExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExternalRelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.KernelExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.Coincidence;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.KernelRelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelCase;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Relation;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationLibrary;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.UserExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.UserRelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Clock;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import fr.inria.aoste.timesquare.ccslkernel.model.visitor.Visitor;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.AbstractConcreteMapping;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.ClassicalExpressionEvaluator;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.ConstantChecker;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.EqualitySolver;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiationPath;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.RecursiveDefinitionChecker;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.UnfoldModel;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.DefinitionNotFound;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.ElementNotInstantiated;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.ExceptionWrapper;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.NotInScope;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.UnboundAbstract;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.UnfoldingException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModelUnfoldingPassTwo
extends Visitor<InstantiatedElement> {
    protected Deque<Block> blockStack;
    protected InstantiationPath instantiationPath;
    protected UnfoldModel unfoldModel;
    protected Deque<AbstractConcreteMapping<InstantiatedElement>> mappingStack;
    protected InstantiatedElement dummy = new InstantiatedElement(null, null);
    protected EqualitySolver<InstantiatedElement> equalitySolver;

    public ModelUnfoldingPassTwo(UnfoldModel unfoldModel) {
        this.unfoldModel = unfoldModel;
        this.instantiationPath = new InstantiationPath();
        this.blockStack = new ArrayDeque<Block>();
        this.mappingStack = new ArrayDeque<AbstractConcreteMapping<InstantiatedElement>>();
        this.mappingStack.push(new AbstractConcreteMapping());
        this.equalitySolver = new EqualitySolver();
    }

    public EqualitySolver<InstantiatedElement> getEqualitySolver() {
        return this.equalitySolver;
    }

    private void pushAbstractConcreteMapping() {
        AbstractConcreteMapping<InstantiatedElement> current = this.mappingStack.peek();
        this.mappingStack.push(new AbstractConcreteMapping<InstantiatedElement>(current));
    }

    private void popAbstractConcreteMapping() {
        this.mappingStack.pop();
    }

    private boolean isElementInLibrary(NamedElement elt) {
        EObject container = elt.eContainer();
        return container != null && (container instanceof ExpressionLibrary || container instanceof RelationLibrary);
    }

    private InstantiatedElement lookupElementInLibrary(NamedElement elt) {
        InstantiatedElement res = null;
        InstantiationPath physicalPath = new InstantiationPath();
        NamedElement container1 = elt;
        while (container1 != null) {
            physicalPath.add(0, container1);
            container1 = container1.eContainer();
        }
        res = this.unfoldModel.getInstantiationTree().lookupInstance(physicalPath);
        if (res == null) {
            res = new InstantiatedElement(physicalPath, null);
            this.unfoldModel.getInstantiationTree().storeInstance(physicalPath, res);
        }
        return res;
    }

    private boolean isElementInImportedModel(NamedElement elt) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)elt);
        return rootContainer != null && rootContainer instanceof ClockConstraintSystem;
    }

    private InstantiatedElement lookupElementInImportedModel(NamedElement elt) {
        InstantiatedElement res = null;
        InstantiationPath physicalPath = new InstantiationPath();
        NamedElement container1 = elt;
        while (container1 != null) {
            physicalPath.add(0, container1);
            container1 = container1.eContainer();
        }
        res = this.unfoldModel.getInstantiationTree().lookupInstance(physicalPath);
        if (res == null) {
            res = new InstantiatedElement(physicalPath, null);
            this.unfoldModel.getInstantiationTree().storeInstance(physicalPath, res);
        }
        return res;
    }

    private InstantiatedElement lookupElement(NamedElement elt) {
        InstantiatedElement res = null;
        EObject container = elt.eContainer();
        if (this.isElementInLibrary(elt)) {
            return this.lookupElementInLibrary(elt);
        }
        if (this.isElementInImportedModel(elt)) {
            return this.lookupElementInImportedModel(elt);
        }
        if (!this.instantiationPath.contains(container)) {
            throw new ExceptionWrapper(new NotInScope("Element " + elt.getName() + " not defined in scope"));
        }
        InstantiationPath lookupPath = new InstantiationPath(this.instantiationPath);
        while (!lookupPath.isEmpty()) {
            if (lookupPath.peekLast() == container) break;
            lookupPath.pop();
        }
        lookupPath.push(elt);
        res = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
        if (res == null) {
            throw new ExceptionWrapper(new ElementNotInstantiated("Element " + elt.getName() + " not instantiated"));
        }
        return res;
    }

    private void resolveBinding(Binding bd) {
        AbstractEntity abs = bd.getAbstract();
        BindableEntity bindable = bd.getBindable();
        InstantiatedElement value = null;
        value = bindable instanceof AbstractEntity ? this.mappingStack.peek().resolveAbstractEntity((AbstractEntity)bindable) : this.lookupElement((NamedElement)bindable);
        value.incUseCount();
        this.mappingStack.peek().setLocalValue(abs, value);
    }

    private void checkParameters(EList<AbstractEntity> paramList) {
        for (AbstractEntity param : paramList) {
            InstantiatedElement value = this.mappingStack.peek().resolveAbstractEntity(param);
            if (value != null) continue;
            throw new ExceptionWrapper(new UnboundAbstract("Parameter " + param.getName() + " not bound"));
        }
    }

    protected InstantiatedElement visitClockConstraintSystem(ClockConstraintSystem cs) {
        this.blockStack.push((Block)cs);
        this.instantiationPath.push((NamedElement)cs);
        InstantiatedElement elt = (InstantiatedElement)this.visit((EObject)cs.getSuperBlock());
        this.instantiationPath.pop();
        this.blockStack.pop();
        return elt;
    }

    protected InstantiatedElement visitBlock(Block object) {
        if (this.blockStack.contains(object)) {
            return this.dummy;
        }
        this.blockStack.push(object);
        this.instantiationPath.push((NamedElement)object);
        for (Element elt : object.getElements()) {
            this.visit((EObject)elt);
        }
        for (Expression ex : object.getExpressions()) {
            this.visit((EObject)ex);
        }
        for (Relation rel : object.getRelations()) {
            this.visit((EObject)rel);
        }
        for (Block sub : object.getSubBlock()) {
            this.visit((EObject)sub);
        }
        for (ClassicalExpression classicalExpr : object.getClassicalExpression()) {
            this.visit((EObject)classicalExpr);
        }
        this.instantiationPath.pop();
        this.blockStack.pop();
        return this.dummy;
    }

    protected InstantiatedElement visitClock(Clock c) {
        this.instantiationPath.push((NamedElement)c);
        InstantiatedElement element = this.unfoldModel.getInstantiationTree().lookupInstance(this.instantiationPath);
        if (element == null) {
            throw new ExceptionWrapper(new ElementNotInstantiated("Clock " + this.instantiationPath.toString() + " not instantiated"));
        }
        element.setAbstractMapping(this.mappingStack.peek());
        element.setLeaf(true);
        this.instantiationPath.pop();
        return element;
    }

    protected InstantiatedElement visitClassicalExpression(ClassicalExpression object) {
        this.instantiationPath.push((NamedElement)object);
        InstantiatedElement element = this.unfoldModel.getInstantiationTree().lookupInstance(this.instantiationPath);
        if (element == null) {
            throw new ExceptionWrapper(new ElementNotInstantiated("ClassicalExpression " + this.instantiationPath.toString() + " not instantiated"));
        }
        element.setAbstractMapping(this.mappingStack.peek());
        element.setLeaf(true);
        try {
            ConstantChecker constChecker = new ConstantChecker(this.mappingStack.peek());
            boolean isConstant = constChecker.isConstant(element);
            if (isConstant) {
                ClassicalExpressionEvaluator eval = new ClassicalExpressionEvaluator(this.mappingStack.peek());
                Element value = eval.evaluate(element);
                element.setConstant(true);
                element.setValue(value);
            }
        }
        catch (UnfoldingException e) {
            element.setConstant(false);
            element.setValue(null);
        }
        this.instantiationPath.pop();
        return element;
    }

    protected InstantiatedElement visitPrimitiveElement(PrimitiveElement el) {
        this.instantiationPath.push((NamedElement)el);
        InstantiatedElement element = this.unfoldModel.getInstantiationTree().lookupInstance(this.instantiationPath);
        if (element == null) {
            throw new ExceptionWrapper(new ElementNotInstantiated("Element " + this.instantiationPath.toString() + " not instantiated"));
        }
        element.setAbstractMapping(this.mappingStack.peek());
        element.setLeaf(true);
        this.instantiationPath.pop();
        return element;
    }

    protected InstantiatedElement visitExpression(Expression ex) {
        this.instantiationPath.push((NamedElement)ex);
        this.pushAbstractConcreteMapping();
        for (Binding b : ex.getBindings()) {
            this.resolveBinding(b);
        }
        InstantiatedElement element = this.unfoldModel.getInstantiationTree().lookupInstance(this.instantiationPath);
        if (element == null) {
            throw new ExceptionWrapper(new ElementNotInstantiated("Expression " + this.instantiationPath.toString() + " not instantiated"));
        }
        element.setAbstractMapping(this.mappingStack.peek());
        ExpressionDeclaration decl = ex.getType();
        if (decl instanceof KernelExpressionDeclaration) {
            element.setLeaf(true);
            element.setIsKernel(true);
        } else {
            if (decl instanceof ExpressionDeclaration) {
                this.checkParameters((EList<AbstractEntity>)decl.getParameters());
            }
            element.setLeaf(false);
            element.setIsKernel(false);
            ExpressionDefinition def = this.unfoldModel.lookupExpressionDefinition(decl);
            if (def == null) {
                throw new ExceptionWrapper(new DefinitionNotFound("No definition found for expression declaration " + decl.getName()));
            }
            element.setDefinition((NamedElement)def);
            this.unfoldModel.recordExpressionDefinitionUse(decl, def);
            if (def instanceof ExternalExpressionDefinition) {
                element.setLeaf(true);
            } else {
                int defIndex = this.instantiationPath.lastIndexOf(def);
                RecursiveDefinitionChecker checker = new RecursiveDefinitionChecker(def);
                if (defIndex >= 0 && defIndex == this.instantiationPath.size() - 2 && checker.isTailRecursive()) {
                    element.setRecursiveCall(true);
                    element.setTailRecursiveCall(true);
                } else {
                    this.visit((EObject)def);
                }
                if (def instanceof ConditionalExpressionDefinition) {
                    element.setConditional(true);
                } else {
                    element.setConditional(false);
                }
            }
        }
        this.popAbstractConcreteMapping();
        this.instantiationPath.pop();
        return element;
    }

    protected InstantiatedElement visitUserExpressionDefinition(UserExpressionDefinition def) {
        InstantiatedElement current = this.unfoldModel.getInstantiationTree().lookupInstance(this.instantiationPath);
        this.instantiationPath.push((NamedElement)def);
        for (ConcreteEntity concrete : def.getConcreteEntities()) {
            this.visit((EObject)concrete);
            InstantiationPath lookupPath = new InstantiationPath(this.instantiationPath);
            lookupPath.push((NamedElement)concrete);
            InstantiatedElement element = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
            element.setParent(current);
            if (concrete != def.getRootExpression()) continue;
            InstantiationPath rootLookupPath = new InstantiationPath(this.instantiationPath);
            rootLookupPath.push((NamedElement)def.getRootExpression());
            InstantiatedElement rootExpression = this.unfoldModel.getInstantiationTree().lookupInstance(rootLookupPath);
            if (rootExpression == null) {
                throw new ExceptionWrapper(new ElementNotInstantiated("Root expression not instantiated " + rootLookupPath.getLast().getName() + " in path " + this.instantiationPath.toString()));
            }
            current.setRootExpression(rootExpression);
            this.equalitySolver.registerEquality(current, rootExpression);
        }
        for (ClassicalExpression classicalExpression : def.getClassicalExpressions()) {
            this.visit((EObject)classicalExpression);
        }
        this.instantiationPath.removeLast((NamedElement)def);
        return current;
    }

    protected InstantiatedElement visitConditionalExpressionDefinition(ConditionalExpressionDefinition cd) {
        InstantiatedElement element;
        InstantiationPath lookupPath;
        InstantiatedElement parent = this.unfoldModel.getInstantiationTree().lookupInstance(this.instantiationPath);
        parent.setConditional(true);
        this.instantiationPath.push((NamedElement)cd);
        for (ClassicalExpression expr : cd.getClassicalExpressions()) {
            this.visit((EObject)expr);
            lookupPath = new InstantiationPath(this.instantiationPath);
            lookupPath.push((NamedElement)expr);
            element = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
            element.setParent(parent);
        }
        for (ConcreteEntity concrete : cd.getConcreteEntities()) {
            this.visit((EObject)concrete);
            lookupPath = new InstantiationPath(this.instantiationPath);
            lookupPath.push((NamedElement)concrete);
            element = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
            element.setParent(parent);
        }
        for (ExprCase eCase : cd.getExprCases()) {
            this.visit((EObject)eCase);
            lookupPath = new InstantiationPath(this.instantiationPath);
            lookupPath.push((NamedElement)eCase.getExpression());
            InstantiatedElement caseExpression = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
            parent.addConditionCase(caseExpression);
            caseExpression.setConditionCase(true);
            caseExpression.setParent(parent);
            lookupPath.pop();
            lookupPath.push((NamedElement)eCase.getCondition());
            InstantiatedElement caseTest = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
            caseExpression.setConditionTest(caseTest);
        }
        if (cd.getDefaultExpression() != null) {
            this.visit((EObject)cd.getDefaultExpression());
            InstantiationPath lookupPath2 = new InstantiationPath(this.instantiationPath);
            lookupPath2.push((NamedElement)cd.getDefaultExpression());
            InstantiatedElement defaultExpression = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath2);
            parent.setDefaultCase(defaultExpression);
            defaultExpression.setConditionTest(null);
            defaultExpression.setConditionCase(true);
            defaultExpression.setParent(parent);
        }
        this.instantiationPath.pop();
        return parent;
    }

    protected InstantiatedElement visitExprCase(ExprCase object) {
        this.visit((EObject)object.getCondition());
        return (InstantiatedElement)this.visit((EObject)object.getExpression());
    }

    protected InstantiatedElement visitRelation(Relation rel) {
        this.instantiationPath.push((NamedElement)rel);
        this.pushAbstractConcreteMapping();
        for (Binding b : rel.getBindings()) {
            this.resolveBinding(b);
        }
        InstantiatedElement element = this.unfoldModel.getInstantiationTree().lookupInstance(this.instantiationPath);
        if (element == null) {
            throw new ExceptionWrapper(new ElementNotInstantiated("Relation " + this.instantiationPath.toString() + " not instantiated"));
        }
        element.setAbstractMapping(this.mappingStack.peek());
        element.setAssertion(rel.getIsAnAssertion());
        RelationDeclaration decl = rel.getType();
        if (decl instanceof KernelRelationDeclaration) {
            element.setLeaf(true);
            element.setIsKernel(true);
            if (decl instanceof Coincidence) {
                AbstractEntity left = ((KernelRelationDeclaration)decl).getLeftEntity();
                AbstractEntity right = ((KernelRelationDeclaration)decl).getRightEntity();
                InstantiatedElement leftElt = this.mappingStack.peek().resolveAbstractEntity(left);
                InstantiatedElement rightElt = this.mappingStack.peek().resolveAbstractEntity(right);
                this.equalitySolver.registerEquality(leftElt, rightElt);
            }
        } else {
            if (decl instanceof RelationDeclaration) {
                this.checkParameters((EList<AbstractEntity>)decl.getParameters());
            }
            element.setLeaf(false);
            element.setIsKernel(false);
            RelationDefinition def = this.unfoldModel.lookupRelationDefinition(decl);
            if (def == null) {
                throw new ExceptionWrapper(new DefinitionNotFound("No definition found for relation declaration" + decl.getName()));
            }
            element.setDefinition((NamedElement)def);
            this.unfoldModel.recordRelationDefinitionUse(decl, def);
            if (def instanceof ExternalRelationDefinition) {
                element.setLeaf(true);
            } else {
                this.visit((EObject)def);
                if (def instanceof ConditionalRelationDefinition) {
                    element.setConditional(true);
                }
            }
        }
        this.popAbstractConcreteMapping();
        this.instantiationPath.pop();
        return element;
    }

    protected InstantiatedElement visitUserRelationDefinition(UserRelationDefinition object) {
        InstantiatedElement parent = this.unfoldModel.getInstantiationTree().lookupInstance(this.instantiationPath);
        this.instantiationPath.push((NamedElement)object);
        for (ConcreteEntity concrete : object.getConcreteEntities()) {
            this.visit((EObject)concrete);
            InstantiationPath lookupPath = new InstantiationPath(this.instantiationPath);
            lookupPath.push((NamedElement)concrete);
            InstantiatedElement element = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
            element.setParent(parent);
            if (!parent.isAssertion() || !element.isRelation()) continue;
            element.setAssertion(true);
        }
        this.instantiationPath.pop();
        return parent;
    }

    protected InstantiatedElement visitConditionalRelationDefinition(ConditionalRelationDefinition object) {
        InstantiatedElement element;
        InstantiationPath lookupPath;
        InstantiatedElement parent = this.unfoldModel.getInstantiationTree().lookupInstance(this.instantiationPath);
        this.instantiationPath.push((NamedElement)object);
        for (ClassicalExpression expr : object.getClassicalExpressions()) {
            this.visit((EObject)expr);
            lookupPath = new InstantiationPath(this.instantiationPath);
            lookupPath.push((NamedElement)expr);
            element = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
            element.setParent(parent);
        }
        for (ConcreteEntity concrete : object.getConcreteEntities()) {
            this.visit((EObject)concrete);
            lookupPath = new InstantiationPath(this.instantiationPath);
            lookupPath.push((NamedElement)concrete);
            element = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
            element.setParent(parent);
        }
        for (RelCase cas : object.getRelCases()) {
            this.visit((EObject)cas);
            lookupPath = new InstantiationPath(this.instantiationPath);
            lookupPath.push((NamedElement)cas.getCondition());
            InstantiatedElement condition = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
            parent.addConditionCase(condition);
            condition.setParent(parent);
            for (Relation rel : cas.getRelation()) {
                lookupPath = new InstantiationPath(this.instantiationPath);
                lookupPath.push((NamedElement)rel);
                InstantiatedElement element2 = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
                element2.setParent(parent);
                element2.setConditionCase(true);
                element2.setConditionTest(condition);
            }
        }
        for (Relation rel : object.getDefaultRelation()) {
            this.visit((EObject)rel);
            lookupPath = new InstantiationPath(this.instantiationPath);
            lookupPath.push((NamedElement)rel);
            element = this.unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
            element.setParent(parent);
            parent.setDefaultCase(element);
            element.setConditionCase(true);
        }
        this.instantiationPath.pop();
        return parent;
    }

    protected InstantiatedElement visitRelCase(RelCase object) {
        this.visit((EObject)object.getCondition());
        for (Relation rel : object.getRelation()) {
            this.visit((EObject)rel);
        }
        return this.dummy;
    }
}

