/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.expressions.ICountable;
import org.eclipse.core.expressions.IIterable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SelectionAdapterFactory
implements IAdapterFactory {
    private static final ICountable ICOUNT_0 = () -> 0;
    private static final ICountable ICOUNT_1 = () -> 1;
    private static final IIterable ITERATE_EMPTY = Collections.EMPTY_LIST::iterator;
    private static final Class[] CLASSES = new Class[]{IIterable.class, ICountable.class};

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof ISelection) {
            if (adapterType == IIterable.class) {
                return adapterType.cast(this.iterable((ISelection)adaptableObject));
            }
            if (adapterType == ICountable.class) {
                return adapterType.cast(this.countable((ISelection)adaptableObject));
            }
        }
        return null;
    }

    private Object iterable(ISelection sel) {
        if (sel.isEmpty()) {
            return ITERATE_EMPTY;
        }
        if (sel instanceof IStructuredSelection) {
            return () -> ((IStructuredSelection)sel).iterator();
        }
        List<Object> list = Arrays.asList(sel);
        return list::iterator;
    }

    private Object countable(ISelection sel) {
        if (sel.isEmpty()) {
            return ICOUNT_0;
        }
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)sel;
            return () -> ((IStructuredSelection)ss).size();
        }
        return ICOUNT_1;
    }

    public Class[] getAdapterList() {
        return CLASSES;
    }
}

