/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.internal.navigation;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IJavaAwareInterpreter;
import org.eclipse.sirius.editor.Messages;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.sirius.editor.internal.navigation.INavigatorFromVSMExpression;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ServiceNavigator
implements INavigatorFromVSMExpression {
    private Set<IJavaElement> navigationTargets = new HashSet<IJavaElement>();

    @Override
    public void triggerNavigation(AbstractViewpointPropertySection propertySection, EObject targetEObject, ContentContext contentContext) {
        try {
            if (this.navigationTargets.isEmpty()) {
                this.initializeNavigationTarget(propertySection, targetEObject, contentContext);
            }
            if (this.navigationTargets.size() == 1) {
                JavaUI.openInEditor((IJavaElement)this.navigationTargets.iterator().next());
            } else {
                IJavaSearchScope javaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])this.navigationTargets.toArray(new IJavaElement[0]));
                OpenTypeSelectionDialog dialog = new OpenTypeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), true, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), javaSearchScope, 1);
                dialog.setTitle(Messages.ServiceNavigator_serviceNavigationDialog_title);
                dialog.setMessage(Messages.ServiceNavigator_serviceNavigationDialog_description);
                dialog.setInitialPattern("?");
                int result = dialog.open();
                if (result == 0) {
                    Object[] types = dialog.getResult();
                    Arrays.stream(types).forEach(type -> {
                        for (IJavaElement navigationTarget : this.navigationTargets) {
                            if (navigationTarget == null || !navigationTarget.getParent().equals(type)) continue;
                            try {
                                JavaUI.openInEditor((IJavaElement)navigationTarget);
                            }
                            catch (JavaModelException | PartInitException e) {
                                SiriusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.editor", MessageFormat.format(Messages.ServiceNavigator_targetInitialization_error, contentContext.getContents()), e));
                            }
                        }
                    });
                }
            }
        }
        catch (JavaModelException | PartInitException e) {
            SiriusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.editor", MessageFormat.format(Messages.ServiceNavigator_targetInitialization_error, contentContext.getContents()), e));
        }
    }

    private void initializeNavigationTarget(AbstractViewpointPropertySection propertySection, EObject targetEObject, ContentContext contentContext) throws JavaModelException {
        String vsmExpression = contentContext.getContents();
        String serviceCallNameWithParenthesis = this.extractServiceCall(contentContext);
        if (serviceCallNameWithParenthesis != null) {
            IInterpreter itp;
            String serviceCallName = serviceCallNameWithParenthesis;
            int leftParenthesisIndex = serviceCallName.indexOf("(");
            int rightParenthesisIndex = serviceCallName.indexOf(")");
            if (leftParenthesisIndex != -1) {
                serviceCallName = serviceCallName.substring(0, leftParenthesisIndex);
            }
            serviceCallName = serviceCallName.trim();
            if ((serviceCallName = serviceCallName.replaceAll("self.", "")).startsWith("service:")) {
                serviceCallName.replaceFirst("service:", "");
            }
            if ((itp = CompoundInterpreter.INSTANCE.getInterpreterForExpression(vsmExpression)) instanceof IJavaAwareInterpreter) {
                IInterpreterContext interpreterContext = contentContext.getInterpreterContext();
                Collection imports = interpreterContext.getDependencies();
                for (String tempImport : imports) {
                    itp.addImport(tempImport);
                }
                Resource vsmResource = interpreterContext.getElement().eResource();
                if (vsmResource != null) {
                    itp.setProperty((Object)"files", new ArrayList<String>(Arrays.asList(vsmResource.getURI().toPlatformString(true))));
                }
                Collection implementations = ((IJavaAwareInterpreter)itp).getImplementation(serviceCallName);
                block1: for (Method m : implementations) {
                    IType serviceClass;
                    Resource vsm;
                    if (m == null || !(vsm = targetEObject.eResource()).getURI().isPlatformResource()) continue;
                    String projectName = vsm.getURI().segment(1);
                    IProject rawProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    if (rawProject == null) continue;
                    JavaCore.getJavaCore();
                    IJavaProject javaProject = JavaCore.create((IProject)rawProject);
                    if (javaProject == null || (serviceClass = javaProject.findType(m.getDeclaringClass().getName())) == null || !serviceClass.exists()) continue;
                    IMethod[] iMethodArray = serviceClass.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean onlySelfParameter;
                        IMethod jm = iMethodArray[n2];
                        boolean bl = onlySelfParameter = leftParenthesisIndex == -1 && rightParenthesisIndex == -1;
                        if (jm.getElementName().equals(serviceCallName)) {
                            int methodParametersNumber = jm.getParameters().length;
                            long serviceParametersNumber = this.getServiceParametersNumber(vsmExpression, leftParenthesisIndex, rightParenthesisIndex);
                            if (!onlySelfParameter && (long)methodParametersNumber == serviceParametersNumber || onlySelfParameter && methodParametersNumber == 1) {
                                this.navigationTargets.add((IJavaElement)jm);
                                continue block1;
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    private String extractServiceCall(ContentContext contentContext) {
        String serviceName = null;
        String expression = contentContext.getContents();
        boolean isServiceInterpreterUsed = expression.startsWith("service:");
        int cursorPosition = contentContext.getPosition();
        if (isServiceInterpreterUsed) {
            expression = expression.replaceFirst("service:", "");
            if (cursorPosition > "service:".length()) {
                cursorPosition -= "service:".length();
            }
        }
        char[] expressionArray = expression.toCharArray();
        int serviceCallStartPosition = -1;
        int i = this.initSearchPosition(expressionArray, cursorPosition);
        while (i >= 0 && serviceCallStartPosition == -1) {
            char tempChar = expressionArray[i];
            if (tempChar == '.' || tempChar == ':' || tempChar == ' ') {
                serviceCallStartPosition = i + 1;
            }
            --i;
        }
        if (i == -1 && isServiceInterpreterUsed) {
            serviceCallStartPosition = 0;
        }
        int serviceCallEndPosition = -1;
        int j = this.initSearchPosition(expressionArray, cursorPosition);
        while (j < expressionArray.length && serviceCallEndPosition == -1) {
            char tempChar = expressionArray[j];
            if (tempChar == ')') {
                serviceCallEndPosition = j + 1;
            }
            ++j;
        }
        if (serviceCallStartPosition != -1 && serviceCallEndPosition != -1) {
            serviceName = expression.substring(serviceCallStartPosition, serviceCallEndPosition);
        } else if (serviceCallEndPosition != -1 && (serviceCallStartPosition = expression.indexOf(".")) != -1 && serviceCallStartPosition < serviceCallEndPosition) {
            serviceName = expression.substring(serviceCallStartPosition + 1, serviceCallEndPosition);
        }
        return serviceName;
    }

    private int initSearchPosition(char[] expressionArray, int cursorPosition) {
        int searchPosition = cursorPosition;
        if (cursorPosition == -1) {
            searchPosition = 0;
        } else if (expressionArray.length == cursorPosition) {
            searchPosition = expressionArray.length - 1;
        }
        return searchPosition;
    }

    private long getServiceParametersNumber(String vsmExpression, int leftParenthesisIndex, int rightParenthesisIndex) {
        long parameterSeparatorNumber;
        long serviceParametersNumber = rightParenthesisIndex == leftParenthesisIndex + 1 ? 1L : ((parameterSeparatorNumber = vsmExpression.chars().filter(ch -> ch == 44).count()) == 0L ? 2L : parameterSeparatorNumber + 2L);
        return serviceParametersNumber;
    }

    @Override
    public boolean doProvideNavigationFor(AbstractViewpointPropertySection propertySection, EObject targetEObject, ContentContext contentContext) {
        try {
            this.initializeNavigationTarget(propertySection, targetEObject, contentContext);
        }
        catch (JavaModelException e) {
            SiriusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.editor", MessageFormat.format(Messages.ServiceNavigator_targetInitialization_error, contentContext.getContents()), (Throwable)e));
        }
        return !this.navigationTargets.isEmpty();
    }
}

