/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class AbstractLaunchShortcut
implements ILaunchShortcut {
    protected void launch(String mode) {
        ILaunchConfiguration configuration = this.findLaunchConfiguration(mode);
        if (configuration != null) {
            DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(String mode) {
        ILaunchConfiguration[] configs = this.getLaunchConfigurations();
        ILaunchConfiguration configuration = null;
        switch (configs.length) {
            case 0: {
                configuration = this.createNewConfiguration();
                break;
            }
            case 1: {
                configuration = configs[0];
                break;
            }
            default: {
                configuration = this.chooseConfiguration(configs, mode);
            }
        }
        return configuration;
    }

    private ILaunchConfiguration[] getLaunchConfigurations() {
        ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.getLaunchConfigurationTypeName());
            ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
            int i = 0;
            while (i < configurations.length) {
                if (!DebugUITools.isPrivate((ILaunchConfiguration)configurations[i]) && this.isGoodMatch(configurations[i])) {
                    result.add(configurations[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return result.toArray(new ILaunchConfiguration[result.size()]);
    }

    protected ILaunchConfiguration chooseConfiguration(ILaunchConfiguration[] configs, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])configs);
        dialog.setTitle(PDEUIMessages.RuntimeWorkbenchShortcut_title);
        if (mode.equals("debug")) {
            dialog.setMessage(PDEUIMessages.RuntimeWorkbenchShortcut_select_debug);
        } else {
            dialog.setMessage(PDEUIMessages.RuntimeWorkbenchShortcut_select_run);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        return result == 0 ? (ILaunchConfiguration)dialog.getFirstResult() : null;
    }

    private ILaunchConfiguration createNewConfiguration() {
        try {
            ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = lm.getLaunchConfigurationType(this.getLaunchConfigurationTypeName());
            String name = lm.generateLaunchConfigurationName(this.getName(type));
            ILaunchConfigurationWorkingCopy wc = type.newInstance(null, name);
            this.initializeConfiguration(wc);
            wc.setAttribute("pde.generated.config", true);
            return wc.doSave();
        }
        catch (CoreException ce) {
            PDEPlugin.logException(ce);
            return null;
        }
    }

    protected String getName(ILaunchConfigurationType type) {
        return type.getName();
    }

    protected abstract void initializeConfiguration(ILaunchConfigurationWorkingCopy var1);

    protected abstract String getLaunchConfigurationTypeName();

    protected abstract boolean isGoodMatch(ILaunchConfiguration var1);
}

