/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.sirius.ui.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.dsl.debug.ide.Activator;
import org.eclipse.gemoc.dsl.debug.ide.ui.launch.FilteredFileContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DSLLaunchConfigurationTab
extends org.eclipse.gemoc.dsl.debug.ide.ui.launch.DSLLaunchConfigurationTab {
    private Text siriusResourceURIText;

    public DSLLaunchConfigurationTab(String[] extensions) {
        super(extensions);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("airdResource", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.disableUpdate = true;
        this.siriusResourceURIText.setText("");
        try {
            this.siriusResourceURIText.setText(configuration.getAttribute("Resource", ""));
        }
        catch (CoreException e) {
            Activator.getDefault().error((Throwable)e);
        }
        this.disableUpdate = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("airdResource", this.siriusResourceURIText.getText());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean res;
        block6: {
            res = super.isValid(launchConfig);
            String errorMessage = null;
            try {
                if (!res) break block6;
                String siriusResourceURI = launchConfig.getAttribute("airdResource", "");
                IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(siriusResourceURI));
                Resource resource = null;
                if (resourceFile.exists()) {
                    ResourceSetImpl rs = new ResourceSetImpl();
                    try {
                        resource = rs.getResource(URI.createPlatformResourceURI((String)siriusResourceURI, (boolean)true), true);
                    }
                    catch (WrappedException e) {
                        errorMessage = "Sirius session model can't be loaded: " + e.exception().getLocalizedMessage() + ".";
                    }
                }
                res = resource != null;
                this.setErrorMessage(errorMessage);
            }
            catch (IllegalArgumentException e) {
                this.setErrorMessage("Invalid model file selected.");
            }
            catch (CoreException e) {
                this.setErrorMessage("Invalid model file selected.");
            }
        }
        return res;
    }

    public boolean canSave() {
        return super.canSave() && !this.siriusResourceURIText.getText().isEmpty();
    }

    public void createControl(final Composite parent) {
        super.createControl(parent);
        Composite topControl = new Composite(parent, 0);
        topControl.setLayout((Layout)new GridLayout(1, false));
        Group mgroup = new Group(topControl, 0);
        mgroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mgroup.setText("Model");
        mgroup.setLayout((Layout)new GridLayout(2, false));
        this.siriusResourceURIText = new Text((Composite)mgroup, 2048);
        this.siriusResourceURIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!DSLLaunchConfigurationTab.this.disableUpdate) {
                    DSLLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.siriusResourceURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button browseResourceButton = new Button((Composite)mgroup, 0);
        browseResourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSLLaunchConfigurationTab.this.openSiriusModelSelection(parent);
            }
        });
        browseResourceButton.setText("Browse...");
    }

    private void openSiriusModelSelection(Composite parent) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new FilteredFileContentProvider(new String[]{"aird"}));
        dialog.setTitle("Select model file");
        dialog.setMessage("Select the model file to execute:");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            this.siriusResourceURIText.setText(((IFile)dialog.getFirstResult()).getFullPath().toString());
        }
    }
}

