/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.ui.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gemoc.dsl.debug.ide.Activator;
import org.eclipse.gemoc.dsl.debug.ide.ui.launch.FilteredFileContentProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DSLLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected boolean disableUpdate;
    private Text resourceURIText;
    private Text firstInstructionURIText;
    private final String[] extensions;

    public DSLLaunchConfigurationTab(String[] extensions) {
        this.extensions = extensions;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Resource", "");
        configuration.setAttribute("First Instruction", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.disableUpdate = true;
        this.resourceURIText.setText("");
        this.firstInstructionURIText.setText("");
        try {
            this.resourceURIText.setText(configuration.getAttribute("Resource", ""));
            this.firstInstructionURIText.setText(configuration.getAttribute("First Instruction", ""));
        }
        catch (CoreException e) {
            Activator.getDefault().error((Throwable)e);
        }
        this.disableUpdate = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Resource", this.resourceURIText.getText());
        configuration.setAttribute("First Instruction", this.firstInstructionURIText.getText());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean res = false;
        String errorMessage = null;
        try {
            String resourceURI = launchConfig.getAttribute("Resource", "");
            IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resourceURI));
            if (resourceFile.exists()) {
                ResourceSetImpl rs = new ResourceSetImpl();
                Resource resource = null;
                try {
                    resource = rs.getResource(URI.createPlatformResourceURI((String)resourceURI, (boolean)true), true);
                }
                catch (WrappedException e) {
                    errorMessage = "Model can't be loaded: " + e.exception().getLocalizedMessage() + ".";
                }
                EObject firstInstruction = null;
                try {
                    firstInstruction = rs.getEObject(URI.createURI((String)launchConfig.getAttribute("First Instruction", ""), (boolean)true), true);
                }
                catch (WrappedException e) {
                    errorMessage = "First instruction can't be loaded: " + e.exception().getLocalizedMessage() + ".";
                }
                if (firstInstruction == null) {
                    errorMessage = "First instruction not selected.";
                }
                res = resource != null && firstInstruction != null;
            } else {
                errorMessage = "Model file does not exist.";
            }
            this.setErrorMessage(errorMessage);
        }
        catch (IllegalArgumentException e) {
            this.setErrorMessage("Invalid model file selected.");
        }
        catch (CoreException e) {
            this.setErrorMessage("Invalid model file selected.");
        }
        return res;
    }

    public boolean canSave() {
        return !this.firstInstructionURIText.getText().isEmpty() && !this.resourceURIText.getText().isEmpty();
    }

    public String getMessage() {
        return "Please select a model file and first instruction.";
    }

    public String getName() {
        return "DSL launch";
    }

    public void createControl(final Composite parent) {
        Composite topControl = new Composite(parent, 0);
        topControl.setLayout((Layout)new GridLayout(1, false));
        Group mgroup = new Group(topControl, 0);
        mgroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mgroup.setText("Model");
        mgroup.setLayout((Layout)new GridLayout(2, false));
        this.resourceURIText = new Text((Composite)mgroup, 2048);
        this.resourceURIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!DSLLaunchConfigurationTab.this.disableUpdate) {
                    DSLLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.resourceURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button browseResourceButton = new Button((Composite)mgroup, 0);
        browseResourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSLLaunchConfigurationTab.this.openModelSelection(parent);
            }
        });
        browseResourceButton.setText("Browse...");
        Group grpLaunch = new Group(topControl, 0);
        grpLaunch.setLayout((Layout)new GridLayout(2, false));
        grpLaunch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpLaunch.setText("First instruction");
        this.firstInstructionURIText = new Text((Composite)grpLaunch, 2048);
        this.firstInstructionURIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!DSLLaunchConfigurationTab.this.disableUpdate) {
                    DSLLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.firstInstructionURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button browseModelFileButton = new Button((Composite)grpLaunch, 0);
        browseModelFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(DSLLaunchConfigurationTab.this.resourceURIText.getText()));
                if (resourceFile.exists()) {
                    ResourceSetImpl rs = new ResourceSetImpl();
                    rs.getResource(URI.createPlatformResourceURI((String)DSLLaunchConfigurationTab.this.resourceURIText.getText(), (boolean)true), true);
                    EObject firstInstruction = DSLLaunchConfigurationTab.openFirstInstructionSelection(parent.getShell(), (ResourceSet)rs);
                    if (firstInstruction != null) {
                        DSLLaunchConfigurationTab.this.firstInstructionURIText.setText(EcoreUtil.getURI((EObject)firstInstruction).toString());
                    }
                } else {
                    MessageDialog.openInformation((Shell)parent.getShell(), (String)"Model not selected", (String)"You must select a model first.");
                }
            }
        });
        browseModelFileButton.setText("Browse...");
        this.setControl((Control)topControl);
    }

    private void openModelSelection(Composite parent) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new FilteredFileContentProvider(this.extensions));
        dialog.setTitle("Select model file");
        dialog.setMessage("Select the model file to execute:");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            this.resourceURIText.setText(((IFile)dialog.getFirstResult()).getFullPath().toString());
        }
    }

    public static EObject openFirstInstructionSelection(Shell shell, ResourceSet resourceSet) {
        ComposedAdapterFactory fatory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        fatory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        fatory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)fatory), (ITreeContentProvider)new AdapterFactoryContentProvider((AdapterFactory)fatory));
        dialog.setTitle("Select first instruction");
        dialog.setMessage("Select the first instruction:");
        dialog.setInput((Object)resourceSet);
        EObject res = dialog.open() == 0 ? (EObject)dialog.getFirstResult() : null;
        fatory.dispose();
        return res;
    }
}

