/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.dsl.debug.ide.DSLBreakpoint;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DSLToggleBreakpointsUtils {
    protected final String identifier;

    public DSLToggleBreakpointsUtils(String identifier) {
        this.identifier = identifier;
    }

    public void toggleBreakpoints(ISelection selection) throws CoreException {
        if (selection instanceof IStructuredSelection) {
            for (Object selected : (IStructuredSelection)selection) {
                EObject instruction = this.getInstruction(selected);
                if (instruction == null) continue;
                this.toggleBreakpoint(selected, instruction);
            }
        }
    }

    protected void toggleBreakpoint(Object selected, EObject instruction) throws CoreException {
        DSLBreakpoint breakpoint = this.getBreakpoint(instruction);
        if (breakpoint != null) {
            breakpoint.delete();
        } else {
            breakpoint = this.createBreakpoint(selected, instruction);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)breakpoint);
        }
    }

    protected DSLBreakpoint createBreakpoint(Object selected, EObject instruction) throws CoreException {
        return new DSLBreakpoint(this.identifier, instruction, true);
    }

    protected DSLBreakpoint getBreakpoint(EObject instruction) {
        DSLBreakpoint res = null;
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.identifier);
        URI instructionURI = EcoreUtil.getURI((EObject)instruction);
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof DSLBreakpoint && ((DSLBreakpoint)breakpoint).getURI() != null && ((DSLBreakpoint)breakpoint).getURI().equals(instructionURI)) {
                res = (DSLBreakpoint)breakpoint;
                break;
            }
            ++n2;
        }
        return res;
    }

    public boolean canToggleBreakpoints(ISelection selection) {
        boolean res = false;
        if (selection instanceof IStructuredSelection) {
            for (Object selected : (IStructuredSelection)selection) {
                if (selected == null) continue;
                res = this.getInstruction(selected) != null;
                break;
            }
        }
        return res;
    }

    protected EObject getInstruction(Object selected) {
        EObject adapter;
        Object res = selected instanceof EObject ? (EObject)selected : (selected instanceof IAdaptable ? ((adapter = (EObject)((IAdaptable)selected).getAdapter(EObject.class)) != null ? adapter : (EObject)Platform.getAdapterManager().getAdapter(selected, EObject.class)) : (selected != null ? (EObject)Platform.getAdapterManager().getAdapter(selected, EObject.class) : null));
        return res;
    }
}

