/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.refactoring;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.FileBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.ide.Activator;
import org.eclipse.emf.ecoretools.ale.ide.project.IAleProject;
import org.eclipse.emf.ecoretools.ale.ide.refactoring.RenamePathsInDslFilesChange;
import org.eclipse.emf.ecoretools.ale.ide.refactoring.RenamePathsInProjectPreferencesChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class RenamePathsToAleResources
extends RenameParticipant {
    private IContainer renamed;

    protected boolean initialize(Object element) {
        if (!(element instanceof IContainer)) {
            return false;
        }
        this.renamed = (IContainer)element;
        return true;
    }

    public String getName() {
        return "Rename paths to ALE resources files when the enclosing project is renamed";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        String newName = this.getArguments().getNewName();
        CompositeChange changes = new CompositeChange("Update paths to ALE resources");
        this.changeMadeToProject(newName).ifPresent(arg_0 -> ((CompositeChange)changes).add(arg_0));
        this.changesMadeToDslFiles(newName).forEach(arg_0 -> ((CompositeChange)changes).add(arg_0));
        return changes;
    }

    private Optional<Change> changeMadeToProject(String newName) {
        IProject project = this.renamed.getProject();
        if (!IAleProject.hasAleNature(project)) {
            return Optional.empty();
        }
        IFile oldDslFile = this.findDslConfigurationFile(project);
        IFile newDslFile = oldDslFile == null ? oldDslFile : RenamePathsToAleResources.toWorkspace(this.uriAfterRenaming(oldDslFile, newName));
        IProject newProject = RenamePathsToAleResources.projectAfterRename((IResource)this.renamed, newName);
        Throwable throwable = null;
        Object var7_8 = null;
        try (IAleEnvironment env = IAleProject.from(project).getEnvironment();){
            LinkedHashSet<String> newBehaviors = this.renamedIfImpacted(env.getBehaviorsSources(), newName);
            LinkedHashSet<String> newMetamodels = this.renamedIfImpacted(env.getMetamodelsSources(), newName);
            RenamePathsInProjectPreferencesChange change = new RenamePathsInProjectPreferencesChange(newProject, oldDslFile, newDslFile, newBehaviors, newMetamodels);
            return Optional.of(change);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<Change> changesMadeToDslFiles(final String newName) throws CoreException {
        final ArrayList<Change> changes = new ArrayList<Change>();
        this.renamed.getProject().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IFile && resource.getName().endsWith(".dsl")) {
                    IFile file = (IFile)resource;
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (FileBasedAleEnvironment dsl = IAleEnvironment.fromFile((IFile)file);){
                            IFile fileAfterRenaming = RenamePathsToAleResources.toWorkspace(RenamePathsToAleResources.this.uriAfterRenaming(file, newName));
                            LinkedHashSet newBehaviors = RenamePathsToAleResources.this.renamedIfImpacted(dsl.getBehaviorsSources(), newName);
                            LinkedHashSet newMetamodels = RenamePathsToAleResources.this.renamedIfImpacted(dsl.getMetamodelsSources(), newName);
                            changes.add(new RenamePathsInDslFilesChange(fileAfterRenaming, newBehaviors, newMetamodels));
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        Activator.warn("Unable to rename paths in " + file.getFullPath(), e);
                    }
                }
                return true;
            }
        });
        return changes;
    }

    private IFile findDslConfigurationFile(IProject project) {
        return IAleProject.from(project).findDslFile().orElse(null);
    }

    private LinkedHashSet<String> renamedIfImpacted(Collection<String> uris, String newName) {
        LinkedHashSet<String> renamedURIs = new LinkedHashSet<String>();
        for (String uri : uris) {
            boolean uriHasBeenRenamed = false;
            Set<IFile> files = RenamePathsToAleResources.toWorkspaceFiles(uri);
            for (IFile file : files) {
                if (!this.isImpactedByRenaming(file)) continue;
                String renamedURI = this.uriAfterRenaming(file, newName).toString();
                renamedURIs.add(renamedURI);
                uriHasBeenRenamed = true;
            }
            if (uriHasBeenRenamed) continue;
            renamedURIs.add(uri);
        }
        return renamedURIs;
    }

    private static IProject projectAfterRename(IResource resource, String newName) {
        boolean theProjectIsBeingRenamed = resource.equals((Object)resource.getProject());
        if (theProjectIsBeingRenamed) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(newName);
        }
        return resource.getProject();
    }

    private URI uriAfterRenaming(IFile file, String newName) {
        IPath newPath = this.pathAfterRenaming(file, newName);
        URI newURI = URI.createPlatformResourceURI((String)newPath.toString(), (boolean)true);
        return newURI;
    }

    private IPath pathAfterRenaming(IFile file, String newName) {
        if (!this.isImpactedByRenaming(file)) {
            return file.getFullPath();
        }
        IPath containerPath = this.renamed.getFullPath().removeLastSegments(1);
        IPath containerPathAfterRenaiming = containerPath.append(newName);
        IPath relativeFilePath = file.getFullPath().removeFirstSegments(this.renamed.getFullPath().segmentCount());
        return containerPathAfterRenaiming.append(relativeFilePath);
    }

    private boolean isImpactedByRenaming(IFile file) {
        return file.getFullPath().matchingFirstSegments(this.renamed.getFullPath()) == this.renamed.getFullPath().segmentCount();
    }

    private static Set<IFile> toWorkspaceFiles(String uri) {
        try {
            URI behaviorURI = URI.createURI((String)uri);
            return RenamePathsToAleResources.toWorkspace(new File(RenamePathsToAleResources.toAbsoluteFilePath(behaviorURI)));
        }
        catch (NullPointerException e) {
            return new HashSet<IFile>();
        }
    }

    private static String toAbsoluteFilePath(URI uri) {
        IResource file;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        if (ws != null && (file = ws.getRoot().findMember(uri.toPlatformString(true))) != null) {
            return file.getLocationURI().getRawPath();
        }
        return null;
    }

    private static Set<IFile> toWorkspace(File file) {
        java.net.URI location = file.toURI();
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(location);
        return new HashSet<IFile>(Arrays.asList(files));
    }

    private static IFile toWorkspace(URI uri) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
    }
}

