/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.simplemap.diagram.part.SimplemapDiagramEditorPlugin;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleMapping;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimplemappingsPackage;

public class SimplemapVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.gmf.tooling.simplemap.diagram/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Simplemap".equals(view.getType())) {
                return 79;
            }
            return -1;
        }
        return SimplemapVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                SimplemapDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (SimplemappingsPackage.eINSTANCE.getSimpleMapping().isSuperTypeOf(domainElement.eClass()) && SimplemapVisualIDRegistry.isDiagram((SimpleMapping)domainElement)) {
            return 79;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = SimplemapVisualIDRegistry.getModelID(containerView);
        if (!"Simplemap".equals(containerModelID)) {
            return -1;
        }
        if ("Simplemap".equals(containerModelID)) {
            containerVisualID = SimplemapVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 79;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 79: {
                if (SimplemappingsPackage.eINSTANCE.getSimpleTopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 1001;
                }
                if (!SimplemappingsPackage.eINSTANCE.getSimpleLinkMapping().isSuperTypeOf(domainElement.eClass())) break;
                return 1002;
            }
            case 1001: {
                if (SimplemappingsPackage.eINSTANCE.getSimpleLabelNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (SimplemappingsPackage.eINSTANCE.getSimpleCompartment().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (SimplemappingsPackage.eINSTANCE.getSimpleChildReference().isSuperTypeOf(domainElement.eClass())) {
                    return 2004;
                }
                if (!SimplemappingsPackage.eINSTANCE.getSimpleSubNode().isSuperTypeOf(domainElement.eClass())) break;
                return 2003;
            }
            case 2002: {
                if (SimplemappingsPackage.eINSTANCE.getSimpleLabelNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (SimplemappingsPackage.eINSTANCE.getSimpleSubNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (!SimplemappingsPackage.eINSTANCE.getSimpleChildReference().isSuperTypeOf(domainElement.eClass())) break;
                return 2004;
            }
            case 2003: {
                if (SimplemappingsPackage.eINSTANCE.getSimpleLabelNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (SimplemappingsPackage.eINSTANCE.getSimpleCompartment().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (SimplemappingsPackage.eINSTANCE.getSimpleChildReference().isSuperTypeOf(domainElement.eClass())) {
                    return 2004;
                }
                if (!SimplemappingsPackage.eINSTANCE.getSimpleSubNode().isSuperTypeOf(domainElement.eClass())) break;
                return 2003;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = SimplemapVisualIDRegistry.getModelID(containerView);
        if (!"Simplemap".equals(containerModelID)) {
            return false;
        }
        if ("Simplemap".equals(containerModelID)) {
            containerVisualID = SimplemapVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 79;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 79: {
                if (1001 == nodeVisualID) {
                    return true;
                }
                if (1002 != nodeVisualID) break;
                return true;
            }
            case 1001: {
                if (4003 == nodeVisualID) {
                    return true;
                }
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2003 != nodeVisualID) break;
                return true;
            }
            case 1002: {
                if (4004 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (4002 == nodeVisualID) {
                    return true;
                }
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (4001 == nodeVisualID) {
                    return true;
                }
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2003 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        return -1;
    }

    private static boolean isDiagram(SimpleMapping element) {
        return true;
    }
}

