/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.DomainModelSelectionPage;
import org.eclipse.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.gmf.tooling.simplemap.diagram.part.Messages;
import org.eclipse.gmf.tooling.simplemap.diagram.part.SimpleMapEditorDiagramEditorUtil;
import org.eclipse.gmf.tooling.simplemap.diagram.part.SimplemapCreationWizardPage;
import org.eclipse.gmf.tooling.simplemap.diagram.part.SimplemapDiagramEditorPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class SimpleMapEditorCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected SimplemapCreationWizardPage diagramModelFilePage;
    protected DomainModelSelectionPage domainModelSelectionPage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.SimplemapCreationWizardTitle);
        this.setDefaultPageImageDescriptor(SimplemapDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewSimplemappingsWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        ResourceLocationProvider rloc = new ResourceLocationProvider((ISelection)this.selection);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.diagramModelFilePage = new SimplemapCreationWizardPage("DiagramModelFile", this.getSelection(), "simplemappings");
        this.diagramModelFilePage.setTitle(Messages.SimplemapCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.SimplemapCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelSelectionPage = new DomainModelSelectionPage("DomainModelSelectionPage", rloc, (ResourceSet)resourceSet);
        this.domainModelSelectionPage.setTitle(org.eclipse.gmf.internal.bridge.wizards.Messages.SimpleModelWizardDomainModelSelectionPageTitle);
        this.domainModelSelectionPage.setDescription(org.eclipse.gmf.internal.bridge.wizards.Messages.SimpleModelWizardDomainModelSelectionPageDesc);
        this.domainModelSelectionPage.setModelRequired(true);
        this.addPage((IWizardPage)this.domainModelSelectionPage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                EClass domainMetaElement = SimpleMapEditorCreationWizard.this.domainModelSelectionPage.getDiagramElement();
                EPackage domainModel = SimpleMapEditorCreationWizard.this.domainModelSelectionPage.getContents();
                SimpleMapEditorCreationWizard.this.diagram = SimpleMapEditorDiagramEditorUtil.createDiagram(SimpleMapEditorCreationWizard.this.diagramModelFilePage.getURI(), domainMetaElement, domainModel, monitor);
                if (SimpleMapEditorCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && SimpleMapEditorCreationWizard.this.diagram != null) {
                    try {
                        SimpleMapEditorDiagramEditorUtil.openDiagram(SimpleMapEditorCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)SimpleMapEditorCreationWizard.this.getContainer().getShell(), (String)Messages.SimplemapCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.SimplemapCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                SimplemapDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

