/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.Splash;
import net.sourceforge.plantuml.dot.GraphvizUtils;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.stats.StatsUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;

public class PlantUmlTask
extends Task {
    private String dir = null;
    private final Option option = new Option();
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private List<FileList> filelists = new ArrayList<FileList>();
    private AtomicInteger nbFiles = new AtomicInteger(0);
    private ExecutorService executorService;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addFilelist(FileList list) {
        this.filelists.add(list);
    }

    public void execute() throws BuildException {
        if (this.option.isSplash()) {
            Splash.createSplash();
        }
        this.log("Starting PlantUML");
        try {
            File error;
            if (this.dir != null) {
                Iterator<FileList> error2 = this.processingSingleDirectory(new File(this.dir));
                this.eventuallyFailfast((File)((Object)error2));
            }
            for (FileSet fileSet : this.filesets) {
                error = this.manageFileSet(fileSet);
                this.eventuallyFailfast(error);
            }
            for (FileList fileList : this.filelists) {
                error = this.manageFileList(fileList);
                this.eventuallyFailfast(error);
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
                this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                if (this.option.isSplash()) {
                    Splash.disposeSplash();
                }
            }
            this.log("Nb images generated: " + this.nbFiles.get());
        }
        catch (IOException e) {
            Logme.error(e);
            throw new BuildException(e.toString());
        }
        catch (InterruptedException e) {
            Logme.error(e);
            throw new BuildException(e.toString());
        }
    }

    private void eventuallyFailfast(File error) throws IOException {
        if (error != null && this.option.isFailfastOrFailfast2()) {
            this.log("Error in file " + error.getCanonicalPath());
            throw new BuildException("Error in file " + error.getCanonicalPath());
        }
    }

    private File manageFileList(FileList fl) throws IOException, InterruptedException {
        String[] srcFiles;
        File fromDir = fl.getDir(this.getProject());
        for (String src : srcFiles = fl.getFiles(this.getProject())) {
            File f = new File(fromDir, src);
            boolean error = this.processingSingleFile(f);
            if (!error) continue;
            return f;
        }
        return null;
    }

    private File manageFileSet(FileSet fs) throws IOException, InterruptedException {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        File fromDir = fs.getDir(this.getProject());
        String[] srcFiles = ds.getIncludedFiles();
        String[] srcDirs = ds.getIncludedDirectories();
        for (String src : srcFiles) {
            File f = new File(fromDir, src);
            boolean error = this.processingSingleFile(f);
            if (!error) continue;
            return f;
        }
        for (String src : srcDirs) {
            File dir = new File(fromDir, src);
            File errorFile = this.processingSingleDirectory(dir);
            if (errorFile == null) continue;
            return errorFile;
        }
        return null;
    }

    private boolean processingSingleFile(final File f) throws IOException, InterruptedException {
        if (OptionFlags.getInstance().isVerbose()) {
            this.log("Processing " + f.getAbsolutePath());
        }
        final SourceFileReader sourceFileReader = new SourceFileReader(Defines.createWithFileName(f), f, this.option.getOutputDir(), this.option.getConfig(), this.option.getCharset(), this.option.getFileFormatOption());
        if (this.option.isCheckOnly()) {
            return sourceFileReader.hasError();
        }
        if (this.executorService == null) {
            return this.doFile(f, sourceFileReader);
        }
        Splash.incTotal(1);
        this.executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return PlantUmlTask.this.doFile(f, sourceFileReader);
            }
        });
        return false;
    }

    private boolean doFile(File f, SourceFileReader sourceFileReader) throws IOException, InterruptedException {
        List<GeneratedImage> result = sourceFileReader.getGeneratedImages();
        boolean error = false;
        for (GeneratedImage g : result) {
            if (OptionFlags.getInstance().isVerbose()) {
                this.myLog(g + " " + g.getDescription());
            }
            this.nbFiles.addAndGet(1);
            if (g.lineErrorRaw() == -1) continue;
            error = true;
        }
        Splash.incDone(error);
        if (error) {
            this.myLog("Error: " + f.getCanonicalPath());
        }
        return error && this.option.isFailfastOrFailfast2();
    }

    private synchronized void myLog(String s) {
        this.log(s);
    }

    private File processingSingleDirectory(File dir) throws IOException, InterruptedException {
        if (!dir.exists()) {
            String s = "The file " + dir.getAbsolutePath() + " does not exists.";
            this.log(s);
            throw new BuildException(s);
        }
        if (dir.listFiles() != null) {
            for (File f : dir.listFiles()) {
                boolean error;
                if (!f.isFile() || !this.fileToProcess(f.getName()) || !(error = this.processingSingleFile(f))) continue;
                return f;
            }
        }
        return null;
    }

    private boolean fileToProcess(String name) {
        return name.matches(Option.getPattern());
    }

    public void setDir(String s) {
        this.dir = s;
    }

    public void setOutput(String s) {
        this.option.setOutputDir(new File(s));
    }

    public void setCharset(String s) {
        this.option.setCharset(s);
    }

    public void setConfig(String s) {
        try {
            this.option.initConfig(s);
        }
        catch (IOException e) {
            this.log("Error reading " + s);
        }
    }

    public void setKeepTmpFiles(String s) {
    }

    public void setDebugSvek(String s) {
        if ("true".equalsIgnoreCase(s)) {
            this.option.setDebugSvek(true);
        }
    }

    public void setVerbose(String s) {
        if ("true".equalsIgnoreCase(s)) {
            OptionFlags.getInstance().setVerbose(true);
        }
    }

    public void setFormat(String s) {
        if ("scxml".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.SCXML));
        }
        if ("xmi".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_STANDARD));
        }
        if ("xmi:argo".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_ARGO));
        }
        if ("xmi:start".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_STAR));
        }
        if ("eps".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.EPS));
        }
        if ("braille".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.BRAILLE_PNG));
        }
        if ("pdf".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.PDF));
        }
        if ("latex".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.LATEX));
        }
        if ("latex:nopreamble".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.LATEX_NO_PREAMBLE));
        }
        if ("eps:text".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.EPS_TEXT));
        }
        if ("svg".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.SVG));
        }
        if ("txt".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.ATXT));
        }
        if ("utxt".equalsIgnoreCase(s)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.UTXT));
        }
    }

    public void setGraphvizDot(String s) {
        GraphvizUtils.setDotExecutable(s);
    }

    public void setNbThread(String s) {
        int nbThreads;
        if (s != null && s.matches("\\d+")) {
            this.option.setNbThreads(Integer.parseInt(s));
            nbThreads = this.option.getNbThreads();
            this.executorService = Executors.newFixedThreadPool(nbThreads);
        }
        if ("auto".equalsIgnoreCase(s)) {
            this.option.setNbThreads(Option.defaultNbThreads());
            nbThreads = this.option.getNbThreads();
            this.executorService = Executors.newFixedThreadPool(nbThreads);
        }
    }

    public void setNbThreads(String s) {
        this.setNbThread(s);
    }

    public void setFailFast(String s) {
        boolean flag2 = "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s);
        this.option.setFailfast(flag2);
    }

    public void setFailFast2(String s) {
        boolean flag2 = "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s);
        this.option.setFailfast2(flag2);
    }

    public void setCheckOnly(String s) {
        boolean flag2 = "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s);
        this.option.setCheckOnly(flag2);
    }

    public void setOverwrite(String s) {
        boolean flag2 = "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s);
        OptionFlags.getInstance().setOverwrite(flag2);
    }

    public void setFileSeparator(String s) {
        OptionFlags.getInstance().setFileSeparator(s);
    }

    public void setHtmlStats(String s) {
        boolean flag2 = "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s);
        StatsUtils.setHtmlStats(flag2);
    }

    public void setXmlStats(String s) {
        boolean flag2 = "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s);
        StatsUtils.setXmlStats(flag2);
    }

    public void setRealTimeStats(String s) {
        boolean flag2 = "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s);
        StatsUtils.setRealTimeStats(flag2);
    }

    public void setEnableStats(String s) {
        boolean flag2 = "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s);
        OptionFlags.getInstance().setEnableStats(flag2);
    }

    public void setSplash(String s) {
        boolean flag2 = "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s);
        this.option.setSplash(flag2);
    }
}

