/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.TextConstruct;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.html.HtmlToText;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;

public class HtmlTextConstruct
extends TextConstruct {
    protected String html;

    public HtmlTextConstruct() {
    }

    public HtmlTextConstruct(String html) {
        this.html = html;
    }

    public HtmlTextConstruct(String html, String lang) {
        this.html = html;
        this.lang = lang;
    }

    public int getType() {
        return 2;
    }

    public boolean isEmpty() {
        return this.getHtml() == null;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String v) {
        this.html = v;
    }

    public String getPlainText() {
        return !this.isEmpty() ? HtmlToText.htmlToPlainText(this.html) : null;
    }

    public void generateAtom(XmlWriter w, String elementName) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(2);
        attrs.add(new XmlWriter.Attribute("type", "html"));
        if (this.lang != null) {
            attrs.add(new XmlWriter.Attribute("xml:lang", this.lang));
        }
        w.simpleElement(Namespaces.atomNs, elementName, attrs, this.html);
    }

    public void generateRss(XmlWriter w, String elementName, TextConstruct.RssFormat rssFormat) throws IOException {
        switch (rssFormat) {
            case FULL_HTML: {
                w.simpleElement(Namespaces.rssNs, elementName, null, this.html);
                break;
            }
            case PLAIN_TEXT: {
                w.simpleElement(Namespaces.rssNs, elementName, null, this.getPlainText());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public class AtomHandler
    extends XmlParser.ElementHandler {
        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            if (!namespace.equals("") || !localName.equals("type")) {
                super.processAttribute(namespace, localName, value);
            }
        }

        public void processEndElement() throws ParseException {
            if (this.value == null) {
                this.value = "";
            }
            HtmlTextConstruct.this.html = this.value;
            HtmlTextConstruct.this.lang = this.xmlLang;
        }
    }
}

