/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.filesdiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.filesdiagram.FilesType;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Sheet;
import net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.image.Opale;

public class FEntry
implements Iterable<FEntry> {
    private final ISkinParam skinParam;
    private final List<String> note;
    private final String name;
    private FilesType type;
    private List<FEntry> children = new ArrayList<FEntry>();

    public static FEntry createRoot(ISkinParam skinParam) {
        return new FEntry(null, "", FilesType.FOLDER, skinParam);
    }

    private FEntry(List<String> note, String name, FilesType type, ISkinParam skinParam) {
        this.note = note;
        this.name = name;
        this.type = type;
        this.skinParam = skinParam;
    }

    public void addRawEntry(String raw, ISkinParam skinParam) {
        int x = raw.indexOf(47);
        if (x == -1) {
            FEntry result = new FEntry(null, raw, FilesType.DATA, skinParam);
            this.children.add(result);
            return;
        }
        FEntry folder = this.getOrCreateFolder(raw.substring(0, x), skinParam);
        String remain = raw.substring(x + 1);
        if (remain.length() != 0) {
            folder.addRawEntry(remain, skinParam);
        }
    }

    public void addNote(List<String> note, ISkinParam skinParam) {
        FEntry result = new FEntry(note, "NONE", FilesType.NOTE, skinParam);
        this.children.add(result);
    }

    private FEntry getOrCreateFolder(String folderName, ISkinParam skinParam) {
        for (FEntry child : this.children) {
            if (child.type != FilesType.FOLDER || !child.getName().equals(folderName)) continue;
            return child;
        }
        FEntry result = new FEntry(null, folderName, FilesType.FOLDER, skinParam);
        this.children.add(result);
        return result;
    }

    @Override
    public Iterator<FEntry> iterator() {
        return Collections.unmodifiableCollection(this.children).iterator();
    }

    public String getName() {
        return this.name;
    }

    public String getEmoticon() {
        if (this.type == FilesType.FOLDER) {
            return "<:1f4c2:>";
        }
        return "<:1f4c4:>";
    }

    public UGraphic drawAndMove(UGraphic ug, FontConfiguration fontConfiguration, ISkinParam skinParam, double deltax) {
        TextBlock result = this.getTextBlock(fontConfiguration, skinParam);
        result.drawU(ug.apply(UTranslate.dx(deltax)));
        ug = ug.apply(UTranslate.dy(result.calculateDimension(ug.getStringBounder()).getHeight() + 2.0));
        for (FEntry child : this.children) {
            ug = child.drawAndMove(ug, fontConfiguration, skinParam, deltax + 21.0);
        }
        return ug;
    }

    private TextBlock getTextBlock(FontConfiguration fontConfiguration, ISkinParam skinParam) {
        if (this.type == FilesType.NOTE) {
            return this.createOpale();
        }
        Display display = Display.getWithNewlines(this.getEmoticon() + this.getName());
        TextBlock result = display.create(fontConfiguration, HorizontalAlignment.LEFT, skinParam);
        return result;
    }

    private Opale createOpale() {
        StyleSignatureBasic signature = StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.note);
        Style style = signature.getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        FontConfiguration fc = FontConfiguration.create(this.skinParam, style);
        double shadowing = style.value(PName.Shadowing).asDouble();
        HColor borderColor = style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        UStroke stroke = style.getStroke();
        Sheet sheet = this.skinParam.sheet(fc, this.skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), CreoleMode.FULL).createSheet(Display.create(this.note));
        SheetBlock1 sheet1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, this.skinParam.getPadding());
        Opale opale = new Opale(shadowing, borderColor, noteBackgroundColor, sheet1, false, stroke);
        return opale;
    }
}

