/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.utils.Log;

public class FileSystem {
    private static final FileSystem singleton = new FileSystem();
    private ThreadLocal<String> currentDir = new ThreadLocal();

    private FileSystem() {
        this.reset();
    }

    public static FileSystem getInstance() {
        return singleton;
    }

    public void setCurrentDir(SFile dir) {
        if (dir == null) {
            this.currentDir.set(null);
        } else {
            Log.info("Setting current dir: " + dir.getAbsolutePath());
            this.currentDir.set(dir.getAbsolutePath());
        }
    }

    public SFile getCurrentDir() {
        String path = this.currentDir.get();
        if (path != null) {
            return new SFile(path);
        }
        return null;
    }

    public SFile getFile(String nameOrPath) throws IOException {
        SFile file;
        if (this.isAbsolute(nameOrPath)) {
            SFile result = new SFile(nameOrPath);
            Log.info("Trying " + result.getAbsolutePath());
            return result.getCanonicalFile();
        }
        SFile dir = this.getCurrentDir();
        SFile filecurrent = null;
        if (dir != null) {
            filecurrent = dir.getAbsoluteFile().file(nameOrPath);
            Log.info("Current dir is " + dir.getAbsolutePath() + " so trying " + filecurrent.getAbsolutePath());
            if (filecurrent.exists()) {
                return filecurrent.getCanonicalFile();
            }
        }
        for (SFile d : SecurityUtils.getPath("plantuml.include.path")) {
            assert (d.isDirectory());
            file = d.file(nameOrPath);
            if (!file.exists()) continue;
            return file.getCanonicalFile();
        }
        for (SFile d : SecurityUtils.getPath("java.class.path")) {
            assert (d.isDirectory());
            file = d.file(nameOrPath);
            if (!file.exists()) continue;
            return file.getCanonicalFile();
        }
        if (dir == null) {
            assert (filecurrent == null);
            return new SFile(nameOrPath).getCanonicalFile();
        }
        assert (filecurrent != null);
        return filecurrent;
    }

    private boolean isAbsolute(String nameOrPath) {
        SFile f = new SFile(nameOrPath);
        return f.isAbsolute();
    }

    public void reset() {
        this.setCurrentDir(new SFile("."));
    }
}

