/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IconType implements Enumerator
{
    DEFAULT(0, "default", "default"),
    DISABLED(1, "disabled", "disabled"),
    ROLLOVER(2, "rollover", "rollover"),
    SELECTED(3, "selected", "selected"),
    SHORTCUT(4, "shortcut", "shortcut");

    public static final int DEFAULT_VALUE = 0;
    public static final int DISABLED_VALUE = 1;
    public static final int ROLLOVER_VALUE = 2;
    public static final int SELECTED_VALUE = 3;
    public static final int SHORTCUT_VALUE = 4;
    private static final IconType[] VALUES_ARRAY;
    public static final List<IconType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IconType[]{DEFAULT, DISABLED, ROLLOVER, SELECTED, SHORTCUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IconType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IconType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IconType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IconType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IconType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return DISABLED;
            }
            case 2: {
                return ROLLOVER;
            }
            case 3: {
                return SELECTED;
            }
            case 4: {
                return SHORTCUT;
            }
        }
        return null;
    }

    private IconType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

