/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.container.customClassloader;

import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.Extension;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.tests.se.container.customClassloader.Alpha;
import org.jboss.cdi.tck.tests.se.container.customClassloader.AlphaExtension;
import org.jboss.cdi.tck.tests.se.container.customClassloader.Bravo;
import org.jboss.cdi.tck.tests.se.container.customClassloader.BravoExtension;
import org.jboss.cdi.tck.tests.se.container.customClassloader.MyExtension;
import org.jboss.cdi.tck.tests.se.container.customClassloader.ProcessedByExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="2.0")
public class CustomClassLoaderSETest
extends Arquillian {
    @Deployment
    public static Archive<?> deployment() throws IOException {
        JavaArchive bda1 = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage(CustomClassLoaderSETest.class.getPackage())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsServiceProvider(Extension.class, new Class[]{AlphaExtension.class, BravoExtension.class})).addAsServiceProvider(MyExtension.class, new Class[]{AlphaExtension.class});
        return ClassPath.builder().add(bda1).build();
    }

    @Test
    @SpecAssertion(section="se_bootstrap", id="dn")
    public void testCustomClassLoader() throws IOException {
        URLClassLoader classLoader = new URLClassLoader(new URL[0], Alpha.class.getClassLoader()){

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                if ("META-INF/services/jakarta.enterprise.inject.spi.Extension".equals(name)) {
                    return super.getResources("META-INF/services/" + MyExtension.class.getName());
                }
                return super.getResources(name);
            }
        };
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer container = seContainerInitializer.setClassLoader((ClassLoader)classLoader).initialize();){
            ((Alpha)container.select(Alpha.class, new Annotation[]{ProcessedByExtension.ProcessedByExtensionLiteral.INSTANCE}).get()).ping();
            Assert.assertTrue((boolean)container.select(Bravo.class, new Annotation[]{ProcessedByExtension.ProcessedByExtensionLiteral.INSTANCE}).isUnsatisfied());
        }
    }
}

