/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.manager;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.manager.FishFarmOffice;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class ManagerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ManagerTest.class)).build();
    }

    @Test
    @SpecAssertion(section="beanmanager", id="c")
    public void testInjectingManager() {
        FishFarmOffice fishFarmOffice = this.getContextualReference(FishFarmOffice.class, new Annotation[0]);
        assert (fishFarmOffice.beanManager != null);
    }

    @Test
    @SpecAssertion(section="beanmanager", id="aa")
    public void testContainerProvidesManagerBean() {
        assert (this.getBeans(BeanManager.class, new Annotation[0]).size() > 0);
    }

    @Test
    @SpecAssertion(section="beanmanager", id="ab")
    public void testManagerBeanIsDependentScoped() {
        Bean<BeanManager> beanManager = this.getBeans(BeanManager.class, new Annotation[0]).iterator().next();
        assert (beanManager.getScope().equals(Dependent.class));
    }

    @Test
    @SpecAssertion(section="beanmanager", id="ac")
    public void testManagerBeanHasCurrentBinding() {
        Bean<BeanManager> beanManager = this.getBeans(BeanManager.class, new Annotation[0]).iterator().next();
        assert (beanManager.getQualifiers().contains(Default.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="beanmanager", id="b")
    public void testManagerBeanIsPassivationCapable() {
        assert (this.isSerializable(this.getCurrentManager().getClass()));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_contextual_reference", id="a"), @SpecAssertion(section="bm_obtain_contextual_reference", id="b")})
    public void testGetReferenceReturnsContextualInstance() {
        Bean<FishFarmOffice> bean = this.getBeans(FishFarmOffice.class, new Annotation[0]).iterator().next();
        assert (this.getCurrentManager().getReference(bean, FishFarmOffice.class, this.getCurrentManager().createCreationalContext(bean)) instanceof FishFarmOffice);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_obtain_contextual_reference", id="c")
    public void testGetReferenceWithIllegalBeanType() {
        Bean<FishFarmOffice> bean = this.getBeans(FishFarmOffice.class, new Annotation[0]).iterator().next();
        this.getCurrentManager().getReference(bean, BigDecimal.class, this.getCurrentManager().createCreationalContext(bean));
    }

    private boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }
}

