/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.diffmerge.bridge.util.structures.Tuple2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static boolean areEqual(Object o1_p, Object o2_p) {
        return o1_p == null && o2_p == null || o1_p != null && o1_p.equals(o2_p);
    }

    public static <T> List<T> constantList(T ... elements_p) {
        return Collections.unmodifiableList(Arrays.asList(elements_p));
    }

    public static <K, V> Map<K, V> constantMap(Tuple2<? extends K, ? extends V> ... couples_p) {
        LinkedHashMap result = new LinkedHashMap();
        Tuple2<? extends K, ? extends V>[] tuple2Array = couples_p;
        int n = couples_p.length;
        int n2 = 0;
        while (n2 < n) {
            Tuple2<K, V> couple = tuple2Array[n2];
            if (couple == null) {
                throw new IllegalArgumentException("Null couple in constant map declaration");
            }
            V former = result.put(couple.get1(), couple.get2());
            if (former != null) {
                throw new IllegalArgumentException("Duplicate key in constant map declaration: " + couple.get1());
            }
            ++n2;
        }
        return Collections.unmodifiableMap(result);
    }

    public static <T> Set<T> constantSet(T ... elements_p) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(Arrays.asList(elements_p));
        result.remove(null);
        return Collections.unmodifiableSet(result);
    }

    public static <T> Iterator<T> emptyIterator() {
        return EmptyIterator.INSTANCE;
    }

    public static <T> Iterator<T> singletonIterator(T object_p) {
        return Collections.singleton(object_p).iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyIterator
    implements Iterator<Object> {
        public static final EmptyIterator INSTANCE = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new IllegalArgumentException("Empty iterator");
        }

        @Override
        public void remove() {
            throw new IllegalArgumentException("Empty iterator");
        }
    }
}

