/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tinkerpop.gremlin.structure.util;

import org.apache.tinkerpop.gremlin.structure.Transaction;

/**
 * An exception thrown by providers when calls to {@link AbstractTransaction#doCommit} or
 * {@link AbstractTransaction#doRollback} fail. This exception will be propagated to users on calls to
 * {@link Transaction#commit()} or {@link Transaction#rollback()}.
 *
 * @author Stephen Mallette (http://stephen.genoprime.com)
 */
public class TransactionException extends RuntimeException {
    public TransactionException(final String message) {
        super(message);
    }

    public TransactionException(final Throwable cause) {
        super(cause);
    }

    public TransactionException(final String message, final Throwable cause) {
        super(message, cause);
    }
}
