/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.TensorIndexes;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.CharArray;
import org.apache.sysds.runtime.frame.data.columns.HashLongArray;
import org.apache.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.meta.TensorCharacteristics;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderRecode;
import org.apache.sysds.runtime.util.IndexRange;

public class UtilFunctions {
    public static final double DOUBLE_EPS = Math.pow(2.0, -53.0);
    public static final long ADD_PRIME1 = 99991L;
    public static final int DIVIDE_PRIME = 1405695061;
    private static final Map<String, String> DATE_FORMATS = new HashMap<String, String>(){
        private static final long serialVersionUID = 6826162458614520846L;
        {
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$", "yyyy-MM-dd HH:mm:ss");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd-MM-yyyy HH:mm:ss");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "MM/dd/yyyy HH:mm:ss");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$", "yyyy/MM/dd HH:mm:ss");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd MMM yyyy HH:mm:ss");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd MMMM yyyy HH:mm:ss");
            this.put("^\\d{8}$", "yyyyMMdd");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}$", "dd-MM-yyyy");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}$", "yyyy-MM-dd");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}$", "MM/dd/yyyy");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}$", "yyyy/MM/dd");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}$", "dd MMM yyyy");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}$", "dd MMMM yyyy");
            this.put("^\\d{12}$", "yyyyMMddHHmm");
            this.put("^\\d{8}\\s\\d{4}$", "yyyyMMdd HHmm");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}$", "dd-MM-yyyy HH:mm");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}$", "yyyy-MM-dd HH:mm");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}$", "MM/dd/yyyy HH:mm");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}$", "yyyy/MM/dd HH:mm");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}$", "dd MMM yyyy HH:mm");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}$", "dd MMMM yyyy HH:mm");
            this.put("^\\d{14}$", "yyyyMMddHHmmss");
            this.put("^\\d{8}\\s\\d{6}$", "yyyyMMdd HHmmss");
        }
    };

    public static int intHashCode(int key1, int key2) {
        return 31 * (31 + key1) + key2;
    }

    public static int intHashCodeRobust(int key1, int key2) {
        long tmp = 31L * (31L + (long)key1) + (long)key2;
        return tmp < Integer.MAX_VALUE ? (int)tmp : UtilFunctions.longHashCode(tmp);
    }

    public static int longHashCode(long key1) {
        return (int)(key1 ^ key1 >>> 32);
    }

    public static int longHashCode(long key1, long key2) {
        int h = 31 + (int)(key1 ^ key1 >>> 32);
        return h * 31 + (int)(key2 ^ key2 >>> 32);
    }

    public static int longHashCode(long key1, long key2, long key3) {
        int h1 = 31 + (int)(key1 ^ key1 >>> 32);
        int h2 = h1 * 31 + (int)(key2 ^ key2 >>> 32);
        return h2 * 31 + (int)(key3 ^ key3 >>> 32);
    }

    public static int nextIntPow2(int in) {
        int expon = in == 0 ? 0 : 32 - Integer.numberOfLeadingZeros(in - 1);
        long pow2 = UtilFunctions.pow(2, expon);
        return (int)(pow2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : pow2);
    }

    public static long pow(int base, int exp) {
        return base == 2 && 0 <= exp && exp < 63 ? 1L << exp : (long)Math.pow(base, exp);
    }

    public static long computeBlockIndex(long cellIndex, int blockSize) {
        return (cellIndex - 1L) / (long)blockSize + 1L;
    }

    public static int computeCellInBlock(long cellIndex, int blockSize) {
        return (int)((cellIndex - 1L) % (long)blockSize);
    }

    public static long computeCellIndex(long blockIndex, int blockSize, int cellInBlock) {
        return (blockIndex - 1L) * (long)blockSize + 1L + (long)cellInBlock;
    }

    public static int computeBlockSize(long len, long blockIndex, long blockSize) {
        long remain = len - (blockIndex - 1L) * blockSize;
        return (int)Math.min(blockSize, remain);
    }

    public static long[] computeNextTensorIndexes(TensorCharacteristics tc, long[] ix) {
        int n = tc.getNumDims() - 1;
        ix[n] = ix[n] + 1L;
        for (int i = tc.getNumDims() - 1; i > 0 && ix[i] == tc.getNumBlocks(i) + 1L; --i) {
            ix[i] = 1L;
            int n2 = i - 1;
            ix[n2] = ix[n2] + 1L;
        }
        return ix;
    }

    public static long[] computeTensorIndexes(TensorCharacteristics tc, long blockIndex) {
        long[] ix = new long[tc.getNumDims()];
        for (int j = tc.getNumDims() - 1; j >= 0; --j) {
            ix[j] = 1L + blockIndex % tc.getNumBlocks(j);
            blockIndex /= tc.getNumBlocks(j);
        }
        return ix;
    }

    public static void computeSliceInfo(TensorCharacteristics tc, long[] blockIx, int[] outDims, int[] offset) {
        for (int i = tc.getNumDims() - 1; i >= 0; --i) {
            outDims[i] = UtilFunctions.computeBlockSize(tc.getDim(i), blockIx[i], tc.getBlocksize());
            offset[i] = (int)((blockIx[i] - 1L) * (long)tc.getBlocksize());
        }
    }

    public static long computeBlockNumber(int[] ix, long[] dims, int blen) {
        long pos = ix[ix.length - 1] - 1;
        for (int i = ix.length - 2; i >= 0; --i) {
            pos = (long)((double)pos + (double)(ix[i] - 1) * Math.ceil((double)dims[i + 1] / (double)blen));
        }
        return pos;
    }

    public static ArrayList<Integer> getBalancedBlockSizesDefault(int len, int k, boolean constK) {
        int nk = constK ? k : UtilFunctions.roundToNext(Math.min(8 * k, len / 32), k);
        return UtilFunctions.getBalancedBlockSizes(len, nk);
    }

    public static ArrayList<Integer> getAlignedBlockSizes(int len, int k, int align) {
        int blklen;
        ArrayList<Integer> ret = new ArrayList<Integer>(len / (blklen += (blklen = (int)Math.ceil((double)len / (double)k)) % align != 0 ? align - blklen % align : 0));
        for (int i = 0; i < len; i += blklen) {
            ret.add(Math.min(blklen, len - i));
        }
        return ret;
    }

    private static ArrayList<Integer> getBalancedBlockSizes(int len, int k) {
        ArrayList<Integer> ret = new ArrayList<Integer>(k);
        int base = len / k;
        int rest = len % k;
        for (int i = 0; i < k; ++i) {
            int val = base + (i < rest ? 1 : 0);
            if (val <= 0) continue;
            ret.add(val);
        }
        return ret;
    }

    public static boolean isInBlockRange(MatrixIndexes ix, int blen, long rl, long ru, long cl, long cu) {
        long bRLowerIndex = (ix.getRowIndex() - 1L) * (long)blen + 1L;
        long bRUpperIndex = ix.getRowIndex() * (long)blen;
        long bCLowerIndex = (ix.getColumnIndex() - 1L) * (long)blen + 1L;
        long bCUpperIndex = ix.getColumnIndex() * (long)blen;
        if (rl > bRUpperIndex || ru < bRLowerIndex) {
            return false;
        }
        return cl <= bCUpperIndex && cu >= bCLowerIndex;
    }

    public static boolean isInFrameBlockRange(Long ix, int blen, long rl, long ru) {
        return rl <= ix + (long)blen - 1L && ru >= ix;
    }

    public static boolean isInBlockRange(MatrixIndexes ix, int blen, IndexRange ixrange) {
        return UtilFunctions.isInBlockRange(ix, blen, ixrange.rowStart, ixrange.rowEnd, ixrange.colStart, ixrange.colEnd);
    }

    public static boolean isInFrameBlockRange(Long ix, int blen, IndexRange ixrange) {
        return UtilFunctions.isInFrameBlockRange(ix, blen, ixrange.rowStart, ixrange.rowEnd);
    }

    public static IndexRange getSelectedRangeForZeroOut(IndexedMatrixValue in, int blen, IndexRange indexRange) {
        IndexRange tempRange = new IndexRange(-1L, -1L, -1L, -1L);
        long topBlockRowIndex = UtilFunctions.computeBlockIndex(indexRange.rowStart, blen);
        int topRowInTopBlock = UtilFunctions.computeCellInBlock(indexRange.rowStart, blen);
        long bottomBlockRowIndex = UtilFunctions.computeBlockIndex(indexRange.rowEnd, blen);
        int bottomRowInBottomBlock = UtilFunctions.computeCellInBlock(indexRange.rowEnd, blen);
        long leftBlockColIndex = UtilFunctions.computeBlockIndex(indexRange.colStart, blen);
        int leftColInLeftBlock = UtilFunctions.computeCellInBlock(indexRange.colStart, blen);
        long rightBlockColIndex = UtilFunctions.computeBlockIndex(indexRange.colEnd, blen);
        int rightColInRightBlock = UtilFunctions.computeCellInBlock(indexRange.colEnd, blen);
        if (in.getIndexes().getRowIndex() < topBlockRowIndex || in.getIndexes().getRowIndex() > bottomBlockRowIndex || in.getIndexes().getColumnIndex() < leftBlockColIndex || in.getIndexes().getColumnIndex() > rightBlockColIndex) {
            tempRange.set(-1L, -1L, -1L, -1L);
            return tempRange;
        }
        tempRange.set(0L, in.getValue().getNumRows() - 1, 0L, in.getValue().getNumColumns() - 1);
        if (topBlockRowIndex == in.getIndexes().getRowIndex()) {
            tempRange.rowStart = topRowInTopBlock;
        }
        if (bottomBlockRowIndex == in.getIndexes().getRowIndex()) {
            tempRange.rowEnd = bottomRowInBottomBlock;
        }
        if (leftBlockColIndex == in.getIndexes().getColumnIndex()) {
            tempRange.colStart = leftColInLeftBlock;
        }
        if (rightBlockColIndex == in.getIndexes().getColumnIndex()) {
            tempRange.colEnd = rightColInRightBlock;
        }
        return tempRange;
    }

    public static IndexRange getSelectedRangeForZeroOut(Pair<Long, FrameBlock> in, int blen, IndexRange indexRange, long lSrcRowIndex, long lDestRowIndex) {
        int iRowStart = indexRange.rowStart <= lDestRowIndex ? 0 : (int)(indexRange.rowStart - in.getKey());
        int iRowEnd = (int)Math.min(indexRange.rowEnd - lSrcRowIndex, (long)blen) - 1;
        int iColStart = UtilFunctions.computeCellInBlock(indexRange.colStart, blen);
        int iColEnd = UtilFunctions.computeCellInBlock(indexRange.colEnd, blen);
        return new IndexRange(iRowStart, iRowEnd, iColStart, iColEnd);
    }

    public static double parseToDouble(String str, Set<String> isNan) {
        return isNan != null && isNan.contains(str) ? Double.NaN : Double.parseDouble(str);
    }

    public static int parseToInt(String str) {
        int ret = -1;
        ret = str.contains(".") ? UtilFunctions.toInt(Double.parseDouble(str)) : Integer.parseInt(str);
        return ret;
    }

    public static long parseToLong(String str) {
        long ret = -1L;
        ret = str.contains(".") ? UtilFunctions.toLong(Double.parseDouble(str)) : Long.parseLong(str);
        return ret;
    }

    public static int toInt(double val) {
        return (int)(Math.signum(val) * Math.floor(Math.abs(val) + DOUBLE_EPS));
    }

    public static long toLong(double val) {
        return (long)(Math.signum(val) * Math.floor(Math.abs(val) + DOUBLE_EPS));
    }

    public static int toInt(Object obj) {
        return obj instanceof Long ? ((Long)obj).intValue() : ((Integer)obj).intValue();
    }

    public static long getSeqLength(double from, double to, double incr) {
        return UtilFunctions.getSeqLength(from, to, incr, true);
    }

    public static long getSeqLength(double from, double to, double incr, boolean check) {
        if (UtilFunctions.isSpecial(from) || UtilFunctions.isSpecial(to) || UtilFunctions.isSpecial(incr) || from > to && incr > 0.0 || from < to && incr < 0.0) {
            if (check) {
                throw new RuntimeException("Invalid seq parameters: (" + from + ", " + to + ", " + incr + ")");
            }
            return 0L;
        }
        return 1L + (long)Math.floor(to / incr - from / incr);
    }

    public static List<Integer> getSeqList(int low, int up, int incr) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = low; i <= up; i += incr) {
            ret.add(i);
        }
        return ret;
    }

    public static int[] getSeqArray(int low, int up, int incr) {
        int len = (int)UtilFunctions.getSeqLength(low, up, incr);
        int[] ret = new int[len];
        int i = 0;
        int val = low;
        while (i < len) {
            ret[i] = val;
            ++i;
            val += incr;
        }
        return ret;
    }

    public static int roundToNext(int val, int factor) {
        int pval = Math.max(val, factor);
        return (pval + factor - 1) / factor * factor;
    }

    public static Object doubleToObject(Types.ValueType vt, double in) {
        return UtilFunctions.doubleToObject(vt, in, true);
    }

    public static Object doubleToObject(Types.ValueType vt, double in, boolean sparse) {
        if (Double.isNaN(in) && sparse) {
            return null;
        }
        switch (vt) {
            case STRING: {
                return String.valueOf(in);
            }
            case BOOLEAN: {
                return in != 0.0;
            }
            case INT32: {
                return UtilFunctions.toInt(in);
            }
            case INT64: {
                return UtilFunctions.toLong(in);
            }
            case FP32: {
                return Float.valueOf((float)in);
            }
            case FP64: {
                return in;
            }
        }
        throw new RuntimeException("Unsupported value type: " + vt);
    }

    public static Object stringToObject(Types.ValueType vt, String in) {
        if (in == null || in.isEmpty()) {
            return null;
        }
        switch (vt) {
            case STRING: {
                return in;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(in);
            }
            case INT32: 
            case UINT4: 
            case UINT8: {
                return Integer.parseInt(in);
            }
            case INT64: {
                return Long.parseLong(in);
            }
            case FP64: {
                return Double.parseDouble(in);
            }
            case FP32: {
                return Float.valueOf(Float.parseFloat(in));
            }
            case CHARACTER: {
                return Character.valueOf(CharArray.parseChar(in));
            }
            case HASH64: {
                return HashLongArray.parseHashLong(in);
            }
        }
        throw new RuntimeException("Unsupported value type: " + vt);
    }

    public static double objectToDoubleSafe(Types.ValueType vt, Object in) {
        if (vt == Types.ValueType.STRING && in == null) {
            return 0.0;
        }
        if (vt == Types.ValueType.STRING && !NumberUtils.isCreatable((String)((String)in))) {
            return 1.0;
        }
        return UtilFunctions.objectToDouble(vt, in);
    }

    public static double objectToDouble(Types.ValueType vt, Object in) {
        if (in == null) {
            return Double.NaN;
        }
        switch (vt) {
            case FP64: {
                return (Double)in;
            }
            case FP32: {
                return ((Float)in).floatValue();
            }
            case INT64: {
                return ((Long)in).longValue();
            }
            case INT32: {
                return ((Integer)in).intValue();
            }
            case BOOLEAN: {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            case CHARACTER: {
                return ((Character)in).charValue();
            }
            case STRING: {
                String inStr = (String)in;
                try {
                    return !inStr.isEmpty() ? Double.parseDouble(inStr) : 0.0;
                }
                catch (NumberFormatException e) {
                    int len = inStr.length();
                    if (len == 1 && inStr.equalsIgnoreCase("T")) {
                        return 1.0;
                    }
                    if (len == 1 && inStr.equalsIgnoreCase("F")) {
                        return 0.0;
                    }
                    if (inStr.equalsIgnoreCase("true")) {
                        return 1.0;
                    }
                    if (inStr.equalsIgnoreCase("false")) {
                        return 0.0;
                    }
                    throw new DMLRuntimeException("failed parsing object to double", e);
                }
            }
        }
        throw new DMLRuntimeException("Unsupported value type: " + vt);
    }

    public static float objectToFloat(Types.ValueType vt, Object in) {
        if (in == null) {
            return Float.NaN;
        }
        switch (vt) {
            case FP64: {
                return ((Double)in).floatValue();
            }
            case FP32: {
                return ((Float)in).floatValue();
            }
            case INT64: {
                return ((Long)in).longValue();
            }
            case INT32: {
                return ((Integer)in).intValue();
            }
            case BOOLEAN: {
                return (Boolean)in != false ? 1.0f : 0.0f;
            }
            case STRING: {
                return !((String)in).isEmpty() ? Float.parseFloat((String)in) : 0.0f;
            }
        }
        throw new DMLRuntimeException("Unsupported value type: " + vt);
    }

    public static char objectToCharacter(Types.ValueType vt, Object in) {
        if (in == null) {
            return '\u0000';
        }
        switch (vt) {
            case INT32: 
            case INT64: 
            case FP32: 
            case FP64: {
                return in.toString().charAt(0);
            }
            case BOOLEAN: {
                return (Boolean)in != false ? (char)'1' : '0';
            }
            case STRING: {
                return !((String)in).isEmpty() ? ((String)in).charAt(0) : (char)'\u0000';
            }
        }
        throw new DMLRuntimeException("Unsupported value type: " + vt);
    }

    public static int objectToInteger(Types.ValueType vt, Object in) {
        if (in == null) {
            return 0;
        }
        switch (vt) {
            case FP64: {
                return ((Double)in).intValue();
            }
            case FP32: {
                return ((Float)in).intValue();
            }
            case INT64: {
                return ((Long)in).intValue();
            }
            case INT32: {
                return (Integer)in;
            }
            case BOOLEAN: {
                return (Boolean)in != false ? 1 : 0;
            }
            case STRING: {
                return !((String)in).isEmpty() ? Integer.parseInt((String)in) : 0;
            }
        }
        throw new DMLRuntimeException("Unsupported value type: " + vt);
    }

    public static long objectToLong(Types.ValueType vt, Object in) {
        if (in == null) {
            return 0L;
        }
        switch (vt) {
            case FP64: {
                return ((Double)in).longValue();
            }
            case FP32: {
                return ((Float)in).longValue();
            }
            case INT64: {
                return (Long)in;
            }
            case INT32: {
                return ((Integer)in).intValue();
            }
            case BOOLEAN: {
                return (Boolean)in != false ? 1L : 0L;
            }
            case STRING: {
                return !((String)in).isEmpty() ? Long.parseLong((String)in) : 0L;
            }
        }
        throw new DMLRuntimeException("Unsupported value type: " + vt);
    }

    public static boolean objectToBoolean(Types.ValueType vt, Object in) {
        if (in == null) {
            return false;
        }
        switch (vt) {
            case FP64: {
                return (Double)in == 1.0;
            }
            case FP32: {
                return (double)((Float)in).floatValue() == 1.0;
            }
            case INT64: {
                return (Long)in == 1L;
            }
            case INT32: {
                return (Integer)in == 1;
            }
            case BOOLEAN: {
                return (Boolean)in;
            }
            case STRING: {
                return Boolean.parseBoolean((String)in);
            }
        }
        throw new DMLRuntimeException("Unsupported value type: " + vt);
    }

    public static String objectToString(Object in) {
        return in != null ? in.toString() : null;
    }

    public static String objectToString(Object in, boolean ignoreNull) {
        String strReturn = UtilFunctions.objectToString(in);
        if (strReturn == null) {
            return strReturn;
        }
        if (ignoreNull) {
            if (in instanceof Double && (Double)in == 0.0) {
                return null;
            }
            if (in instanceof Long && (Long)in == 0L) {
                return null;
            }
            if (in instanceof Long && (Integer)in == 0) {
                return null;
            }
            if (in instanceof Boolean && !((Boolean)in).booleanValue()) {
                return null;
            }
            if (in instanceof String && ((String)in).trim().length() == 0) {
                return null;
            }
            return strReturn;
        }
        return strReturn;
    }

    public static Object objectToObject(Types.ValueType vt, Object in) {
        if (in instanceof Double && vt == Types.ValueType.FP64 || in instanceof Float && vt == Types.ValueType.FP32 || in instanceof Long && (vt == Types.ValueType.INT64 || vt == Types.ValueType.HASH64) || in instanceof Integer && vt == Types.ValueType.INT32 || in instanceof Boolean && vt == Types.ValueType.BOOLEAN || in instanceof String && vt == Types.ValueType.STRING) {
            return in;
        }
        return UtilFunctions.stringToObject(vt, UtilFunctions.objectToString(in));
    }

    public static Object objectToObject(Types.ValueType vt, Object in, boolean ignoreNull) {
        String str = UtilFunctions.objectToString(in, ignoreNull);
        if (str == null || vt == Types.ValueType.STRING) {
            return str;
        }
        return UtilFunctions.stringToObject(vt, str);
    }

    public static int compareTo(Types.ValueType vt, Object in1, Object in2) {
        if (in1 == null && in2 == null) {
            return 0;
        }
        if (in1 == null) {
            return -1;
        }
        if (in2 == null) {
            return 1;
        }
        switch (vt) {
            case STRING: {
                return ((String)in1).compareTo((String)in2);
            }
            case BOOLEAN: {
                return ((Boolean)in1).compareTo((Boolean)in2);
            }
            case INT64: {
                return ((Long)in1).compareTo((Long)in2);
            }
            case INT32: {
                return ((Integer)in1).compareTo((Integer)in2);
            }
            case FP64: {
                return ((Double)in1).compareTo((Double)in2);
            }
        }
        throw new RuntimeException("Unsupported value type: " + vt);
    }

    public static int compareVersion(String version1, String version2) {
        String[] partsv1 = version1.split("\\.");
        String[] partsv2 = version2.split("\\.");
        int len = Math.min(partsv1.length, partsv2.length);
        for (int i = 0; i < partsv1.length && i < len; ++i) {
            Integer iv2;
            Integer iv1 = Integer.parseInt(partsv1[i]);
            if (iv1.compareTo(iv2 = Integer.valueOf(Integer.parseInt(partsv2[i]))) == 0) continue;
            return iv1.compareTo(iv2);
        }
        return 0;
    }

    public static boolean isBoolean(String str) {
        return String.valueOf(true).equalsIgnoreCase(str) || String.valueOf(false).equalsIgnoreCase(str);
    }

    public static boolean isIntegerNumber(String str) {
        byte[] c = str.getBytes();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] >= 48 && c[i] <= 57) continue;
            return false;
        }
        return true;
    }

    public static boolean isSpecial(double value) {
        return Double.isNaN(value) || Double.isInfinite(value);
    }

    public static int[] getSortedSampleIndexes(int range, int sampleSize) {
        return UtilFunctions.getSortedSampleIndexes(range, sampleSize, -1L);
    }

    public static int[] getSortedSampleIndexes(int range, int sampleSize, long seed) {
        RandomDataGenerator rng = new RandomDataGenerator();
        if (seed != -1L) {
            rng.reSeed(seed);
        }
        int[] sample = rng.nextPermutation(range, sampleSize);
        Arrays.sort(sample);
        return sample;
    }

    public static byte max(byte[] array) {
        byte ret = -128;
        for (int i = 0; i < array.length; ++i) {
            ret = array[i] > ret ? array[i] : ret;
        }
        return ret;
    }

    public static String unquote(String s) {
        if (s != null && s.length() >= 2 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String quote(String s) {
        return "\"" + s + "\"";
    }

    public static int getAsciiAtIdx(String s, int idx) {
        int strlen = s.length();
        int c = 0;
        int javaIdx = idx - 1;
        if (javaIdx >= 0 && javaIdx < strlen) {
            c = s.charAt(javaIdx);
        }
        return c;
    }

    public static long parseMemorySize(String arg) {
        if (arg.endsWith("g") || arg.endsWith("G")) {
            return Long.parseLong(arg.substring(0, arg.length() - 1)) * 1024L * 1024L * 1024L;
        }
        if (arg.endsWith("m") || arg.endsWith("M")) {
            return Long.parseLong(arg.substring(0, arg.length() - 1)) * 1024L * 1024L;
        }
        if (arg.endsWith("k") || arg.endsWith("K")) {
            return Long.parseLong(arg.substring(0, arg.length() - 1)) * 1024L;
        }
        return Long.parseLong(arg.substring(0, arg.length()));
    }

    public static String formatMemorySize(long arg) {
        if (arg >= 0x40000000L) {
            return String.format("%d GB", arg / 0x40000000L);
        }
        if (arg >= 0x100000L) {
            return String.format("%d MB", arg / 0x100000L);
        }
        if (arg >= 1024L) {
            return String.format("%d KB", arg / 1024L);
        }
        return String.format("%d", arg);
    }

    public static double getDouble(Object obj) {
        return obj instanceof Double ? (Double)obj : Double.parseDouble(obj.toString());
    }

    public static boolean isNonZero(Object obj) {
        if (obj instanceof Double) {
            return (Double)obj != 0.0;
        }
        String sobj = obj.toString();
        return !sobj.equals("0") && !sobj.equals("0.0");
    }

    public static int computeNnz(double[] a, int ai, int len) {
        int lnnz = 0;
        for (int i = ai; i < ai + len; ++i) {
            lnnz += a[i] != 0.0 ? 1 : 0;
        }
        return lnnz;
    }

    public static int computeNnz(float[] a, int ai, int len) {
        int lnnz = 0;
        for (int i = ai; i < ai + len; ++i) {
            lnnz += a[i] != 0.0f ? 1 : 0;
        }
        return lnnz;
    }

    public static int computeNnz(long[] a, int ai, int len) {
        int lnnz = 0;
        for (int i = ai; i < ai + len; ++i) {
            lnnz += a[i] != 0L ? 1 : 0;
        }
        return lnnz;
    }

    public static int computeNnz(int[] a, int ai, int len) {
        int lnnz = 0;
        for (int i = ai; i < ai + len; ++i) {
            lnnz += a[i] != 0 ? 1 : 0;
        }
        return lnnz;
    }

    public static int computeNnz(BitSet a, int ai, int len) {
        int lnnz = 0;
        for (int i = ai; i < ai + len; ++i) {
            lnnz += a.get(i) ? 1 : 0;
        }
        return lnnz;
    }

    public static int computeNnz(String[] a, int ai, int len) {
        int lnnz = 0;
        for (int k = ai; k < ai + len; ++k) {
            lnnz += a[k] != null && !a[k].isEmpty() && Double.parseDouble(a[k]) != 0.0 ? 1 : 0;
        }
        return lnnz;
    }

    public static long computeNnz(SparseBlock a, int[] aix, int ai, int alen) {
        long lnnz = 0L;
        for (int k = ai; k < ai + alen; ++k) {
            lnnz += (long)a.size(aix[k]);
        }
        return lnnz;
    }

    public static Types.ValueType[] nCopies(int n, Types.ValueType vt) {
        Types.ValueType[] ret = new Types.ValueType[n];
        Arrays.fill((Object[])ret, (Object)vt);
        return ret;
    }

    public static int frequency(Types.ValueType[] schema, Types.ValueType vt) {
        int count = 0;
        for (Types.ValueType tmp : schema) {
            count += tmp.equals((Object)vt) ? 1 : 0;
        }
        return count;
    }

    public static Types.ValueType[] copyOf(Types.ValueType[] schema1, Types.ValueType[] schema2) {
        return (Types.ValueType[])ArrayUtils.addAll((Object[])schema1, (Object[])schema2);
    }

    public static int countNonZeros(double[] data, int pos, int len) {
        int ret = 0;
        for (int i = pos; i < pos + len; ++i) {
            ret += data[i] != 0.0 ? 1 : 0;
        }
        return ret;
    }

    public static boolean containsZero(double[] data, int pos, int len) {
        for (int i = pos; i < pos + len; ++i) {
            if (data[i] != 0.0) continue;
            return true;
        }
        return false;
    }

    public static long prod(long[] arr) {
        long ret = 1L;
        for (int i = 0; i < arr.length; ++i) {
            ret *= arr[i];
        }
        return ret;
    }

    public static long prod(int[] arr) {
        long ret = 1L;
        for (int i = 0; i < arr.length; ++i) {
            ret *= (long)arr[i];
        }
        return ret;
    }

    public static long prod(int[] arr, int off) {
        long ret = 1L;
        for (int i = off; i < arr.length; ++i) {
            ret *= (long)arr[i];
        }
        return ret;
    }

    public static void getBlockBounds(TensorIndexes ix, long[] dims, int blen, int[] lower, int[] upper) {
        int i;
        for (i = 0; i < dims.length; ++i) {
            lower[i] = (int)(ix.getIndex(i) - 1L) * blen;
            upper[i] = (int)((long)lower[i] + dims[i] - 1L);
        }
        int n = upper.length - 1;
        upper[n] = upper[n] + 1;
        for (i = upper.length - 1; i > 0 && (long)upper[i] == dims[i]; --i) {
            upper[i] = 0;
            int n2 = i - 1;
            upper[n2] = upper[n2] + 1;
        }
    }

    public static long toMillis(String dateString) {
        return UtilFunctions.toMillis(dateString, UtilFunctions.getDateFormat(dateString));
    }

    public static long toMillis(String dateString, String dateFormat) {
        try {
            return new SimpleDateFormat(dateFormat).parse(dateString).getTime();
        }
        catch (ParseException e) {
            throw new DMLRuntimeException(e);
        }
    }

    public static String dateFormat(String dateString, String outputFormat) {
        try {
            return UtilFunctions.dateFormat(dateString, UtilFunctions.getDateFormat(dateString), outputFormat);
        }
        catch (NullPointerException e) {
            throw new DMLRuntimeException(e);
        }
    }

    public static String dateFormat(String dateString, String inputFormat, String outputFormat) {
        try {
            Date value = new SimpleDateFormat(inputFormat).parse(dateString);
            return new SimpleDateFormat(outputFormat).format(value);
        }
        catch (ParseException e) {
            throw new DMLRuntimeException(e);
        }
    }

    public static String dateFormat(long date, String outputFormat) {
        return new SimpleDateFormat(outputFormat).format(new Date(date));
    }

    public static String[] copyAsStringToArray(String[] input, Object value) {
        Object[] output = new String[input.length];
        Arrays.fill(output, String.valueOf(value));
        return output;
    }

    private static String getDateFormat(String dateString) {
        return DATE_FORMATS.keySet().parallelStream().filter(e -> dateString.toLowerCase().matches((String)e)).findFirst().map(DATE_FORMATS::get).orElseThrow(() -> new NullPointerException("Unknown date format."));
    }

    private static int findDateCol(FrameBlock block) {
        int cols = block.getNumColumns();
        int[] match_counter = new int[cols];
        int dateCol = -1;
        for (int i = 0; i < cols; ++i) {
            String[] values = (String[])block.getColumnData(i);
            int matchCount = 0;
            for (int j = 0; j < values.length; ++j) {
                if (values[j] == null || values[j].trim().isEmpty() || values[j].toUpperCase().equals("NULL") || values[j].equals("0")) continue;
                String tmp = values[j];
                if (!DATE_FORMATS.keySet().parallelStream().anyMatch(e -> tmp.toLowerCase().matches((String)e))) continue;
                ++matchCount;
            }
            match_counter[i] = matchCount;
        }
        int maxMatches = Integer.MIN_VALUE;
        for (int i = 0; i < match_counter.length; ++i) {
            if (match_counter[i] <= maxMatches) continue;
            maxMatches = match_counter[i];
            dateCol = i;
        }
        if (maxMatches <= 0 || dateCol < 0) {
            System.out.println("No date column in the dataset");
        }
        return dateCol;
    }

    public static String isDateColumn(String values) {
        return DATE_FORMATS.keySet().parallelStream().anyMatch(e -> values.toLowerCase().matches((String)e)) ? "1" : "0";
    }

    public static String[] getDominantDateFormat(String[] values) {
        String[] output = new String[values.length];
        Map<String, String> date_formats = DATE_FORMATS;
        HashMap<String, Integer> format_matches = new HashMap<String, Integer>();
        for (Map.Entry<String, String> entry : date_formats.entrySet()) {
            format_matches.put(entry.getValue(), 0);
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].trim().isEmpty() || values[i].equalsIgnoreCase("NULL") || values[i].equals("0")) continue;
            String tmp = values[i];
            System.out.println("tmp " + tmp);
            String dateFormat = UtilFunctions.getDateFormat(tmp);
            format_matches.put(dateFormat, (Integer)format_matches.get(dateFormat) + 1);
        }
        String dominantFormat = (String)((Map.Entry)format_matches.entrySet().stream().max((entry1, entry2) -> (Integer)entry1.getValue() > (Integer)entry2.getValue() ? 1 : -1).get()).getKey();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].trim().isEmpty() || values[i].equalsIgnoreCase("NULL") || values[i].equals("0")) continue;
            String currentFormat = UtilFunctions.getDateFormat(values[i]);
            SimpleDateFormat curr = new SimpleDateFormat(currentFormat, Locale.US);
            try {
                Date date = curr.parse(values[i]);
                if (!currentFormat.equals(dominantFormat)) {
                    curr.applyPattern(dominantFormat);
                }
                output[i] = curr.format(date);
                continue;
            }
            catch (ParseException e) {
                throw new DMLRuntimeException(e);
            }
        }
        return output;
    }

    public static String addTimeToDate(String dateString, int amountToAdd, String timeformat) {
        Date newDate;
        String currentFormat = UtilFunctions.getDateFormat(dateString);
        Date date = null;
        SimpleDateFormat curr = new SimpleDateFormat(currentFormat, Locale.US);
        try {
            date = curr.parse(dateString);
        }
        catch (Exception e) {
            e.getMessage();
        }
        switch (timeformat) {
            case "ms": {
                newDate = DateUtils.addMilliseconds((Date)date, (int)amountToAdd);
                break;
            }
            case "m": {
                newDate = DateUtils.addMinutes((Date)date, (int)amountToAdd);
                break;
            }
            case "H": {
                newDate = DateUtils.addHours((Date)date, (int)amountToAdd);
                break;
            }
            case "d": {
                newDate = DateUtils.addDays((Date)date, (int)amountToAdd);
                break;
            }
            case "w": {
                newDate = DateUtils.addWeeks((Date)date, (int)amountToAdd);
                break;
            }
            case "M": {
                newDate = DateUtils.addMonths((Date)date, (int)amountToAdd);
                break;
            }
            case "y": {
                newDate = DateUtils.addYears((Date)date, (int)amountToAdd);
                break;
            }
            default: {
                newDate = DateUtils.addSeconds((Date)date, (int)amountToAdd);
            }
        }
        return curr.format(newDate);
    }

    public static String[] getTimestamp(String[] values) {
        String[] output = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].trim().isEmpty() || values[i].toUpperCase().equals("NULL") || values[i].equals("0")) continue;
            String currentFormat = UtilFunctions.getDateFormat(values[i]);
            SimpleDateFormat curr = new SimpleDateFormat(currentFormat, Locale.US);
            curr.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                Date date = curr.parse(values[i]);
                output[i] = String.valueOf(date.getTime());
                continue;
            }
            catch (ParseException e) {
                throw new DMLRuntimeException(e);
            }
        }
        return output;
    }

    public static String[] getSplittedStringAsArray(String input) {
        String[] string_array = input.split("'[ ]*,[ ]*'");
        return string_array;
    }

    public static double jaccardSim(String x, String y) {
        LinkedHashSet<String> charsX = new LinkedHashSet<String>(Arrays.asList(x.split("(?!^)")));
        LinkedHashSet<String> charsY = new LinkedHashSet<String>(Arrays.asList(y.split("(?!^)")));
        int sa = charsX.size();
        int sb = charsY.size();
        charsX.retainAll(charsY);
        int intersection = charsX.size();
        return 1.0 / (double)(sa + sb - charsX.size()) * (double)intersection;
    }

    public static String columnStringToCSVString(String input, String separator) {
        String[] string_array;
        int endOfArray;
        StringBuffer sb = new StringBuffer(input);
        StringBuilder outStringBuilder = new StringBuilder();
        int startOfArray = sb.indexOf("\"[");
        if (startOfArray >= 0) {
            sb.delete(startOfArray, startOfArray + 2);
        }
        if ((endOfArray = sb.lastIndexOf("]\"")) >= 0) {
            sb.delete(endOfArray, endOfArray + 2);
        }
        if (sb.indexOf("'") != -1) {
            Pattern p = Pattern.compile(", None,");
            Matcher m = p.matcher(sb);
            string_array = m.replaceAll(", 'None',").split("'[ ]*,[ ]*'");
            string_array[0] = string_array[0].replaceFirst("'", "");
            int lastArrayIndex = string_array.length - 1;
            string_array[lastArrayIndex] = string_array[lastArrayIndex].substring(0, string_array[lastArrayIndex].length() - 1);
        } else {
            string_array = sb.toString().split(",");
        }
        for (String s : string_array) {
            outStringBuilder.append(s).append(separator);
        }
        outStringBuilder.delete(outStringBuilder.length() - separator.length(), outStringBuilder.length());
        return outStringBuilder.toString();
    }

    public static FrameBlock generateRandomFrameBlock(int rows, int cols, Types.ValueType[] schema, Random random) {
        String[] names = new String[cols];
        for (int i = 0; i < cols; ++i) {
            names[i] = schema[i].toString();
        }
        FrameBlock frameBlock = new FrameBlock(schema, names);
        frameBlock.ensureAllocatedColumns(rows);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                frameBlock.set(row, col, UtilFunctions.generateRandomValueFromValueType(schema[col], random));
            }
        }
        return frameBlock;
    }

    public static Object generateRandomValueFromValueType(Types.ValueType valueType, Random random) {
        switch (valueType) {
            case FP32: {
                return Float.valueOf(random.nextFloat());
            }
            case FP64: {
                return random.nextDouble();
            }
            case INT32: {
                return random.nextInt();
            }
            case INT64: {
                return random.nextLong();
            }
            case BOOLEAN: {
                return random.nextBoolean();
            }
            case STRING: {
                return random.ints(97, 123).limit(10L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
            }
        }
        return null;
    }

    public static Types.ValueType[] stringToValueType(String[] schemaValues) {
        Types.ValueType[] vt = new Types.ValueType[schemaValues.length];
        for (int i = 0; i < schemaValues.length; ++i) {
            if (schemaValues[i].equalsIgnoreCase("STRING")) {
                vt[i] = Types.ValueType.STRING;
                continue;
            }
            if (schemaValues[i].equalsIgnoreCase("FP64")) {
                vt[i] = Types.ValueType.FP64;
                continue;
            }
            if (schemaValues[i].equalsIgnoreCase("FP32")) {
                vt[i] = Types.ValueType.FP32;
                continue;
            }
            if (schemaValues[i].equalsIgnoreCase("INT64")) {
                vt[i] = Types.ValueType.INT64;
                continue;
            }
            if (schemaValues[i].equalsIgnoreCase("INT32")) {
                vt[i] = Types.ValueType.INT32;
                continue;
            }
            if (schemaValues[i].equalsIgnoreCase("BOOLEAN")) {
                vt[i] = Types.ValueType.BOOLEAN;
                continue;
            }
            throw new DMLRuntimeException("Invalid column schema. Allowed values are STRING, FP64, FP32, INT64, INT32 and Boolean");
        }
        return vt;
    }

    public static int getEndIndex(int arrayLength, int startIndex, int blockSize) {
        return blockSize <= 0 ? arrayLength : Math.min(arrayLength, startIndex + blockSize);
    }

    public static int[] getBlockSizes(int num, int numBlocks) {
        int[] blockSizes = new int[numBlocks];
        Arrays.fill(blockSizes, num / numBlocks);
        int i = 0;
        while (i < num % numBlocks) {
            int n = i++;
            blockSizes[n] = blockSizes[n] + 1;
        }
        return blockSizes;
    }

    public static String[] splitRecodeEntry(String s) {
        return ColumnEncoderRecode.splitRecodeMapEntry(s);
    }

    public static String[] toStringArray(Object[] original) {
        String[] result = new String[original.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = String.valueOf(original[i]);
        }
        return result;
    }

    public static double[] convertStringToDoubleArray(String[] original) {
        return Arrays.stream(original).mapToDouble(Double::parseDouble).toArray();
    }
}

