/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.operators;

import org.apache.sysds.runtime.functionobjects.CM;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class CMOperator
extends Operator {
    private static final long serialVersionUID = 4126894676505115420L;
    public ValueFunction fn;
    public AggregateOperationTypes aggOpType;

    public CMOperator(ValueFunction op, AggregateOperationTypes agg) {
        super(true);
        this.fn = op;
        this.aggOpType = agg;
    }

    public AggregateOperationTypes getAggOpType() {
        return this.aggOpType;
    }

    public CMOperator setCMAggOp(int order) {
        AggregateOperationTypes agg = CMOperator.getCMAggOpType(order);
        CM fn = CM.getCMFnObject(this.aggOpType);
        return new CMOperator(fn, agg);
    }

    public static AggregateOperationTypes getCMAggOpType(int order) {
        if (order == 2) {
            return AggregateOperationTypes.CM2;
        }
        if (order == 3) {
            return AggregateOperationTypes.CM3;
        }
        if (order == 4) {
            return AggregateOperationTypes.CM4;
        }
        if (order == 0) {
            return AggregateOperationTypes.MEAN;
        }
        return AggregateOperationTypes.INVALID;
    }

    public static AggregateOperationTypes getAggOpType(String fn, String order) {
        if (fn.equalsIgnoreCase("count")) {
            return AggregateOperationTypes.COUNT;
        }
        if (fn.equalsIgnoreCase("sum")) {
            return AggregateOperationTypes.SUM;
        }
        if (fn.equalsIgnoreCase("mean")) {
            return AggregateOperationTypes.MEAN;
        }
        if (fn.equalsIgnoreCase("variance")) {
            return AggregateOperationTypes.VARIANCE;
        }
        if (fn.equalsIgnoreCase("centralmoment")) {
            if (order == null) {
                return AggregateOperationTypes.INVALID;
            }
            if (order.equalsIgnoreCase("2")) {
                return AggregateOperationTypes.CM2;
            }
            if (order.equalsIgnoreCase("3")) {
                return AggregateOperationTypes.CM3;
            }
            if (order.equalsIgnoreCase("4")) {
                return AggregateOperationTypes.CM4;
            }
            return AggregateOperationTypes.INVALID;
        }
        return AggregateOperationTypes.INVALID;
    }

    public boolean isPartialAggregateOperator() {
        boolean ret = false;
        switch (this.aggOpType) {
            case COUNT: 
            case MEAN: {
                ret = true;
                break;
            }
            case CM2: 
            case CM3: 
            case CM4: 
            case VARIANCE: {
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static enum AggregateOperationTypes {
        SUM,
        COUNT,
        MEAN,
        CM2,
        CM3,
        CM4,
        VARIANCE,
        INVALID;

    }
}

