/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.CryptoUtils;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.MapHost;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class OnDiskMapOutput<K, V>
extends MapOutput<K, V> {
    private static final Log LOG = LogFactory.getLog(OnDiskMapOutput.class);
    private final FileSystem fs;
    private final Path tmpOutputPath;
    private final Path outputPath;
    private final MergeManagerImpl<K, V> merger;
    private final OutputStream disk;
    private long compressedSize;

    public OnDiskMapOutput(TaskAttemptID mapId, TaskAttemptID reduceId, MergeManagerImpl<K, V> merger, long size, JobConf conf, MapOutputFile mapOutputFile, int fetcher, boolean primaryMapOutput) throws IOException {
        this(mapId, reduceId, merger, size, conf, mapOutputFile, fetcher, primaryMapOutput, (FileSystem)FileSystem.getLocal((Configuration)conf), mapOutputFile.getInputFileForWrite(mapId.getTaskID(), size));
    }

    @VisibleForTesting
    OnDiskMapOutput(TaskAttemptID mapId, TaskAttemptID reduceId, MergeManagerImpl<K, V> merger, long size, JobConf conf, MapOutputFile mapOutputFile, int fetcher, boolean primaryMapOutput, FileSystem fs, Path outputPath) throws IOException {
        super(mapId, size, primaryMapOutput);
        this.fs = fs;
        this.merger = merger;
        this.outputPath = outputPath;
        this.tmpOutputPath = OnDiskMapOutput.getTempPath(outputPath, fetcher);
        this.disk = CryptoUtils.wrapIfNecessary((Configuration)conf, fs.create(this.tmpOutputPath));
    }

    @VisibleForTesting
    static Path getTempPath(Path outPath, int fetcher) {
        return outPath.suffix(String.valueOf(fetcher));
    }

    @Override
    public void shuffle(MapHost host, InputStream input, long compressedLength, long decompressedLength, ShuffleClientMetrics metrics, Reporter reporter) throws IOException {
        long bytesLeft;
        try {
            int n;
            int BYTES_TO_READ = 65536;
            byte[] buf = new byte[65536];
            for (bytesLeft = compressedLength; bytesLeft > 0L; bytesLeft -= (long)n) {
                n = input.read(buf, 0, (int)Math.min(bytesLeft, 65536L));
                if (n < 0) {
                    throw new IOException("read past end of stream reading " + this.getMapId());
                }
                this.disk.write(buf, 0, n);
                metrics.inputBytes(n);
                reporter.progress();
            }
            LOG.info((Object)("Read " + (compressedLength - bytesLeft) + " bytes from map-output for " + this.getMapId()));
            this.disk.close();
        }
        catch (IOException ioe) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{input, this.disk});
            throw ioe;
        }
        if (bytesLeft != 0L) {
            throw new IOException("Incomplete map output received for " + this.getMapId() + " from " + host.getHostName() + " (" + bytesLeft + " bytes missing of " + compressedLength + ")");
        }
        this.compressedSize = compressedLength;
    }

    @Override
    public void commit() throws IOException {
        this.fs.rename(this.tmpOutputPath, this.outputPath);
        MergeManagerImpl.CompressAwarePath compressAwarePath = new MergeManagerImpl.CompressAwarePath(this.outputPath, this.getSize(), this.compressedSize);
        this.merger.closeOnDiskFile(compressAwarePath);
    }

    @Override
    public void abort() {
        try {
            this.fs.delete(this.tmpOutputPath, false);
        }
        catch (IOException ie) {
            LOG.info((Object)("failure to clean up " + this.tmpOutputPath), (Throwable)ie);
        }
    }

    @Override
    public String getDescription() {
        return "DISK";
    }
}

