/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.sysds.runtime.io.hdf5.H5BTree;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5ContiguousDataset;
import org.apache.sysds.runtime.io.hdf5.H5GroupSymbolTableNode;
import org.apache.sysds.runtime.io.hdf5.H5LocalHeap;
import org.apache.sysds.runtime.io.hdf5.H5ObjectHeader;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.H5RuntimeException;
import org.apache.sysds.runtime.io.hdf5.H5Superblock;
import org.apache.sysds.runtime.io.hdf5.H5SymbolTableEntry;
import org.apache.sysds.runtime.io.hdf5.Utils;
import org.apache.sysds.runtime.io.hdf5.message.H5SymbolTableMessage;

public class H5 {
    public static H5RootObject H5Fopen(BufferedInputStream bis) {
        H5RootObject rootObject = new H5RootObject();
        bis.mark(0);
        try {
            int maxSignatureLength = 2048;
            boolean validSignature = false;
            long offset = 0L;
            while (offset < (long)maxSignatureLength && !(validSignature = H5Superblock.verifySignature(bis, offset))) {
                offset = H5.nextOffset(offset);
            }
            if (!validSignature) {
                throw new H5RuntimeException("No valid HDF5 signature found");
            }
            rootObject.setBufferedInputStream(bis);
            H5Superblock superblock = new H5Superblock(bis, offset);
            rootObject.setSuperblock(superblock);
        }
        catch (Exception exception) {
            throw new H5RuntimeException("Can't open fine " + exception);
        }
        return rootObject;
    }

    private static long nextOffset(long offset) {
        if (offset == 0L) {
            return 512L;
        }
        return offset * 2L;
    }

    public static H5RootObject H5Screate(BufferedOutputStream bos, long row, long col) {
        try {
            H5RootObject rootObject = new H5RootObject();
            rootObject.setBufferedOutputStream(bos);
            rootObject.bufferBuilder = new H5BufferBuilder();
            H5Superblock superblock = new H5Superblock();
            superblock.versionOfSuperblock = 0;
            superblock.versionNumberOfTheFileFreeSpaceInformation = 0;
            superblock.versionOfRootGroupSymbolTableEntry = 0;
            superblock.versionOfSharedHeaderMessageFormat = 0;
            superblock.sizeOfOffsets = 8;
            superblock.sizeOfLengths = 8;
            superblock.groupLeafNodeK = 4;
            superblock.groupInternalNodeK = 16;
            superblock.baseAddressByte = 0L;
            superblock.addressOfGlobalFreeSpaceIndex = -1L;
            superblock.endOfFileAddress = 2048L + row * col * 8L;
            superblock.driverInformationBlockAddress = -1L;
            superblock.rootGroupSymbolTableAddress = 56L;
            rootObject.setSuperblock(superblock);
            rootObject.setRank(2);
            rootObject.setCol(col);
            rootObject.setRow(row);
            superblock.toBuffer(rootObject.bufferBuilder);
            H5SymbolTableEntry symbolTableEntry = new H5SymbolTableEntry(rootObject);
            symbolTableEntry.toBuffer(rootObject.bufferBuilder);
            return rootObject;
        }
        catch (Exception exception) {
            throw new H5RuntimeException(exception);
        }
    }

    public static H5ContiguousDataset H5Dopen(H5RootObject rootObject, String datasetName) {
        try {
            H5SymbolTableEntry symbolTableEntry = new H5SymbolTableEntry(rootObject, rootObject.getSuperblock().rootGroupSymbolTableAddress - rootObject.getSuperblock().baseAddressByte);
            H5ObjectHeader objectHeader = new H5ObjectHeader(rootObject, symbolTableEntry.getObjectHeaderAddress());
            H5SymbolTableMessage stm = (H5SymbolTableMessage)objectHeader.getMessages().get(0);
            H5BTree rootBTreeNode = new H5BTree(rootObject, stm.getbTreeAddress());
            H5LocalHeap rootNameHeap = new H5LocalHeap(rootObject, stm.getLocalHeapAddress());
            ByteBuffer nameBuffer = rootNameHeap.getDataBuffer();
            List<Long> childAddresses = rootBTreeNode.getChildAddresses();
            long child = childAddresses.get(0);
            H5GroupSymbolTableNode groupSTE = new H5GroupSymbolTableNode(rootObject, child);
            symbolTableEntry = groupSTE.getSymbolTableEntries()[0];
            nameBuffer.position(symbolTableEntry.getLinkNameOffset());
            String childName = Utils.readUntilNull(nameBuffer);
            if (!childName.equals(datasetName)) {
                throw new H5RuntimeException("The dataset name '" + datasetName + "' not found!");
            }
            H5ObjectHeader header = new H5ObjectHeader(rootObject, symbolTableEntry.getObjectHeaderAddress());
            H5ContiguousDataset contiguousDataset = new H5ContiguousDataset(rootObject, header);
            return contiguousDataset;
        }
        catch (Exception exception) {
            throw new H5RuntimeException(exception);
        }
    }

    public static void H5Dcreate(H5RootObject rootObject, long maxRow, long maxCol, String datasetName) {
        if (rootObject.getRank() != 2) {
            throw new H5RuntimeException("Just support Matrix!");
        }
        rootObject.setMaxRow(maxRow);
        rootObject.setMaxCol(maxCol);
        rootObject.setDatasetName(datasetName);
        H5ObjectHeader objectHeader = new H5ObjectHeader(rootObject, datasetName);
        objectHeader.toBuffer(rootObject.bufferBuilder);
        rootObject.bufferBuilder.goToPositionWithWriteZero(2048L);
    }

    public static void H5WriteHeaders(H5RootObject rootObject) {
        try {
            rootObject.getBufferedOutputStream().write(rootObject.bufferBuilder.build().array());
        }
        catch (Exception exception) {
            throw new H5RuntimeException(exception);
        }
    }

    public static void H5Dwrite(H5RootObject rootObject, double[] data) {
        try {
            H5BufferBuilder bb = new H5BufferBuilder();
            double[] dArray = data;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double d = dArray[i];
                bb.writeDouble(d);
            }
            rootObject.getBufferedOutputStream().write(bb.noOrderBuild().array());
        }
        catch (Exception exception) {
            throw new H5RuntimeException(exception);
        }
    }

    public static void H5Dwrite(H5RootObject rootObject, double[][] data) {
        int i = 0;
        while ((long)i < rootObject.getRow()) {
            H5.H5Dwrite(rootObject, data[i]);
            ++i;
        }
    }

    public static void H5Dread(H5RootObject rootObject, H5ContiguousDataset dataset, double[][] data) {
        int i = 0;
        while ((long)i < rootObject.getRow()) {
            ByteBuffer buffer = dataset.getDataBuffer(i);
            dataset.getDataType().getDoubleDataType().fillData(buffer, data[i]);
            ++i;
        }
    }

    public static void H5Dread(H5ContiguousDataset dataset, int row, double[] data) {
        ByteBuffer buffer = dataset.getDataBuffer(row);
        dataset.getDataType().getDoubleDataType().fillData(buffer, data);
    }
}

