/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

class LinearRegression {
    private final double intercept;
    private final double coef;

    public LinearRegression(double[] x, double[] y) {
        int n = x.length;
        double sum_x = 0.0;
        double sum_y = 0.0;
        double xx = 0.0;
        double yy = 0.0;
        for (int i = 0; i < n; ++i) {
            sum_x += x[i];
            sum_y += y[i];
        }
        double x_tmp = sum_x / (double)n;
        double y_tmp = sum_y / (double)n;
        for (int i = 0; i < n; ++i) {
            xx += (x[i] - x_tmp) * (x[i] - x_tmp);
            yy += (x[i] - x_tmp) * (y[i] - y_tmp);
        }
        this.coef = yy / xx;
        this.intercept = y_tmp - this.coef * x_tmp;
    }

    public double intercept() {
        return this.intercept;
    }

    public double coef() {
        return this.coef;
    }
}

