/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.executors.queues;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Condition;
import org.apache.synapse.commons.executors.InternalQueue;

public class UnboundedQueue<E>
extends AbstractQueue<E>
implements InternalQueue<E> {
    private List<E> elements = new ArrayList();
    private int priority;
    private Condition notFullCond;

    public UnboundedQueue(int priority) {
        this.priority = priority;
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean offer(E e) {
        return this.elements.add(e);
    }

    @Override
    public E poll() {
        if (this.elements.size() > 0) {
            return this.elements.remove(this.elements.size() - 1);
        }
        return null;
    }

    @Override
    public E peek() {
        if (this.elements.size() > 0) {
            return this.elements.get(this.elements.size() - 1);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int p) {
        this.priority = p;
    }

    @Override
    public Condition getNotFullCond() {
        return this.notFullCond;
    }

    @Override
    public void setNotFullCond(Condition condition) {
        this.notFullCond = condition;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        int count = this.elements.size();
        c.addAll(this.elements);
        this.elements.clear();
        return count;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (maxElements >= this.elements.size()) {
            return this.drainTo(c);
        }
        this.elements.subList(this.elements.size() - maxElements - 1, this.elements.size());
        return maxElements;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o);
    }
}

