/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts2.convention;

/**
 * Constants used to extend the Convention plugin
 */
public class ConventionConstants {
    public static final String CONVENTION_ACTION_CONFIG_BUILDER = "struts.convention.actionConfigBuilder";
    public static final String CONVENTION_ACTION_NAME_BUILDER = "struts.convention.actionNameBuilder";
    public static final String CONVENTION_RESULT_MAP_BUILDER = "struts.convention.resultMapBuilder";
    public static final String CONVENTION_INTERCEPTOR_MAP_BUILDER = "struts.convention.interceptorMapBuilder";
    public static final String CONVENTION_CONVENTIONS_SERVICE = "struts.convention.conventionsService";
    public static final String CONVENTION_ACTION_NAME_LOWERCASE = "struts.convention.action.name.lowercase";
    public static final String CONVENTION_ACTION_NAME_SEPARATOR = "struts.convention.action.name.separator";
    public static final String CONVENTION_ACTION_SUFFIX = "struts.convention.action.suffix";
    public static final String CONVENTION_CLASSES_RELOAD = "struts.convention.classes.reload";
    public static final String CONVENTION_RESULT_PATH = "struts.convention.result.path";
    public static final String CONVENTION_DEFAULT_PARENT_PACKAGE = "struts.convention.default.parent.package";
    public static final String CONVENTION_REDIRECT_TO_SLASH = "struts.convention.redirect.to.slash";
    public static final String CONVENTION_RELATIVE_RESULT_TYPES = "struts.convention.relative.result.types";
    public static final String CONVENTION_EXCLUDE_PARENT_CLASS_LOADER = "struts.convention.exclude.parentClassLoader";
    public static final String CONVENTION_ACTION_ALWAYS_MAP_EXECUTE = "struts.convention.action.alwaysMapExecute";
    public static final String CONVENTION_ACTION_FILE_PROTOCOLS = "struts.convention.action.fileProtocols";
    public static final String CONVENTION_ACTION_DISABLE_SCANNING = "struts.convention.action.disableScanning";
    public static final String CONVENTION_ACTION_INCLUDE_JARS = "struts.convention.action.includeJars";
    public static final String CONVENTION_PACKAGE_LOCATORS_DISABLE = "struts.convention.package.locators.disable";
    public static final String CONVENTION_ACTION_PACKAGES = "struts.convention.action.packages";
    public static final String CONVENTION_ACTION_CHECK_IMPLEMENTS_ACTION = "struts.convention.action.checkImplementsAction";
    public static final String CONVENTION_EXCLUDE_PACKAGES = "struts.convention.exclude.packages";
    public static final String CONVENTION_PACKAGE_LOCATORS = "struts.convention.package.locators";
    public static final String CONVENTION_PACKAGE_LOCATORS_BASE_PACKAGE = "struts.convention.package.locators.basePackage";
    public static final String CONVENTION_ACTION_MAP_ALL_MATCHES = "struts.convention.action.mapAllMatches";
    public static final String CONVENTION_ACTION_EAGER_LOADING = "struts.convention.action.eagerLoading";
    public static final String CONVENTION_RESULT_FLAT_LAYOUT = "struts.convention.result.flatLayout";
    /** Enables the inheritance of the SMI value from a parent package config to its children */
    public static final String CONVENTION_ENABLE_SMI_INHERITANCE = "struts.convention.enable.smi.inheritance";
}
