/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.inject.Container;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.views.JspSupportServlet;
import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.apache.struts2.views.freemarker.FreemarkerResult;
import org.apache.struts2.views.freemarker.StrutsBeanWrapper;
import org.apache.tiles.core.impl.InvalidTemplateException;
import org.apache.tiles.freemarker.template.TilesFMModelRepository;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.render.Renderer;
import org.apache.tiles.request.servlet.ServletUtil;

public class StrutsFreeMarkerAttributeRenderer
implements Renderer {
    private static final Logger LOG = LogManager.getLogger(StrutsFreeMarkerAttributeRenderer.class);

    @Override
    public void render(String path, Request request) throws IOException {
        if (path != null) {
            LOG.trace("Rendering freemarker tile [{}]", (Object)path);
            ActionContext ctx = this.readActionContext(request);
            this.registerTilesBeanModel(ctx);
            FreemarkerResult result = new FreemarkerResult(path);
            result.setWriter(request.getWriter());
            Container container = ctx.getContainer();
            container.inject((Object)result);
            try {
                ActionInvocation invocation = ctx.getActionInvocation();
                result.doExecute(path, invocation);
            }
            catch (TemplateException e) {
                LOG.error("Exception was thrown during rendering value {}: {}", (Object)path, (Object)e.getMessage());
                throw new InvalidTemplateException(e);
            }
        } else {
            LOG.error("Path is null, cannot render template!");
            throw new InvalidTemplateException("Cannot render a null template");
        }
    }

    protected ActionContext readActionContext(Request request) {
        LOG.debug("Obtaining HttpServletRequest based on [{}]", (Object)request.getClass().getName());
        HttpServletRequest httpRequest = ServletUtil.getServletRequest(request).getRequest();
        ActionContext ctx = ServletActionContext.getActionContext((HttpServletRequest)httpRequest);
        if (ctx == null) {
            LOG.error("Cannot obtain HttpServletRequest from [{}]", (Object)request.getClass().getName());
            throw new ConfigurationException("There is no ActionContext for current request!");
        }
        return ctx;
    }

    @Override
    public boolean isRenderable(String path, Request request) {
        LOG.trace("Checking if path [{}] can be rendered", (Object)path);
        return path != null && path.startsWith("/") && path.endsWith(".ftl");
    }

    protected void registerTilesBeanModel(ActionContext ctx) {
        ServletContext servletContext = ServletActionContext.getServletContext();
        Configuration configuration = ((FreemarkerManager)ctx.getInstance(FreemarkerManager.class)).getConfiguration(servletContext);
        StrutsBeanWrapper wrapper = (StrutsBeanWrapper)((FreemarkerManager)ctx.getInstance(FreemarkerManager.class)).getWrapper();
        LOG.trace("Adding support for Tiles tags, please remember to register {} in web.xml!", (Object)JspSupportServlet.class.getName());
        BeanModel tilesBeanModel = new BeanModel((Object)new TilesFMModelRepository(), (BeansWrapper)wrapper);
        configuration.setSharedVariable("tiles", (TemplateModel)tilesBeanModel);
    }
}

