/*
 * Decompiled with CFR 0.152.
 */
package com.google.transconsole.common.messages;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Objects;
import com.google.transconsole.common.messages.BaseMessage;
import com.google.transconsole.common.messages.BundleFormat;
import com.google.transconsole.common.messages.InvalidMessageException;
import com.google.transconsole.common.messages.MessageFragment;
import com.google.transconsole.common.messages.MessageProperties;
import com.google.transconsole.common.messages.MessageUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class Message
extends BaseMessage {
    private final MessageProperties properties;

    Message(List<MessageFragment> fragments, MessageProperties properties) {
        super(null, fragments);
        this.properties = new MessageProperties(properties);
    }

    Message(String id, List<MessageFragment> fragments, MessageProperties properties) {
        super(id, fragments);
        this.properties = new MessageProperties(properties);
    }

    public String getOriginal() {
        StringBuilder sb = new StringBuilder();
        for (MessageFragment f : this.fragments) {
            sb.append(f.getOriginal());
        }
        return sb.toString();
    }

    private void appendSource(StringBuilder sb) {
        for (String source : this.properties.getSources()) {
            sb.append("<source>");
            sb.append(CharEscapers.xmlContentEscaper().escape(source));
            sb.append("</source>");
        }
    }

    @Override
    protected String getFragmentsAsXml() {
        StringBuilder sb = new StringBuilder();
        for (MessageFragment f : this.fragments) {
            sb.append(f.toXml(BundleFormat.XMB));
        }
        return sb.toString();
    }

    @Override
    public String toXml() {
        String collapsedContentXml;
        String contentXml;
        StringBuilder sb = new StringBuilder();
        sb.append("<msg");
        this.appendAttribute(sb, "id", this.getId());
        this.appendAttribute(sb, "desc", this.properties.getDescription());
        this.appendAttribute(sb, "meaning", this.properties.getMeaning());
        this.appendAttribute(sb, "name", this.properties.getName());
        if (this.properties.isHidden()) {
            this.appendAttribute(sb, "is_hidden", "1");
        }
        if (this.properties.isObsolete()) {
            this.appendAttribute(sb, "obsolete", "obsolete");
        }
        if (!(contentXml = this.getFragmentsAsXml()).equals(collapsedContentXml = this.collapseXml(contentXml))) {
            this.appendAttribute(sb, "xml:space", "preserve");
        }
        sb.append(">");
        this.appendSource(sb);
        sb.append(contentXml);
        sb.append("</msg>");
        return sb.toString();
    }

    @Override
    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        return MessageUtil.generateMessageId(this.getPresentation(), this.getMeaning(), this.getContentType());
    }

    public String getContentType() {
        return this.properties.getContentType();
    }

    public String getDescription() {
        return this.properties.getDescription();
    }

    public String getMeaning() {
        return this.properties.getMeaning();
    }

    public Set<String> getSources() {
        return Collections.unmodifiableSet(this.properties.getSources());
    }

    public String getName() {
        return this.properties.getName();
    }

    public boolean isHidden() {
        return this.properties.isHidden();
    }

    public boolean isObsolete() {
        return this.properties.isObsolete();
    }

    public Message merge(Message that) throws InvalidMessageException {
        MessageProperties mergedProperties;
        String thatId;
        String id = this.getId();
        if (!Objects.equal(id, thatId = that.getId())) {
            throw new IllegalArgumentException("Cannot merge messages with different IDs: " + id + " != " + thatId);
        }
        if (!this.fragments.equals(that.fragments)) {
            throw new InvalidMessageException(id, "Cannot merge messages with different content.");
        }
        try {
            mergedProperties = this.properties.merge(that.properties);
        }
        catch (InvalidMessageException ive) {
            throw new InvalidMessageException(id, ive.getMessage());
        }
        return new Message(this.fragments, mergedProperties);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.fragments, this.properties);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Message)) {
            return false;
        }
        Message otherMsg = (Message)other;
        return Objects.equal(this.id, otherMsg.id) && Objects.equal(this.fragments, otherMsg.fragments) && Objects.equal(this.properties, otherMsg.properties);
    }

    public String toString() {
        return "[" + this.getPresentation() + "] [" + this.getMeaning() + "] [" + this.getContentType() + "]";
    }
}

